#include "stdafx.h"
#include "Model.h"

/**
	Default constructor
*/
MhsModel::FieldTrip::FieldTrip(void)
{

	name = "FieldTrip1";
	fieldbiologists = new ArrayList();
	waypoints = new ArrayList();
}

MhsModel::FieldTrip::~FieldTrip(void)
{
}

String __gc* MhsModel::FieldTrip::toString()
{
	System::Text::StringBuilder __gc* sb = new System::Text::StringBuilder;

	sb->Append(name);
	sb->Append(",");

	for(int x=0;x<fieldbiologists->Count;x++)
	{
		String __gc* tmpFB = static_cast<String*>(fieldbiologists->Item[x]);

		sb->Append(tmpFB);
		sb->Append(",");
	}

	sb->Append("\n");

	for(int y=0;y<waypoints->Count;y++)
	{
		Waypoint __gc* tmpWP = static_cast<Waypoint*>(waypoints->Item[y]);

		sb->Append(tmpWP->toString());
		sb->Append("\n");
	}

	return sb->ToString();
}

String __gc* MhsModel::FieldTrip::unitTest()
{
	FieldTrip __gc* ft = new FieldTrip();
	StringBuilder __gc* sb = new StringBuilder();
	Vector3 __nogc* OneTwoThree = __nogc new Vector3(1.0f,2.0f,3.0f);
	Vector3 __nogc* zeroVector = __nogc new Vector3(0.0f,0.0f,0.0f);


	// add some biologists to the field trip, 
	// maybe this should have a wrapper method?
	ft->fieldbiologists->Add(S"Biologist A");
	ft->fieldbiologists->Add(S"Biologist B");
	ft->fieldbiologists->Add(S"Biologist C");

	// Add some waypoints
	Waypoint * wp1 = new Waypoint();
	wp1->name="Waypoint1";
	wp1->habitatType="HabitatType1";
	wp1->latitude=1.0;
	wp1->longitude=1.0;
	wp1->addPlantPatch(new PlantPatch());
	wp1->addPlantPatch(new PlantPatch());
	wp1->addPlantPatch(new PlantPatch());
	ft->waypoints->Add(static_cast<Object*>(wp1));

	Waypoint * wp2 = new Waypoint();
	wp2->name="Waypoint2";
	wp2->habitatType="HabitatType2";
	wp2->latitude=1.0;
	wp2->longitude=1.0;
	wp2->addPlantPatch(new PlantPatch());
	wp2->addPlantPatch(new PlantPatch());
	wp2->addPlantPatch(new PlantPatch());
	ft->waypoints->Add(static_cast<Object*>(wp2));

	Waypoint * wp3 = new Waypoint();
	wp3->name="Waypoint3";
	wp3->habitatType="HabitatType3";
	wp3->latitude=1.0;
	wp3->longitude=1.0;
	wp3->addPlantPatch(new PlantPatch());
	wp3->addPlantPatch(new PlantPatch());
	wp3->addPlantPatch(new PlantPatch());
	ft->waypoints->Add(static_cast<Object*>(wp3));

	// Max, Waypoint management method tests
	sb->Append("Getting number of Waypoints of the Field Trip (getWaypointCount):\n");
	sb->Append(ft->getWaypointCount(2).ToString());
	sb->Append("\nSetting Waypoint3 name to 'The Best Place'...\n");
	ft->setWaypointName(2, S"The Best Place");
	sb->Append("The new name for the Waypoint3 is ");
	sb->Append(ft->getWaypointName(2));
	sb->Append("\nGetting Waypoint3 Habitat Type: ");
	sb->Append(ft->getWaypointHabitatType(2));
	sb->Append("\nWaypoint3 lat: ");
	sb->Append(ft->getWaypointLatitude(2));
	sb->Append("\nWaypoint3 lon: ");
	sb->Append(ft->getWaypointLongitude(2));
	sb->Append("\nSetting Waypoint3 startTime to July 17, 2007, 3:15AM...\n");
	System::DateTime newTime = DateTime(2007,7,17,3,15,0);
	ft->setWaypointStartTime(2, newTime);
	sb->Append("The new startTime for the Waypoint3 is ");
	sb->Append(ft->getWaypointStartTime(2).ToString());
	sb->Append("\nFinished testing Waypoint3... \n\n");

	// Chris, PlantPatch management method tests
	//////////////////////////////////////////////////////////////////////////////////////////
	// Add some plantpatches
	PlantPatch * pp0 = new PlantPatch();
	PlantPatch * pp1 = new PlantPatch();
	PlantPatch * pp2 = new PlantPatch();

	// set pp attributes
	pp0->name="pp0";
	pp0->species="species_0";
	pp0->diameter=1.0;
	pp0->distance=1.0;

	pp1->name="pp1";
	pp1->species="species_1";
	pp1->diameter=1.0;
	pp1->distance=1.0;

	pp2->name="pp2";
	pp2->species="species_2";
	pp2->diameter=1.0;
	pp2->distance=1.0;

	// check to see that all atributes are appended correctly

	sb->Append("BEGIN: PlantPatch unitTest()");
	sb->Append(pp0->toString());
	sb->Append(pp1->toString());
	sb->Append(pp2->toString());


	// plantpatch method tests

	wp1->addPlantPatch(pp0);
	wp1->addPlantPatch(pp1);
	wp1->addPlantPatch(pp2);

	wp2->addPlantPatch(pp0);
	wp2->addPlantPatch(pp1);
	wp2->addPlantPatch(pp2);

	wp3->addPlantPatch(pp0);
	wp3->addPlantPatch(pp1);
	wp3->addPlantPatch(pp2);

/////////////////////////////////////////////////////////////////////////////////////////////////

	// Jim, CYG management method tests
	sb->Append("BEGIN CYG Management Methods Unit Test\n");
	//void setCygBase(int wp_idx, int pp_idx, int cyg_idx, Vector3 __gc* b3d);
	sb->Append("set/getCygBase() tests\n");
	for( int wp_idx = 0; wp_idx < 3; wp_idx++)
	{
		for( int pp_idx = 0; pp_idx < 3; pp_idx++)
		{
				for( int cyg_idx = 0; cyg_idx < CYGCOUNT; cyg_idx++)
				{
					ft->setCygBase( wp_idx, pp_idx, cyg_idx, OneTwoThree);
				}

		}
	}
	sb->Append(ft->toString());
	//Vector3 __gc* getCygBase(int wp_idx, int pp_idx, int cyg_idx);
	for( int wp_idx = 0; wp_idx < 3; wp_idx++)
	{
		for( int pp_idx = 0; pp_idx < 3; pp_idx++)
		{
				for( int cyg_idx = 0; cyg_idx < CYGCOUNT; cyg_idx++)
				{
					Vector3 __gc* tmpD3d = ft->getCygBase( wp_idx, pp_idx, cyg_idx);
					if(		tmpD3d->X != OneTwoThree->X ||
							tmpD3d->Y != OneTwoThree->Y ||
							tmpD3d->Z != OneTwoThree->Z )
					{
						System::Console::WriteLine("Failed Unit Test of 'Vector3 __gc* getCygBase(int wp_idx, int pp_idx, int cyg_idx)'");
						exit(-1);
					}
					else
					{
						sb->Append("getCygBase(");
						sb->Append(wp_idx);
						sb->Append(",");
						sb->Append(pp_idx);
						sb->Append(",");
						sb->Append(cyg_idx);
						sb->Append(") success\n");
					}
					ft->setCygBase( wp_idx, pp_idx, cyg_idx, zeroVector);
				}

		}
	}
	//void setCygTip(int wp_idx, int pp_idx, int cyg_idx, Vector3 __gc* t3d);
	sb->Append("set/getCygTip() tests\n");
	for( int wp_idx = 0; wp_idx < 3; wp_idx++)
	{
		for( int pp_idx = 0; pp_idx < 3; pp_idx++)
		{
				for( int cyg_idx = 0; cyg_idx < CYGCOUNT; cyg_idx++)
				{
					ft->setCygTip( wp_idx, pp_idx, cyg_idx, OneTwoThree);
				}

		}
	}
	sb->Append(ft->toString());
	//Vector3 __gc* getCygTip(int wp_idx, int pp_idx, int cyg_idx);
	for( int wp_idx = 0; wp_idx < 3; wp_idx++)
	{
		for( int pp_idx = 0; pp_idx < 3; pp_idx++)
		{
				for( int cyg_idx = 0; cyg_idx < CYGCOUNT; cyg_idx++)
				{
					Vector3 __gc* tmpD3d = ft->getCygTip( wp_idx, pp_idx, cyg_idx);
					if(		tmpD3d->X != OneTwoThree->X ||
							tmpD3d->Y != OneTwoThree->Y ||
							tmpD3d->Z != OneTwoThree->Z )
					{
						System::Console::WriteLine("Failed Unit Test of 'Vector3 __gc* getCygTip(int wp_idx, int pp_idx, int cyg_idx)'");
						exit(-1);
					}
					else
					{
						sb->Append("getCygTip(");
						sb->Append(wp_idx);
						sb->Append(",");
						sb->Append(pp_idx);
						sb->Append(",");
						sb->Append(cyg_idx);
						sb->Append(") success\n");
					}
					ft->setCygTip( wp_idx, pp_idx, cyg_idx, zeroVector);
				}

		}
	}
	//void setCygRef(int wp_idx, int pp_idx, int cyg_idx, Vector3 __gc* t3d);
	sb->Append("set/getCygRef() tests\n");
	for( int wp_idx = 0; wp_idx < 3; wp_idx++)
	{
		for( int pp_idx = 0; pp_idx < 3; pp_idx++)
		{
				for( int cyg_idx = 0; cyg_idx < CYGCOUNT; cyg_idx++)
				{
					ft->setCygRef( wp_idx, pp_idx, cyg_idx, OneTwoThree);
				}

		}
	}
	sb->Append(ft->toString());
	//Vector3 __gc* getCygRef(int wp_idx, int pp_idx, int cyg_idx);
	for( int wp_idx = 0; wp_idx < 3; wp_idx++)
	{
		for( int pp_idx = 0; pp_idx < 3; pp_idx++)
		{
				for( int cyg_idx = 0; cyg_idx < CYGCOUNT; cyg_idx++)
				{
					Vector3 __gc* tmpD3d = ft->getCygRef( wp_idx, pp_idx, cyg_idx);
					if(		tmpD3d->X != OneTwoThree->X ||
							tmpD3d->Y != OneTwoThree->Y ||
							tmpD3d->Z != OneTwoThree->Z )
					{
						System::Console::WriteLine("Failed Unit Test of 'Vector3 __gc* getCygRef(int wp_idx, int pp_idx, int cyg_idx)'");
						exit(-1);
					}
					else
					{
						sb->Append("getCygRef(");
						sb->Append(wp_idx);
						sb->Append(",");
						sb->Append(pp_idx);
						sb->Append(",");
						sb->Append(cyg_idx);
						sb->Append(") success\n");
					}
					ft->setCygRef( wp_idx, pp_idx, cyg_idx, zeroVector);
				}

		}
	}

	//void setCygDiameter(int wp_idx, int pp_idx, int cyg_idx, float diam);
	sb->Append("set/getCygDiameter() tests\n");
	for( int wp_idx = 0; wp_idx < 3; wp_idx++)
	{
		for( int pp_idx = 0; pp_idx < 3; pp_idx++)
		{
				for( int cyg_idx = 0; cyg_idx < CYGCOUNT; cyg_idx++)
				{
					ft->setCygDiameter( wp_idx, pp_idx, cyg_idx, 123.0f );
				}

		}
	}
	sb->Append(ft->toString());
	//float getCygDiameter(int wp_idx, int pp_idx, int cyg_idx);
	for( int wp_idx = 0; wp_idx < 3; wp_idx++)
	{
		for( int pp_idx = 0; pp_idx < 3; pp_idx++)
		{
				for( int cyg_idx = 0; cyg_idx < CYGCOUNT; cyg_idx++)
				{
					float tmpFloat = ft->getCygDiameter( wp_idx, pp_idx, cyg_idx);
					if( tmpFloat != 123 )
					{
						System::Console::WriteLine("Failed Unit Test of 'float getCygDiameter(int wp_idx, int pp_idx, int cyg_idx)'");
						exit(-1);
					}
					else
					{
						sb->Append("getCygDiameter(");
						sb->Append(wp_idx);
						sb->Append(",");
						sb->Append(pp_idx);
						sb->Append(",");
						sb->Append(cyg_idx);
						sb->Append(") success\n");
					}
					ft->setCygDiameter( wp_idx, pp_idx, cyg_idx, 0.0f);
				}

		}
	}

	return sb->ToString();
}

String __gc* MhsModel::FieldTrip::toExport()
{
	System::Text::StringBuilder __gc* sb = new StringBuilder();

	for(int x=0;x<waypoints->Count;x++)
	{
		Waypoint __gc* tmpWP = static_cast<Waypoint*>(waypoints->Item[x]);
		sb->Append(tmpWP->toExport());
		sb->Append(",");
	}

	return sb->ToString();
}


// Waypoint methods
//waypoint methods
/**
* Returns number of Waypoints from the FieldTrip by a given index;<br>
* @param int wp_idx - <b>index</b> of the Waypoint to return count.
*/
int MhsModel::FieldTrip::getWaypointCount(int wp_idx)
{
	return waypoints->Count;
}
/**
* Sets a new name for the given Waypoint;<br>
* @param int wp_idx - <b>index</b> of the waypoint to set new name for;
* @param String newName - <b>new name</b> to be set for the Waypoint;
*/
void MhsModel::FieldTrip::setWaypointName(int wp_idx, String __gc* newName)
{
	Waypoint __gc* tmpWp = static_cast<Waypoint*>(waypoints->Item[wp_idx]);
	tmpWp->name = newName;
}
/**
* Gets Waypoint's name by a given index;<br>
*@return - String representation of the Waypoint's name;
*@param int wp_idx - <b>index</b> of the waypoint to get the name;
*/
String __gc* MhsModel::FieldTrip::getWaypointName(int wp_idx)
{
	Waypoint __gc* tmpWp = static_cast<Waypoint*>(waypoints->Item[wp_idx]);
	return tmpWp->name;
}
/**
* Gets Waypoint's habitat type by a given index;<br>
*@return - String representation of Waypoint's habitat type;
*@param int wp_idx - <b>index</b> of the waypoint to get the name;
*/
String __gc* MhsModel::FieldTrip::getWaypointHabitatType(int wp_idx)
{
	Waypoint __gc* tmpWp = static_cast<Waypoint*>(waypoints->Item[wp_idx]);
	return tmpWp->habitatType;
}
/**
* Gets Waypoint's Latitude coordinate by a given index;<br>
*@return - float number representation of Waypoint's latitude coordinate;
*@param int wp_idx - <b>index</b> of the waypoint to get latitude;
*/
float MhsModel::FieldTrip::getWaypointLatitude(int wp_idx)
{
	Waypoint __gc* tmpWp = static_cast<Waypoint*>(waypoints->Item[wp_idx]);
	return tmpWp->latitude;
}
/**
* Gets Waypoint's Longitude coordinate by a given index;<br>
*@return - float number representation of Waypoint's longitude coordinate;
*@param int wp_idx - <b>index</b> of the waypoint to get longitude;
*/
float MhsModel::FieldTrip::getWaypointLongitude(int wp_idx)
{
	Waypoint __gc* tmpWp = static_cast<Waypoint*>(waypoints->Item[wp_idx]);
	return tmpWp->longitude;
}
/**
* Sets Waypoint's processing start time;<br>
*@param int wp_idx - <b>index</b> of the waypoint to set start time for;
*@param DateTime - start <b>date/time</b> for the Waypoint's processing;
*/
void MhsModel::FieldTrip::setWaypointStartTime(int wp_idx, DateTime dt)
{
	Waypoint __gc* tmpWp = static_cast<Waypoint*>(waypoints->Item[wp_idx]);
	tmpWp->startTime = dt;
}
/**
* Gets Waypoint's processing start time by a given index;<br>
*@return - DateTime representation of Waypoint's processing start time;
*@param int wp_idx - <b>index</b> of the waypoint to get the start time for;
*/
DateTime MhsModel::FieldTrip::getWaypointStartTime(int wp_idx)
{
	Waypoint __gc* tmpWp = static_cast<Waypoint*>(waypoints->Item[wp_idx]);
	return tmpWp->startTime;
}




// PlantPatch methods

/** adds a PlantPatch to Waypoint.
* @param int wp_idx - <b>waypoint index</b> the index of the waypoint to add to;
* @param String newName - <b>New Name</b> the name of the new PlantPatch;
* @param String newSpecies - <b>New Species</b> the name of the Species;
* @return - none.
*/
void MhsModel::FieldTrip::addPlantPatch( int wp_idx, String __gc* newName, String __gc* newSpecies)
{
	Waypoint __gc* tmpWp = static_cast<Waypoint*>(waypoints->Item[wp_idx]);
	PlantPatch __gc* tmpPp = new PlantPatch();
	tmpPp->name = newName;
	tmpPp->species = newSpecies;
	tmpWp->addPlantPatch( tmpPp );
}

/** delete a PlantPatch from Waypoint.
* @param int wp_idx - <b>waypoint index</b> the index of the waypoint to delete from;
* @param int pp_idx - <b>plantpatch index</b> the index of the plantpatch to delete;
* @return - none.
*/

void MhsModel::FieldTrip::delPlantPatch( int wp_idx, int pp_idx)
{
	Waypoint __gc* tmpWp = static_cast<Waypoint*>(waypoints->Item[wp_idx]);
	tmpWp->delPlantPatch(pp_idx);
}

/** Sets a plantpatch name.
* @param int wp_idx - <b>waypoint index</b> the index of the waypoint;
* @param int pp_idx - <b>plantpatch index</b> the index of the plantpatch;
* @param String newName - <b>New Name</b> the new name for the plantpatch;
* @return - none.
*/

void MhsModel::FieldTrip::setPlantPatchName(int wp_idx, int pp_idx, String __gc* newName)
{
	Waypoint __gc* tmpWp = static_cast<Waypoint*>(waypoints->Item[wp_idx]);
	PlantPatch __gc* tmpPp = static_cast<PlantPatch*>(tmpWp->plantPatches->Item[pp_idx]);
	tmpPp->name = newName;
}

/** get a PlantPatch name.
* @param int wp_idx - <b>waypoint index</b> the index of the waypoint;
* @param int pp_idx - <b>plantpatch index</b> the index of the plantpatch;
* @return - String name of species.
*/

String __gc* MhsModel::FieldTrip::getPlantPatchName(int wp_idx, int pp_idx)
{
	Waypoint __gc* tmpWp = static_cast<Waypoint*>(waypoints->Item[wp_idx]);
	PlantPatch __gc* tmpPp = static_cast<PlantPatch*>(tmpWp->plantPatches->Item[pp_idx]);
	return tmpPp->name;
}

/** Sets a plantpatch species.
* @param int wp_idx - <b>waypoint index</b> the index of the waypoint;
* @param int pp_idx - <b>plantpatch index</b> the index of the plantpatch;
* @param String newSpecies - <b>New Species</b> the new speices for the plantpatch;
* @return - none.
*/

void MhsModel::FieldTrip::setPlantPatchSpecies(int wp_idx, int pp_idx, String __gc* newSpecies)
{
	Waypoint __gc* tmpWp = static_cast<Waypoint*>(waypoints->Item[wp_idx]);
	PlantPatch __gc* tmpPp = static_cast<PlantPatch*>(tmpWp->plantPatches->Item[pp_idx]);
	tmpPp->species = newSpecies;
}

/** get a PlantPatch species.
* @param int wp_idx - <b>waypoint index</b> the index of the waypoint;
* @param int pp_idx - <b>plantpatch index</b> the index of the plantpatch;
* @return - String name of species.
*/

String __gc* MhsModel::FieldTrip::getPlantPatchSpecies(int wp_idx, int pp_idx)
{
	Waypoint __gc* tmpWp = static_cast<Waypoint*>(waypoints->Item[wp_idx]);
	PlantPatch __gc* tmpPp = static_cast<PlantPatch*>(tmpWp->plantPatches->Item[pp_idx]);
	return tmpPp->species;
}

/** Sets a plantpatch diameter.
* @param int wp_idx - <b>waypoint index</b> the index of the waypoint;
* @param int pp_idx - <b>plantpatch index</b> the index of the plantpatch;h;
* @return - none.
*/

void MhsModel::FieldTrip::setPlantPatchDiameter(int wp_idx, int pp_idx, float diam)
{
	Waypoint __gc* tmpWp = static_cast<Waypoint*>(waypoints->Item[wp_idx]);
	PlantPatch __gc* tmpPp = static_cast<PlantPatch*>(tmpWp->plantPatches->Item[pp_idx]);
	tmpPp->diameter = diam;
}

/** Sets a plantpatch diameter.
* @param int wp_idx - <b>waypoint index</b> the index of the waypoint;
* @param int pp_idx - <b>plantpatch index</b> the index of the plantpatch;
* @return - float diameter of plantpatch.
*/

float MhsModel::FieldTrip::getPlantPatchDiameter(int wp_idx, int pp_idx)
{
	Waypoint __gc* tmpWp = static_cast<Waypoint*>(waypoints->Item[wp_idx]);
	PlantPatch __gc* tmpPp = static_cast<PlantPatch*>(tmpWp->plantPatches->Item[pp_idx]);
	return tmpPp->diameter;
}

/** Sets a plantpatch distance.
* @param int wp_idx - <b>waypoint index</b> the index of the waypoint;
* @param int pp_idx - <b>plantpatch index</b> the index of the plantpatch;
* @param float dist - <b>distance</b> the new distance for the plantpatch;
* @return - none.
*/

void MhsModel::FieldTrip::setPlantPatchDistance(int wp_idx, int pp_idx, float dist)
{
	Waypoint __gc* tmpWp = static_cast<Waypoint*>(waypoints->Item[wp_idx]);
	PlantPatch __gc* tmpPp = static_cast<PlantPatch*>(tmpWp->plantPatches->Item[pp_idx]);
	tmpPp->distance = dist;
}

/** gets a plantpatch distance.
* @param int wp_idx - <b>waypoint index</b> the index of the waypoint;
* @param int pp_idx - <b>plantpatch index</b> the index of the plantpatch;
* @return - float plantpatch distance.
*/

float MhsModel::FieldTrip::getPlantPatchDistance(int wp_idx, int pp_idx)
{
	Waypoint __gc* tmpWp = static_cast<Waypoint*>(waypoints->Item[wp_idx]);
	PlantPatch __gc* tmpPp = static_cast<PlantPatch*>(tmpWp->plantPatches->Item[pp_idx]);
	return tmpPp->distance;
}

/** Sets a plantpatch name.
* @param int wp_idx - <b>waypoint index</b> the index of the waypoint;
* @return - int of plantpatch count.
*/

int MhsModel::FieldTrip::getPlantPatchCount(int wp_idx)
{
	Waypoint __gc* tmpWp = static_cast<Waypoint*>(waypoints->Item[wp_idx]);
	return tmpWp->plantPatches->Count;
}


// CurrentYearGrowth methods

/**
	Set the base 3d vector of a cyg in the field trip. Deep copy.
	@param wp_idx the Waypoint array offset from zero
	@param pp_idx the PlantPatch array offset from zero
	@param cyg_idx the CurrentYearGrowth array offset from zero
	@param b3d a __gc pointer to a vector containing the new values
*/
void MhsModel::FieldTrip::setCygBase(int wp_idx, int pp_idx, int cyg_idx, Vector3 __gc* b3d)
{
	Waypoint *wp = static_cast<Waypoint*>(waypoints->Item[wp_idx]);
	PlantPatch *pp = static_cast<PlantPatch*>(wp->plantPatches->Item[pp_idx]);
	CurrentYearGrowth *cyg = static_cast<CurrentYearGrowth*>(pp->cygs->Item[cyg_idx]);
	cyg->setBase(b3d);
}

/**
	Get the base 3d vector of a cyg in the field trip. Deep copy.
	@param wp_idx the Waypoint array offset from zero
	@param pp_idx the PlantPatch array offset from zero
	@param cyg_idx the CurrentYearGrowth array offset from zero
	@return a __gc pointer to a Vector3
*/
Vector3 __gc* MhsModel::FieldTrip::getCygBase(int wp_idx, int pp_idx, int cyg_idx)
{
	Waypoint *wp = static_cast<Waypoint*>(waypoints->Item[wp_idx]);
	PlantPatch *pp = static_cast<PlantPatch*>(wp->plantPatches->Item[pp_idx]);
	CurrentYearGrowth *cyg = static_cast<CurrentYearGrowth*>(pp->cygs->Item[cyg_idx]);
	return &(cyg->base3dPoint);
}

/**
	Set the tip 3d vector of a cyg in the field trip. Deep copy.
	@param wp_idx the Waypoint array offset from zero
	@param pp_idx the PlantPatch array offset from zero
	@param cyg_idx the CurrentYearGrowth array offset from zero
	@param b3d a __gc pointer to a vector containing the new values
*/
void MhsModel::FieldTrip::setCygTip(int wp_idx, int pp_idx, int cyg_idx, Vector3 __gc* t3d)
{
	Waypoint *wp = static_cast<Waypoint*>(waypoints->Item[wp_idx]);
	PlantPatch *pp = static_cast<PlantPatch*>(wp->plantPatches->Item[pp_idx]);
	CurrentYearGrowth *cyg = static_cast<CurrentYearGrowth*>(pp->cygs->Item[cyg_idx]);
	cyg->setTip(t3d);
}

/**
	Get the tip 3d vector of a cyg in the field trip. Deep copy.
	@param wp_idx the Waypoint array offset from zero
	@param pp_idx the PlantPatch array offset from zero
	@param cyg_idx the CurrentYearGrowth array offset from zero
	@return a __gc pointer to a Vector3
*/
Vector3 __gc* MhsModel::FieldTrip::getCygTip(int wp_idx, int pp_idx, int cyg_idx)
{
	Waypoint *wp = static_cast<Waypoint*>(waypoints->Item[wp_idx]);
	PlantPatch *pp = static_cast<PlantPatch*>(wp->plantPatches->Item[pp_idx]);
	CurrentYearGrowth *cyg = static_cast<CurrentYearGrowth*>(pp->cygs->Item[cyg_idx]);
	return &(cyg->tip3dPoint);
}

/**
	Set the reference 3d vector of a cyg in the field trip. Deep copy.
	@param wp_idx the Waypoint array offset from zero
	@param pp_idx the PlantPatch array offset from zero
	@param cyg_idx the CurrentYearGrowth array offset from zero
	@param b3d a __gc pointer to a vector containing the new values
*/
void MhsModel::FieldTrip::setCygRef(int wp_idx, int pp_idx, int cyg_idx, Vector3 __gc* r3d)
{
	Waypoint *wp = static_cast<Waypoint*>(waypoints->Item[wp_idx]);
	PlantPatch *pp = static_cast<PlantPatch*>(wp->plantPatches->Item[pp_idx]);
	CurrentYearGrowth *cyg = static_cast<CurrentYearGrowth*>(pp->cygs->Item[cyg_idx]);
	cyg->setRef(r3d);
}

/**
	Get the reference 3d vector of a cyg in the field trip. Deep copy.
	@param wp_idx the Waypoint array offset from zero
	@param pp_idx the PlantPatch array offset from zero
	@param cyg_idx the CurrentYearGrowth array offset from zero
	@return a __gc pointer to a Vector3
*/
Vector3 __gc* MhsModel::FieldTrip::getCygRef(int wp_idx, int pp_idx, int cyg_idx)
{
	Waypoint *wp = static_cast<Waypoint*>(waypoints->Item[wp_idx]);
	PlantPatch *pp = static_cast<PlantPatch*>(wp->plantPatches->Item[pp_idx]);
	CurrentYearGrowth *cyg = static_cast<CurrentYearGrowth*>(pp->cygs->Item[cyg_idx]);
	return &(cyg->ref3dPoint);
}

/**
	Get the diameter of a cyg in the field trip. Deep copy.
	@param wp_idx the Waypoint array offset from zero
	@param pp_idx the PlantPatch array offset from zero
	@param cyg_idx the CurrentYearGrowth array offset from zero
	@return a float representing the CYG's diameter
*/
float MhsModel::FieldTrip::getCygDiameter(int wp_idx, int pp_idx, int cyg_idx)
{
	Waypoint *wp = static_cast<Waypoint*>(waypoints->Item[wp_idx]);
	PlantPatch *pp = static_cast<PlantPatch*>(wp->plantPatches->Item[pp_idx]);
	CurrentYearGrowth *cyg = static_cast<CurrentYearGrowth*>(pp->cygs->Item[cyg_idx]);
	return cyg->baseDiameter;
}

/**
	Set the diameter of a cyg in the field trip. Deep copy.
	@param wp_idx the Waypoint array offset from zero
	@param pp_idx the PlantPatch array offset from zero
	@param cyg_idx the CurrentYearGrowth array offset from zero
	@param b3d a float containing the new diameter
*/
void MhsModel::FieldTrip::setCygDiameter(int wp_idx, int pp_idx, int cyg_idx, float diam)
{
	Waypoint *wp = static_cast<Waypoint*>(waypoints->Item[wp_idx]);
	PlantPatch *pp = static_cast<PlantPatch*>(wp->plantPatches->Item[pp_idx]);
	CurrentYearGrowth *cyg = static_cast<CurrentYearGrowth*>(pp->cygs->Item[cyg_idx]);
	cyg->baseDiameter = diam;
}
