#pragma once
#include "Model.h"
#include "MhsCygNode.h"
#include "D3dPictureBox.h"

namespace MHS
{

	// microsoft namespaces
	using namespace System;
	using namespace System::ComponentModel;
	using namespace System::Collections;
	using namespace System::Windows::Forms;
	using namespace System::Data;
	using namespace System::Drawing;

	using namespace MhsModel;

	// DirectX variables
	//IDirect3D9 *g_pD3D;
	//D3DPRESENT_PARAMETERS d3dpp; 
	//IDirect3DDevice9 * g_pd3dDevice;

	/// <summary> 
	/// Summary for Form1
	///
	/// WARNING: If you change the name of this class, you will need to change the 
	///          'Resource File Name' property for the managed resource compiler tool 
	///          associated with all .resx files this class depends on.  Otherwise,
	///          the designers will not be able to interact properly with localized
	///          resources associated with this form.
	/// </summary>
public __gc class Form1 : public System::Windows::Forms::Form
{	
public:
	Form1(void)
	{
		InitializeComponent();
		fieldTrip_ptr = new FieldTrip();

		D3dInit();
	}

protected:
	void Dispose(Boolean disposing)
	{
		// clean up diret3d handles
		//if( g_pd3dDevice != NULL)
		//	g_pd3dDevice->Release();
		//if( g_pD3D != NULL)
		//	g_pD3D->Release();

		if (disposing && components)
		{
			components->Dispose();
		}
		__super::Dispose(disposing);
	}


private: 
	// Mhs model variables
	FieldTrip * fieldTrip_ptr;
	DataSet* myDataSet;

//private: System::Windows::Forms::PictureBox *  pictureBox1;
private: D3dPictureBox *  pictureBox1;

private: System::Windows::Forms::Splitter *  splitter1;
private: System::Windows::Forms::Panel *  panel1;
private: System::Windows::Forms::TreeView *  treeView1;


private: System::Windows::Forms::DataGrid *  dataGrid1;
private: System::Windows::Forms::Splitter *  splitter2;
private: System::Windows::Forms::MainMenu *  mainMenu1;
private: System::Windows::Forms::MenuItem *  menuItem1;

private: System::Windows::Forms::MenuItem *  menuItem3;
private: System::Windows::Forms::MenuItem *  menuItem4;
private: System::Windows::Forms::MenuItem *  menuItem5;
private: System::Windows::Forms::MenuItem *  menuItem6;
private: System::Windows::Forms::MenuItem *  menuItem7;
private: System::Windows::Forms::MenuItem *  menuItem8;
private: System::Windows::Forms::MenuItem *  menuItem9;
private: System::Windows::Forms::OpenFileDialog *  importFileDialog;
private: System::Windows::Forms::MenuItem *  openMenuItem;

private: System::ComponentModel::IContainer *  components;





private:
	/// <summary>
	/// Required designer variable.
	/// </summary>


	/// <summary>
	/// Required method for Designer support - do not modify
	/// the contents of this method with the code editor.
	/// </summary>
	void InitializeComponent(void)
	{
		//this->pictureBox1 = new System::Windows::Forms::PictureBox();
		this->pictureBox1 = new D3dPictureBox();
		this->splitter1 = new System::Windows::Forms::Splitter();
		this->panel1 = new System::Windows::Forms::Panel();
		this->dataGrid1 = new System::Windows::Forms::DataGrid();
		this->splitter2 = new System::Windows::Forms::Splitter();
		this->treeView1 = new System::Windows::Forms::TreeView();
		this->mainMenu1 = new System::Windows::Forms::MainMenu();
		this->menuItem1 = new System::Windows::Forms::MenuItem();
		this->openMenuItem = new System::Windows::Forms::MenuItem();
		this->menuItem6 = new System::Windows::Forms::MenuItem();
		this->menuItem3 = new System::Windows::Forms::MenuItem();
		this->menuItem4 = new System::Windows::Forms::MenuItem();
		this->menuItem5 = new System::Windows::Forms::MenuItem();
		this->menuItem7 = new System::Windows::Forms::MenuItem();
		this->menuItem8 = new System::Windows::Forms::MenuItem();
		this->menuItem9 = new System::Windows::Forms::MenuItem();
		this->importFileDialog = new System::Windows::Forms::OpenFileDialog();
		this->panel1->SuspendLayout();
		(__try_cast<System::ComponentModel::ISupportInitialize *  >(this->dataGrid1))->BeginInit();
		this->SuspendLayout();
		// 
		// pictureBox1
		// 
		this->pictureBox1->BackColor = System::Drawing::SystemColors::Control;
		this->pictureBox1->Dock = System::Windows::Forms::DockStyle::Left;
		this->pictureBox1->Location = System::Drawing::Point(0, 0);
		this->pictureBox1->Name = S"pictureBox1";
		this->pictureBox1->Size = System::Drawing::Size(381, 381);
		this->pictureBox1->TabIndex = 1;
		this->pictureBox1->TabStop = false;
		this->pictureBox1->Click += new System::EventHandler(this, pictureBox1_Click);
		// 
		// splitter1
		// 
		this->splitter1->BorderStyle = System::Windows::Forms::BorderStyle::Fixed3D;
		this->splitter1->Location = System::Drawing::Point(381, 0);
		this->splitter1->MinSize = 150;
		this->splitter1->Name = S"splitter1";
		this->splitter1->Size = System::Drawing::Size(3, 381);
		this->splitter1->TabIndex = 2;
		this->splitter1->TabStop = false;
		// 
		// panel1
		// 
		this->panel1->Controls->Add(this->dataGrid1);
		this->panel1->Controls->Add(this->splitter2);
		this->panel1->Controls->Add(this->treeView1);
		this->panel1->Dock = System::Windows::Forms::DockStyle::Fill;
		this->panel1->Location = System::Drawing::Point(384, 0);
		this->panel1->Name = S"panel1";
		this->panel1->Size = System::Drawing::Size(264, 381);
		this->panel1->TabIndex = 3;
		// 
		// dataGrid1
		// 
		this->dataGrid1->AccessibleName = S"DataGrid";
		this->dataGrid1->AccessibleRole = System::Windows::Forms::AccessibleRole::Table;
		this->dataGrid1->Anchor = (System::Windows::Forms::AnchorStyles)(((System::Windows::Forms::AnchorStyles::Top | System::Windows::Forms::AnchorStyles::Bottom) 
			| System::Windows::Forms::AnchorStyles::Left) 
			| System::Windows::Forms::AnchorStyles::Right);
		this->dataGrid1->DataMember = S"";
		this->dataGrid1->HeaderForeColor = System::Drawing::SystemColors::ControlText;
		this->dataGrid1->Location = System::Drawing::Point(0, 211);
		this->dataGrid1->Name = S"dataGrid1";
		this->dataGrid1->Size = System::Drawing::Size(264, 170);
		this->dataGrid1->TabIndex = 3;
		// 
		// splitter2
		// 
		this->splitter2->Dock = System::Windows::Forms::DockStyle::Top;
		this->splitter2->Location = System::Drawing::Point(0, 208);
		this->splitter2->MinSize = 150;
		this->splitter2->Name = S"splitter2";
		this->splitter2->Size = System::Drawing::Size(264, 3);
		this->splitter2->TabIndex = 2;
		this->splitter2->TabStop = false;
		// 
		// treeView1
		// 
		this->treeView1->Dock = System::Windows::Forms::DockStyle::Top;
		this->treeView1->HotTracking = true;
		this->treeView1->ImageIndex = -1;
		this->treeView1->Location = System::Drawing::Point(0, 0);
		this->treeView1->Name = S"treeView1";
		this->treeView1->SelectedImageIndex = -1;
		this->treeView1->Size = System::Drawing::Size(264, 208);
		this->treeView1->TabIndex = 0;
		// 
		// mainMenu1
		// 
		System::Windows::Forms::MenuItem* __mcTemp__1[] = new System::Windows::Forms::MenuItem*[2];
		__mcTemp__1[0] = this->menuItem1;
		__mcTemp__1[1] = this->menuItem8;
		this->mainMenu1->MenuItems->AddRange(__mcTemp__1);
		// 
		// menuItem1
		// 
		this->menuItem1->Index = 0;
		System::Windows::Forms::MenuItem* __mcTemp__2[] = new System::Windows::Forms::MenuItem*[6];
		__mcTemp__2[0] = this->openMenuItem;
		__mcTemp__2[1] = this->menuItem6;
		__mcTemp__2[2] = this->menuItem3;
		__mcTemp__2[3] = this->menuItem4;
		__mcTemp__2[4] = this->menuItem5;
		__mcTemp__2[5] = this->menuItem7;
		this->menuItem1->MenuItems->AddRange(__mcTemp__2);
		this->menuItem1->Text = S"File";
		// 
		// openMenuItem
		// 
		this->openMenuItem->Index = 0;
		this->openMenuItem->Text = S"Open";
		// 
		// menuItem6
		// 
		this->menuItem6->Index = 1;
		this->menuItem6->Text = S"Save";
		// 
		// menuItem3
		// 
		this->menuItem3->Index = 2;
		this->menuItem3->Text = S"Save As...";
		// 
		// menuItem4
		// 
		this->menuItem4->Index = 3;
		this->menuItem4->Text = S"Import...";
		this->menuItem4->Click += new System::EventHandler(this, menuItem4_Click);
		// 
		// menuItem5
		// 
		this->menuItem5->Index = 4;
		this->menuItem5->Text = S"Export...";
		// 
		// menuItem7
		// 
		this->menuItem7->Index = 5;
		this->menuItem7->Text = S"Exit";
		// 
		// menuItem8
		// 
		this->menuItem8->Index = 1;
		System::Windows::Forms::MenuItem* __mcTemp__3[] = new System::Windows::Forms::MenuItem*[1];
		__mcTemp__3[0] = this->menuItem9;
		this->menuItem8->MenuItems->AddRange(__mcTemp__3);
		this->menuItem8->Text = S"Help";
		// 
		// menuItem9
		// 
		this->menuItem9->Index = 0;
		this->menuItem9->Text = S"About";


		// disable menues
		openMenuItem->Enabled=false;
		menuItem3->Enabled=false;
		menuItem4->Enabled=true;
		menuItem5->Enabled=false;
		menuItem6->Enabled=false;
		menuItem7->Enabled=false;
		menuItem9->Enabled=false;
		// 
		// importFileDialog
		// 
		this->importFileDialog->DefaultExt = S"*.mhs";
		// 
		// Form1
		// 
		this->AutoScaleBaseSize = System::Drawing::Size(5, 13);
		this->ClientSize = System::Drawing::Size(648, 381);
		this->Controls->Add(this->panel1);
		this->Controls->Add(this->splitter1);
		this->Controls->Add(this->pictureBox1);
		this->Menu = this->mainMenu1;
		this->MinimumSize = System::Drawing::Size(300, 300);
		this->Name = S"Form1";
		this->Text = S"Moose Habitat Surveyor";
		this->panel1->ResumeLayout(false);
		(__try_cast<System::ComponentModel::ISupportInitialize *  >(this->dataGrid1))->EndInit();
		this->ResumeLayout(false);



					//BINDS TABLE INFO TO THE DATAGRID

			this->MakeParentTable();
			this->MakeChildTable();
			this->MakeDataRelation();
			this->BindToDataGrid();

	}	




	void D3dInit()
	{

		//// init direct3d object
		//if( NULL == ( g_pD3D = Direct3DCreate9( D3D_SDK_VERSION ) ) )
		//	exit(E_FAIL);

		//// build direct3d presentation parameters
		//d3dpp.Windowed = TRUE;
		//d3dpp.SwapEffect = D3DSWAPEFFECT_DISCARD;
		//d3dpp.BackBufferFormat = D3DFMT_UNKNOWN;

		//if( FAILED(g_pD3D->CreateDevice( D3DADAPTER_DEFAULT, D3DDEVTYPE_HAL, (HWND) pictureBox1->Handle.ToPointer() ,
		//							D3DCREATE_SOFTWARE_VERTEXPROCESSING,
		//							&d3dpp, &g_pd3dDevice )))
		//	exit(E_FAIL);

	}

private: System::Void pictureBox1_Click(System::Object *  sender, System::EventArgs *  e)
		 {
			 //pictureBox1->D3dRender();
		 }



private: System::Void menuItem4_Click(System::Object *  sender, System::EventArgs *  e)
		 {	String __gc* fileName;
			int results;
			int x;
			String __gc* nameHolder[];

			importFileDialog->Title = S"Select file to import...";
			importFileDialog->Filter = "MHS Files (*.mhs)|*.mhs";
			results = importFileDialog->ShowDialog();
			 if(results == IDOK)
			 {	if(importFileDialog->get_FileName() != NULL || importFileDialog->get_FileName() !="")
					{	fileName = importFileDialog->get_FileName();
						//MHS::Form1::Text = fileName;
						
			 System::IO::StreamReader __gc* myReader = new System::IO::StreamReader(fileName, FileMode::Open);
			 try {
				while (myReader->Peek() >= 0)
					{	x = 0;
						//Form1->Console::WriteLine(myReader->ReadLine());
				//MHS::Form1::Text = myReader->ReadLine();
				//this->treeView1->Nodes->Add(new TreeNode(), );
				   
				   String* words = myReader->ReadLine();
				   Char chars[] = {';', ', ', '->', ':'};
				   String* split[] = words->Split(chars);

					IEnumerator* myEnum = split->GetEnumerator();
					while (myEnum->MoveNext())
						{	String* s = __try_cast<String*>(myEnum->Current);
							if (!s->Trim()->Equals(S""))
								
								//this->treeView1->Nodes->Add(new TreeNode(s));
								
								nameHolder[x] = s;
							x++;
						}
	 
					}
				} catch (Exception* e)
					{	Console::WriteLine(S"The process failed: {0}", e);
					}

				}
			}

			 fieldTrip_ptr->waypoints->Add(new Waypoint());
			 TreeNode *CYGNodes[] = {new TreeNode(S"CYG1"),
							new TreeNode(S"CYG2"),
							new TreeNode(S"CYG3")};
			 TreeNode *CYGNodes1[] = {new TreeNode(S"CYG1"),
							new TreeNode(S"CYG2"),
							new TreeNode(S"CYG3")};
			 TreeNode *CYGNodes2[] = {new TreeNode(S"CYG1"),
							new TreeNode(S"CYG2"),
							new TreeNode(S"CYG3")};
			 TreeNode *CYGNodes3[] = {new TreeNode(S"CYG1"),
							new TreeNode(S"CYG2"),
							new TreeNode(S"CYG3")};
			 TreeNode *CYGNodes4[] = {new TreeNode(S"CYG1"),
							new TreeNode(S"CYG2"),
							new TreeNode(S"CYG3")};
			 TreeNode *CYGNodes5[] = {new TreeNode(S"CYG1"),
							new TreeNode(S"CYG2"),
							new TreeNode(S"CYG3")};
			 TreeNode *CYGNodes6[] = {new TreeNode(S"CYG1"),
							new TreeNode(S"CYG2"),
							new TreeNode(S"CYG3")};
			 TreeNode *CYGNodes7[] = {new TreeNode(S"CYG1"),
							new TreeNode(S"CYG2"),
							new TreeNode(S"CYG3")};
			 TreeNode *CYGNodes8[] = {new TreeNode(S"CYG1"),
							new TreeNode(S"CYG2"),
							new TreeNode(S"CYG3")};
			 TreeNode *CYGNodes9[] = {new TreeNode(S"CYG1"),
							new TreeNode(S"CYG2"),
							new TreeNode(S"CYG3")};
			 TreeNode *CYGNodes10[] = {new TreeNode(S"CYG1"),
							new TreeNode(S"CYG2"),
							new TreeNode(S"CYG3")};
			 TreeNode *CYGNodes11[] = {new TreeNode(S"CYG1"),
							new TreeNode(S"CYG2"),
							new TreeNode(S"CYG3")};
			 TreeNode *CYGNodes12[] = {new TreeNode(S"CYG1"),
							new TreeNode(S"CYG2"),
							new TreeNode(S"CYG3")};
			 TreeNode *CYGNodes13[] = {new TreeNode(S"CYG1"),
							new TreeNode(S"CYG2"),
							new TreeNode(S"CYG3")};
			 TreeNode *CYGNodes14[] = {new TreeNode(S"CYG1"),
							new TreeNode(S"CYG2"),
							new TreeNode(S"CYG3")};
			 TreeNode *CYGNodes15[] = {new TreeNode(S"CYG1"),
							new TreeNode(S"CYG2"),
							new TreeNode(S"CYG3")};
			 TreeNode *PPNodes[] = {new TreeNode(S"Calamagrostic Canadensis",CYGNodes1),
								new TreeNode(S"Equisetum Sylvaticum", CYGNodes2),
								new TreeNode(S"Cornus Canadensis", CYGNodes3),
								new TreeNode(S"Populus tremuloides", CYGNodes)};
			 TreeNode *PPNodes1[] = {new TreeNode(S"Calamagrostic Canadensis",CYGNodes4),
								new TreeNode(S"Equisetum Sylvaticum", CYGNodes5),
								new TreeNode(S"Cornus Canadensis", CYGNodes6),
								new TreeNode(S"Populus tremuloides", CYGNodes7)};
			 TreeNode *PPNodes2[] = {new TreeNode(S"Calamagrostic Canadensis",CYGNodes8),
								new TreeNode(S"Equisetum Sylvaticum", CYGNodes9),
								new TreeNode(S"Cornus Canadensis", CYGNodes10),
								new TreeNode(S"Populus tremuloides", CYGNodes11)};
			 TreeNode *PPNodes3[] = {new TreeNode(S"Calamagrostic Canadensis",CYGNodes12),
								new TreeNode(S"Equisetum Sylvaticum", CYGNodes13),
								new TreeNode(S"Cornus Canadensis", CYGNodes14),
								new TreeNode(S"Populus tremuloides", CYGNodes15)};
			 TreeNode *WPNodes[] = {new TreeNode(S"Waypoint 1", PPNodes),
									new TreeNode(S"Waypoint 2", PPNodes1),
									new TreeNode(S"Waypoint 3", PPNodes2),
									new TreeNode(S"Waypoint 4", PPNodes3)};
			 this->treeView1->Nodes->Add(WPNodes[0]);
			 this->treeView1->Nodes->Add(WPNodes[1]);
			 this->treeView1->Nodes->Add(WPNodes[2]);
			 this->treeView1->Nodes->Add(WPNodes[3]);
			 MHS::Form1::menuItem4->Enabled=false;
			 //this->treeView1->Nodes->Add(new MhsCygNode(7));

		 }













 void MakeParentTable(){
    // Create a new DataTable.
    System::Data::DataTable* myDataTable = new DataTable(S"ParentTable");
    // Declare variables for DataColumn and DataRow objects.
    DataColumn* myDataColumn;
    DataRow* myDataRow;
 
    // Create new DataColumn, set DataType, ColumnName and add to DataTable.    
    myDataColumn = new DataColumn();
    myDataColumn->DataType = System::Type::GetType(S"System.Int32");
    myDataColumn->ColumnName = S"id";
    myDataColumn->ReadOnly = true;
    myDataColumn->Unique = true;
    // Add the Column to the DataColumnCollection.
    myDataTable->Columns->Add(myDataColumn);
 
    // Create second column.
    myDataColumn = new DataColumn();
    myDataColumn->DataType = System::Type::GetType(S"System.String");
    myDataColumn->ColumnName = S"ParentItem";
    myDataColumn->AutoIncrement = false;
    myDataColumn->Caption = S"ParentItem";
    myDataColumn->ReadOnly = false;
    myDataColumn->Unique = false;
    // Add the column to the table.
    myDataTable->Columns->Add(myDataColumn);
 
    // Make the ID column the primary key column.
    DataColumn* PrimaryKeyColumns[] = new DataColumn*[1];
    PrimaryKeyColumns->Item[0] = myDataTable->Columns->Item[S"id"];
    myDataTable->PrimaryKey = PrimaryKeyColumns;
 
    // Instantiate the DataSet variable.
    myDataSet = new DataSet();
    // Add the new DataTable to the DataSet.
    myDataSet->Tables->Add(myDataTable);
 
    // Create three new DataRow objects and add them to the DataTable
    for (int i = 0; i<= 2; i++){
       myDataRow = myDataTable->NewRow();
       myDataRow->Item[S"id"] = __box(i);
       myDataRow->Item[S"ParentItem"] = String::Format( S"ParentItem {0}", __box(i));
       myDataTable->Rows->Add(myDataRow);
    }
 }
 
 void MakeChildTable(){
    // Create a new DataTable.
    DataTable* myDataTable = new DataTable(S"childTable");
    DataColumn* myDataColumn;
    DataRow* myDataRow;
 
    // Create first column and add to the DataTable.
    myDataColumn = new DataColumn();
    myDataColumn->DataType= System::Type::GetType(S"System.Int32");
    myDataColumn->ColumnName = S"ChildID";
    myDataColumn->AutoIncrement = true;
    myDataColumn->Caption = S"ID";
    myDataColumn->ReadOnly = true;
    myDataColumn->Unique = true;
    // Add the column to the DataColumnCollection.
    myDataTable->Columns->Add(myDataColumn);
 
    // Create second column.
    myDataColumn = new DataColumn();
    myDataColumn->DataType= System::Type::GetType(S"System.String");
    myDataColumn->ColumnName = S"ChildItem";
    myDataColumn->AutoIncrement = false;
    myDataColumn->Caption = S"ChildItem";
    myDataColumn->ReadOnly = false;
    myDataColumn->Unique = false;
    myDataTable->Columns->Add(myDataColumn);
 
    // Create third column.
    myDataColumn = new DataColumn();
    myDataColumn->DataType= System::Type::GetType(S"System.Int32");
    myDataColumn->ColumnName = S"ParentID";
    myDataColumn->AutoIncrement = false;
    myDataColumn->Caption = S"ParentID";
    myDataColumn->ReadOnly = false;
    myDataColumn->Unique = false;
    myDataTable->Columns->Add(myDataColumn);
 
    myDataSet->Tables->Add(myDataTable);
    // Create three sets of DataRow objects, five rows each, and add to DataTable.
    for(int i = 0; i <= 4; i ++){
       myDataRow = myDataTable->NewRow();
       myDataRow->Item[S"childID"] = __box(i);
       myDataRow->Item[S"ChildItem"] = String::Format( S"Item {0}", __box(i));
       myDataRow->Item[S"ParentID"] = __box(0);
       myDataTable->Rows->Add(myDataRow);
    }
    for(int i = 0; i <= 4; i ++){
       myDataRow = myDataTable->NewRow();
       myDataRow->Item[S"childID"] = __box(i + 5);
       myDataRow->Item[S"ChildItem"] = String::Format( S"Item {0}", __box(i));
       myDataRow->Item[S"ParentID"] = __box(1);
       myDataTable->Rows->Add(myDataRow);
    }
    for(int i = 0; i <= 4; i ++){
       myDataRow = myDataTable->NewRow();
       myDataRow->Item[S"childID"] = __box(i + 10);
       myDataRow->Item[S"ChildItem"] = String::Format( S"Item {0}", __box(i));
       myDataRow->Item[S"ParentID"] = __box(2);
       myDataTable->Rows->Add(myDataRow);
    }
 }
 
 void MakeDataRelation(){
    // DataRelation requires two DataColumn (parent and child) and a name.
    DataRelation* myDataRelation;
    DataColumn* parentColumn;
    DataColumn* childColumn;
    parentColumn = myDataSet->Tables->Item[S"ParentTable"]->Columns->Item[S"id"];
    childColumn = myDataSet->Tables->Item[S"ChildTable"]->Columns->Item[S"ParentID"];
    myDataRelation = new DataRelation(S"parent2Child", parentColumn, childColumn);
    myDataSet->Tables->Item[S"ChildTable"]->ParentRelations->Add(myDataRelation);
 }
 
 void BindToDataGrid(){
    // Instruct the DataGrid to bind to the DataSet, with the 
    // ParentTable as the topmost DataTable.
    dataGrid1->SetDataBinding(myDataSet,S"ParentTable");
 }





};
}


