using System;
using System.Collections;
using System.ComponentModel;
using System.ComponentModel.Design;
using System.Drawing;
using System.Diagnostics;
using System.Drawing.Drawing2D;
using System.Drawing.Design;
using System.Data;
using System.Windows.Forms;
using System.Windows.Forms.Design;
using System.Windows.Forms.ComponentModel;
using Microsoft.DirectX;
using Microsoft.DirectX.Direct3D;


namespace MhsModelCSharp
{
	/// <summary>
	/// FloatInkEditor is an 
	/// </summary>
	public class FloatInkEditor : System.Drawing.Design.UITypeEditor
	{
		/// <summary>
		/// Empty constructor.
		/// </summary>
		public FloatInkEditor()
		{
		}

		/// <summary>
		/// The hook to launch a control when the user hits the edit
		/// button in the property grid.
		/// </summary>
		/// <param name="context"></param>
		/// <param name="provider"></param>
		/// <param name="value"></param>
		/// <returns></returns>
		public override object EditValue(ITypeDescriptorContext context, IServiceProvider provider, object value)
		{
			if( value.GetType() != typeof(float) )
				return value;

			// Uses the IWindowsFormsEditorService to display UI in the Properties window.
			IWindowsFormsEditorService edtSvc = (IWindowsFormsEditorService)provider.GetService(typeof(IWindowsFormsEditorService));
			if( edtSvc != null )
			{
				FloatInkerEditorControl inker = new FloatInkerEditorControl();
				float v = (float) value;

				inker.X = v;
				edtSvc.ShowDialog( inker );

				return inker.X;
			}
			return value;
		}
			
		/// <summary>
		/// Do we support the paint value. No.
		/// </summary>
		/// <param name="context"></param>
		/// <returns></returns>
		public override bool GetPaintValueSupported(ITypeDescriptorContext context)
		{
			return false;
		}
		
		/// <summary>
		/// Type of editor style. This is modal; meaning popup window that
		/// blocks all other input.
		/// </summary>
		/// <param name="context"></param>
		/// <returns></returns>
		public override UITypeEditorEditStyle GetEditStyle(ITypeDescriptorContext context)
		{
			return UITypeEditorEditStyle.Modal;
		}
	}
}
