using System;
using System.Collections;
using System.ComponentModel;
using System.Reflection;
using System.Text;
using System.Text.RegularExpressions;
using System.IO;
using System.Windows.Forms;
using System.Drawing;

using System.Xml;
using System.Xml.Serialization;

using Microsoft.DirectX;
using Microsoft.DirectX.Direct3D;
using D3D = Microsoft.DirectX.Direct3D;
using Vector3 = Microsoft.DirectX.Vector3;
using Vector2 = Microsoft.DirectX.Vector2;

namespace MhsModelCSharp
{
	/// <summary>
	/// A simple CollectionBase class to make a strongly
	/// typed CurrentYearGrowth collections . Very boiler
	/// plate code.
	/// </summary>
	public class CurrentYearGrowthCollection :
		CollectionBase
	{
		/// <summary>
		/// indexer accessor to use array notation
		/// </summary>
		public CurrentYearGrowth this[ int index ]  
		{
			get  
			{
				return( (CurrentYearGrowth) List[index] );
			}
			set  
			{
				List[index] = value;
			}
		}

		/// <summary>
		/// Append cyg
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public int Add( CurrentYearGrowth value )  
		{
			return( List.Add( value ) );
		}

		/// <summary>
		/// location of certain cyg
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public int IndexOf( CurrentYearGrowth value )  
		{
			return( List.IndexOf( value ) );
		}

		/// <summary>
		/// insert cyg at specific location
		/// </summary>
		/// <param name="index"></param>
		/// <param name="value"></param>
		public void Insert( int index, CurrentYearGrowth value )  
		{
			List.Insert( index, value );
		}

		/// <summary>
		/// remove specific cyg
		/// </summary>
		/// <param name="value"></param>
		public void Remove( CurrentYearGrowth value )  
		{
			List.Remove( value );
		}

		/// <summary>
		/// contains specified cyg
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public bool Contains( CurrentYearGrowth value )  
		{
			// If value is not of type CurrentYearGrowth, this will return false.
			return( List.Contains( value ) );
		}

		/// <summary>
		/// on insert event handler
		/// </summary>
		/// <param name="index"></param>
		/// <param name="value"></param>
		protected override void OnInsert( int index, Object value )  
		{
			if ( value.GetType() != Type.GetType("MhsModelCSharp.CurrentYearGrowth") )
				throw new ArgumentException( "value must be of type CurrentYearGrowth.", "value" );
		}

		/// <summary>
		/// on remove event handler
		/// </summary>
		/// <param name="index"></param>
		/// <param name="value"></param>
		protected override void OnRemove( int index, Object value )  
		{
			if ( value.GetType() != Type.GetType("MhsModelCSharp.CurrentYearGrowth") )
				throw new ArgumentException( "value must be of type CurrentYearGrowth.", "value" );
		}

		/// <summary>
		/// on set event handler
		/// </summary>
		/// <param name="index"></param>
		/// <param name="oldValue"></param>
		/// <param name="newValue"></param>
		protected override void OnSet( int index, Object oldValue, Object newValue )  
		{
			if ( newValue.GetType() != Type.GetType("MhsModelCSharp.CurrentYearGrowth") )
				throw new ArgumentException( "newValue must be of type CurrentYearGrowth.", "newValue" );
		}

		/// <summary>
		/// on validate event handler
		/// </summary>
		/// <param name="value"></param>
		protected override void OnValidate( Object value )  
		{
			if ( value.GetType() != Type.GetType("MhsModelCSharp.CurrentYearGrowth") )
				throw new ArgumentException( "value must be of type CurrentYearGrowth." );
		}
	} // END class CurrentYearGrowthCollection


	/// <summary>
	/// Simple boiler plate collection to hold plant patches in 
	/// a strongly typed array/collection
	/// </summary>
	public class PlantPatchCollection :
		CollectionBase
	{
		/// <summary>
		/// indexer accessor. allows array notation.
		/// </summary>
		public PlantPatch this[ int index ]  
		{
			get  
			{
				return( (PlantPatch) List[index] );
			}
			set  
			{
				List[index] = value;
			}
		}

		/// <summary>
		/// append new patch
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public int Add( PlantPatch value )  
		{
			return( List.Add( value ) );
		}

		/// <summary>
		/// integer index of specific plant patch
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public int IndexOf( PlantPatch value )  
		{
			return( List.IndexOf( value ) );
		}

		/// <summary>
		/// add plant patch to specified index location
		/// </summary>
		/// <param name="index"></param>
		/// <param name="value"></param>
		public void Insert( int index, PlantPatch value )  
		{
			List.Insert( index, value );
		}

		/// <summary>
		/// remove a specific plant patch
		/// </summary>
		/// <param name="value"></param>
		public void Remove( PlantPatch value )  
		{
			List.Remove( value );
		}

		/// <summary>
		/// check if a specific plant patch is in the list
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public bool Contains( PlantPatch value )  
		{
			// If value is not of type PlantPatch, this will return false.
			return( List.Contains( value ) );
		}

		/// <summary>
		/// insert event handler
		/// </summary>
		/// <param name="index"></param>
		/// <param name="value"></param>
		protected override void OnInsert( int index, Object value )  
		{
			if ( value.GetType() != Type.GetType("MhsModelCSharp.PlantPatch") )
				throw new ArgumentException( "value must be of type PlantPatch.", "value" );
		}

		/// <summary>
		/// remove event handler
		/// </summary>
		/// <param name="index"></param>
		/// <param name="value"></param>
		protected override void OnRemove( int index, Object value )  
		{
			if ( value.GetType() != Type.GetType("MhsModelCSharp.PlantPatch") )
				throw new ArgumentException( "value must be of type PlantPatch.", "value" );
		}

		/// <summary>
		/// set event handler
		/// </summary>
		/// <param name="index"></param>
		/// <param name="oldValue"></param>
		/// <param name="newValue"></param>
		protected override void OnSet( int index, Object oldValue, Object newValue )  
		{
			if ( newValue.GetType() != Type.GetType("MhsModelCSharp.PlantPatch") )
				throw new ArgumentException( "newValue must be of type PlantPatch.", "newValue" );
		}

		/// <summary>
		/// validate event handler
		/// </summary>
		/// <param name="value"></param>
		protected override void OnValidate( Object value )  
		{
			if ( value.GetType() != Type.GetType("MhsModelCSharp.PlantPatch") )
				throw new ArgumentException( "value must be of type PlantPatch." );
		}
	} // END class PlantPatchCollection

	/// <summary>
	/// Collection implementation for strongly typed arrays/collections
	/// of waypoints
	/// </summary>
	public class WaypointCollection :
		CollectionBase
	{
		/// <summary>
		/// Indexer accessor
		/// </summary>
		public Waypoint this[int index]
		{
			get 
			{ 
				return (Waypoint) List[index];
			}
			set
			{
				List[index] = value;
			}
		}

		/// <summary>
		/// append waypoint to collection
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public int Add( Waypoint value )  
		{
			return( List.Add( value ) );
		}

		/// <summary>
		/// find specific waypoint
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public int IndexOf( Waypoint value )  
		{
			return( List.IndexOf( value ) );
		}

		/// <summary>
		/// insert waypoint at specific index
		/// </summary>
		/// <param name="index"></param>
		/// <param name="value"></param>
		public void Insert( int index, Waypoint value )  
		{
			List.Insert( index, value );
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="value"></param>
		public void Remove( Waypoint value )  
		{
			List.Remove( value );
		}

		/// <summary>
		/// see if a specific waypoint is in the collection
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public bool Contains( Waypoint value )  
		{
			// If value is not of type Waypoint, this will return false.
			return( List.Contains( value ) );
		}

		/// <summary>
		/// insert event handler
		/// </summary>
		/// <param name="index"></param>
		/// <param name="value"></param>
		protected override void OnInsert( int index, Object value )  
		{
			if ( value.GetType() != Type.GetType("MhsModelCSharp.Waypoint") )
				throw new ArgumentException( "value must be of type Waypoint.", "value" );
		}

		/// <summary>
		/// remove event handler
		/// </summary>
		/// <param name="index"></param>
		/// <param name="value"></param>
		protected override void OnRemove( int index, Object value )  
		{
			if ( value.GetType() != Type.GetType("MhsModelCSharp.Waypoint") )
				throw new ArgumentException( "value must be of type Waypoint.", "value" );
		}

		/// <summary>
		/// set event handler
		/// </summary>
		/// <param name="index"></param>
		/// <param name="oldValue"></param>
		/// <param name="newValue"></param>
		protected override void OnSet( int index, Object oldValue, Object newValue )  
		{
			if ( newValue.GetType() != Type.GetType("MhsModelCSharp.Waypoint") )
				throw new ArgumentException( "newValue must be of type Waypoint.", "newValue" );
		}

		/// <summary>
		/// validate event handler
		/// </summary>
		/// <param name="value"></param>
		protected override void OnValidate( Object value )  
		{
			if ( value.GetType() != Type.GetType("MhsModelCSharp.Waypoint") )
				throw new ArgumentException( "value must be of type Waypoint." );
		}
	} // END class WaypointCollection


	/// <summary>
	/// A simple CollectionBase class to make a strongly
	/// typed PlantPatchSamplingManager collections . Very boiler
	/// plate code.
	/// </summary>
	public class PlantPatchSamplingManagerCollection :
		CollectionBase
	{
		/// <summary>
		/// indexer accessor to use array notation
		/// </summary>
		public PlantPatchSamplingManager this[ int index ]  
		{
			get  
			{
				return( (PlantPatchSamplingManager) List[index] );
			}
			set  
			{
				List[index] = value;
			}
		}

		/// <summary>
		/// Append cyg
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public int Add( PlantPatchSamplingManager value )  
		{
			return( List.Add( value ) );
		}

		/// <summary>
		/// location of certain cyg
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public int IndexOf( PlantPatchSamplingManager value )  
		{
			return( List.IndexOf( value ) );
		}

		/// <summary>
		/// insert cyg at specific location
		/// </summary>
		/// <param name="index"></param>
		/// <param name="value"></param>
		public void Insert( int index, PlantPatchSamplingManager value )  
		{
			List.Insert( index, value );
		}

		/// <summary>
		/// remove specific cyg
		/// </summary>
		/// <param name="value"></param>
		public void Remove( PlantPatchSamplingManager value )  
		{
			List.Remove( value );
		}

		/// <summary>
		/// contains specified cyg
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public bool Contains( PlantPatchSamplingManager value )  
		{
			// If value is not of type PlantPatchSamplingManager, this will return false.
			return( List.Contains( value ) );
		}

		/// <summary>
		/// on insert event handler
		/// </summary>
		/// <param name="index"></param>
		/// <param name="value"></param>
		protected override void OnInsert( int index, Object value )  
		{
			if ( value.GetType() != Type.GetType("MhsModelCSharp.PlantPatchSamplingManager") )
				throw new ArgumentException( "value must be of type PlantPatchSamplingManager.", "value" );
		}

		/// <summary>
		/// on remove event handler
		/// </summary>
		/// <param name="index"></param>
		/// <param name="value"></param>
		protected override void OnRemove( int index, Object value )  
		{
			if ( value.GetType() != Type.GetType("MhsModelCSharp.PlantPatchSamplingManager") )
				throw new ArgumentException( "value must be of type PlantPatchSamplingManager.", "value" );
		}

		/// <summary>
		/// on set event handler
		/// </summary>
		/// <param name="index"></param>
		/// <param name="oldValue"></param>
		/// <param name="newValue"></param>
		protected override void OnSet( int index, Object oldValue, Object newValue )  
		{
			if ( newValue.GetType() != Type.GetType("MhsModelCSharp.PlantPatchSamplingManager") )
				throw new ArgumentException( "newValue must be of type PlantPatchSamplingManager.", "newValue" );
		}

		/// <summary>
		/// on validate event handler
		/// </summary>
		/// <param name="value"></param>
		protected override void OnValidate( Object value )  
		{
			if ( value.GetType() != Type.GetType("MhsModelCSharp.PlantPatchSamplingManager") )
				throw new ArgumentException( "value must be of type PlantPatchSamplingManager." );
		}
	} // END class PlantPatchSamplingManagerCollection























	/// <summary>
	/// A simple CollectionBase class to make a strongly
	/// typed WaypointSamplingManager collections . Very boiler
	/// plate code.
	/// </summary>
	public class WaypointSamplingManagerCollection :
		CollectionBase
	{
		/// <summary>
		/// indexer accessor to use array notation
		/// </summary>
		public WaypointSamplingManager this[ int index ]  
		{
			get  
			{
				return( (WaypointSamplingManager) List[index] );
			}
			set  
			{
				List[index] = value;
			}
		}

		/// <summary>
		/// Append cyg
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public int Add( WaypointSamplingManager value )  
		{
			return( List.Add( value ) );
		}

		/// <summary>
		/// location of certain cyg
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public int IndexOf( WaypointSamplingManager value )  
		{
			return( List.IndexOf( value ) );
		}

		/// <summary>
		/// insert cyg at specific location
		/// </summary>
		/// <param name="index"></param>
		/// <param name="value"></param>
		public void Insert( int index, WaypointSamplingManager value )  
		{
			List.Insert( index, value );
		}

		/// <summary>
		/// remove specific cyg
		/// </summary>
		/// <param name="value"></param>
		public void Remove( WaypointSamplingManager value )  
		{
			List.Remove( value );
		}

		/// <summary>
		/// contains specified cyg
		/// </summary>
		/// <param name="value"></param>
		/// <returns></returns>
		public bool Contains( WaypointSamplingManager value )  
		{
			// If value is not of type WaypointSamplingManager, this will return false.
			return( List.Contains( value ) );
		}

		/// <summary>
		/// on insert event handler
		/// </summary>
		/// <param name="index"></param>
		/// <param name="value"></param>
		protected override void OnInsert( int index, Object value )  
		{
			if ( value.GetType() != Type.GetType("MhsModelCSharp.WaypointSamplingManager") )
				throw new ArgumentException( "value must be of type WaypointSamplingManager.", "value" );
		}

		/// <summary>
		/// on remove event handler
		/// </summary>
		/// <param name="index"></param>
		/// <param name="value"></param>
		protected override void OnRemove( int index, Object value )  
		{
			if ( value.GetType() != Type.GetType("MhsModelCSharp.WaypointSamplingManager") )
				throw new ArgumentException( "value must be of type WaypointSamplingManager.", "value" );
		}

		/// <summary>
		/// on set event handler
		/// </summary>
		/// <param name="index"></param>
		/// <param name="oldValue"></param>
		/// <param name="newValue"></param>
		protected override void OnSet( int index, Object oldValue, Object newValue )  
		{
			if ( newValue.GetType() != Type.GetType("MhsModelCSharp.WaypointSamplingManager") )
				throw new ArgumentException( "newValue must be of type WaypointSamplingManager.", "newValue" );
		}

		/// <summary>
		/// on validate event handler
		/// </summary>
		/// <param name="value"></param>
		protected override void OnValidate( Object value )  
		{
			if ( value.GetType() != Type.GetType("MhsModelCSharp.WaypointSamplingManager") )
				throw new ArgumentException( "value must be of type WaypointSamplingManager." );
		}
	} // END class WaypointSamplingManagerCollection


}