using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;
using Microsoft.Ink;

namespace MhsModelCSharp
{
	/// <summary>
	/// Summary description for StringInkerEditorControl.
	/// </summary>
	public class StringInkerEditorControl : System.Windows.Forms.Form
	{

		// first stroke in set it to true
		private bool userIsInkingX = false;

		// original values
		string origX=null;
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.Button button2;
		private System.Windows.Forms.Label label4;
		private System.Windows.Forms.LinkLabel linkLabel1;
		private System.Windows.Forms.LinkLabel linkLabel2;
		private System.Windows.Forms.Panel panel1;
		private Microsoft.Ink.InkEdit inkEditX;

		/// <summary> 
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;

		/// <summary>
		/// 
		/// </summary>
		public StringInkerEditorControl()
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();

			// TODO: Add any initialization after the InitializeComponent call

		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{

			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.button1 = new System.Windows.Forms.Button();
			this.button2 = new System.Windows.Forms.Button();
			this.label4 = new System.Windows.Forms.Label();
			this.linkLabel1 = new System.Windows.Forms.LinkLabel();
			this.linkLabel2 = new System.Windows.Forms.LinkLabel();
			this.panel1 = new System.Windows.Forms.Panel();
			this.inkEditX = new Microsoft.Ink.InkEdit();
			this.panel1.SuspendLayout();
			this.SuspendLayout();
			// 
			// button1
			// 
			this.button1.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.button1.Location = new System.Drawing.Point(404, 8);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(44, 23);
			this.button1.TabIndex = 5;
			this.button1.Text = "OK";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// button2
			// 
			this.button2.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Right)));
			this.button2.DialogResult = System.Windows.Forms.DialogResult.Cancel;
			this.button2.Location = new System.Drawing.Point(464, 8);
			this.button2.Name = "button2";
			this.button2.Size = new System.Drawing.Size(60, 23);
			this.button2.TabIndex = 6;
			this.button2.Text = "Cancel";
			this.button2.Click += new System.EventHandler(this.button2_Click);
			// 
			// label4
			// 
			this.label4.Dock = System.Windows.Forms.DockStyle.Top;
			this.label4.Location = new System.Drawing.Point(0, 0);
			this.label4.Name = "label4";
			this.label4.Size = new System.Drawing.Size(528, 28);
			this.label4.TabIndex = 7;
			this.label4.Text = "Input a text string. You can type or use handwriting. After writing there will be" +
				" a short pause before the handwriting is converted to text.";
			// 
			// linkLabel1
			// 
			this.linkLabel1.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.linkLabel1.Location = new System.Drawing.Point(8, 16);
			this.linkLabel1.Name = "linkLabel1";
			this.linkLabel1.Size = new System.Drawing.Size(56, 16);
			this.linkLabel1.TabIndex = 8;
			this.linkLabel1.TabStop = true;
			this.linkLabel1.Text = "Select all";
			this.linkLabel1.LinkClicked += new System.Windows.Forms.LinkLabelLinkClickedEventHandler(this.linkLabel1_LinkClicked);
			// 
			// linkLabel2
			// 
			this.linkLabel2.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Bottom | System.Windows.Forms.AnchorStyles.Left)));
			this.linkLabel2.Location = new System.Drawing.Point(72, 16);
			this.linkLabel2.Name = "linkLabel2";
			this.linkLabel2.Size = new System.Drawing.Size(36, 16);
			this.linkLabel2.TabIndex = 8;
			this.linkLabel2.TabStop = true;
			this.linkLabel2.Text = "Clear";
			this.linkLabel2.LinkClicked += new System.Windows.Forms.LinkLabelLinkClickedEventHandler(this.linkLabel2_LinkClicked);
			// 
			// panel1
			// 
			this.panel1.Controls.Add(this.linkLabel1);
			this.panel1.Controls.Add(this.linkLabel2);
			this.panel1.Controls.Add(this.button1);
			this.panel1.Controls.Add(this.button2);
			this.panel1.Dock = System.Windows.Forms.DockStyle.Bottom;
			this.panel1.Location = new System.Drawing.Point(0, 185);
			this.panel1.Name = "panel1";
			this.panel1.Size = new System.Drawing.Size(528, 36);
			this.panel1.TabIndex = 9;
			// 
			// inkEditX
			// 
			this.inkEditX.Cursor = System.Windows.Forms.Cursors.Default;
			this.inkEditX.Dock = System.Windows.Forms.DockStyle.Fill;
			this.inkEditX.Factoid = "Number";
			this.inkEditX.InkMode = Microsoft.Ink.InkMode.Ink;
			this.inkEditX.Location = new System.Drawing.Point(0, 28);
			this.inkEditX.Multiline = false;
			this.inkEditX.Name = "inkEditX";
			this.inkEditX.Size = new System.Drawing.Size(528, 157);
			this.inkEditX.TabIndex = 10;
			this.inkEditX.Text = "0";
			// 
			// StringInkerEditorControl
			// 
			this.AcceptButton = this.button1;
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.CancelButton = this.button2;
			this.ClientSize = new System.Drawing.Size(528, 221);
			this.Controls.Add(this.inkEditX);
			this.Controls.Add(this.panel1);
			this.Controls.Add(this.label4);
			this.MaximizeBox = false;
			this.MinimizeBox = false;
			this.Name = "StringInkerEditorControl";
			this.SizeGripStyle = System.Windows.Forms.SizeGripStyle.Hide;
			this.Text = "Text Ink Editor";
			this.KeyPress += new System.Windows.Forms.KeyPressEventHandler(this.StringInkerEditorControl_KeyPress);
			this.Load += new System.EventHandler(this.StringInkerEditorControl_Load);
			this.panel1.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion


		private void InkBoxTextChangeValidator( ref InkEdit inkedit, ref bool userIsInking )
		{
			try
			{
				// the user just put in some text. 
				// a single character when typing.
				// a string when inking
				if( inkedit.Text.Length > 0 )
				{
					// when keying ignore an initial decimal point
					// and a trailing E. These could stil be valid floats.
					// wait to see what the string looks like after the
					// next TextChanged event. The use might exit with these
					// values, but the Vector3DataConverter will catch it.
					if( inkedit.Text.CompareTo(".") != 0 )
					{
						// is it a good float? throws FormatException
						float.Parse( inkedit.Text );
						if( userIsInking )
							inkedit.SelectAll();
					}				
				}

				if( userIsInking  )
					userIsInking = false;
			}
			catch( FormatException )
			{
				inkedit.Clear();
				MessageBox.Show("Invalid floating point number. The value you typed or wrote (" + inkedit.Text + ") is not a valid floating point number.\n 1. Try writing again\n 2. Use the on screen or attached keyboard.","Invalid floating point number",MessageBoxButtons.OK,MessageBoxIcon.Error); 
			}
		}

		private void inkEditX_TextChanged(object sender, System.EventArgs e)
		{
			//InkBoxTextChangeValidator(ref inkEditX,ref userIsInkingX);
		}


		private void inkEditX_Stroke(object sender, Microsoft.Ink.InkEditStrokeEventArgs e)
		{
			if( userIsInkingX == false )
			{
				inkEditX.Clear();
				userIsInkingX = true;
			}
		}

		// cancel button
		private void button2_Click(object sender, System.EventArgs e)
		{
			// disable responding to text changed events internally
			this.inkEditX.TextChanged += null;		
		
			// set the text back to the original values
			this.inkEditX.Text=origX;

			this.Close();
		}

		private void button1_Click(object sender, System.EventArgs e)
		{
			this.Close();
		}


		private void StringInkerEditorControl_Load(object sender, System.EventArgs e)
		{
			// cache the values in case the user hits cancel.
			origX = inkEditX.Text;
		}

		private void StringInkerEditorControl_KeyPress(object sender, System.Windows.Forms.KeyPressEventArgs e)
		{
			// same as clicking ok
			if( e.KeyChar == (char)Keys.Enter)
			{
				this.Close();
			}
		}

		private void inkEditX_Enter(object sender, System.EventArgs e)
		{
			inkEditX.SelectAll();
		}

		private void linkLabel1_LinkClicked(object sender, System.Windows.Forms.LinkLabelLinkClickedEventArgs e)
		{
			this.inkEditX.SelectAll();
			this.inkEditX.Focus();
		}

		private void linkLabel2_LinkClicked(object sender, System.Windows.Forms.LinkLabelLinkClickedEventArgs e)
		{
			this.inkEditX.Clear();
			this.inkEditX.Focus();
		}



		/// <summary>
		/// 
		/// </summary>
		public string InkText
		{
			get
			{
				return inkEditX.Text;
			}
			set
			{
				inkEditX.Text = value;
			}
		}

	}
}
