using System;
using System.Collections;
using System.ComponentModel;
using System.ComponentModel.Design;
using System.Drawing;
using System.Diagnostics;
using System.Drawing.Drawing2D;
using System.Drawing.Design;
using System.Data;
using System.Windows.Forms;
using System.Windows.Forms.Design;
using System.Windows.Forms.ComponentModel;
using Microsoft.DirectX;
using Microsoft.DirectX.Direct3D;


namespace MhsModelCSharp
{
	/// <summary>
	/// Summary description for Vector3InkEditor.
	/// </summary>
	public class Vector3InkEditor : System.Drawing.Design.UITypeEditor
	{
		/// <summary>
		/// 
		/// </summary>
		public Vector3InkEditor()
		{
		}

		/// <summary>
		/// 
		/// </summary>
		/// <param name="context"></param>
		/// <param name="provider"></param>
		/// <param name="value"></param>
		/// <returns></returns>
		public override object EditValue(ITypeDescriptorContext context, IServiceProvider provider, object value)
		{
			if( value.GetType() != typeof(Vector3) )
				return value;

			// Uses the IWindowsFormsEditorService to display a 
			// drop-down UI in the Properties window.
			IWindowsFormsEditorService edSvc = (IWindowsFormsEditorService)provider.GetService(typeof(IWindowsFormsEditorService));
			if( edSvc != null )
			{
				// Display an angle selection control and retrieve the value.
				Vector3InkerEditorControl inker = new Vector3InkerEditorControl();
				Vector3 v = (Vector3) value;
				inker.X = v.X;
				inker.Y = v.Y;
				inker.Z = v.Z;

				edSvc.ShowDialog( inker );
				//edSvc.DropDownControl( inker );

				return new Vector3(inker.X,inker.Y,inker.Z);
			}
			return value;
		}
			
		/// <summary>
		/// 
		/// </summary>
		/// <param name="context"></param>
		/// <returns></returns>
		public override bool GetPaintValueSupported(ITypeDescriptorContext context)
		{
			return false;
		}
		
		/// <summary>
		/// 
		/// </summary>
		/// <param name="context"></param>
		/// <returns></returns>
		public override UITypeEditorEditStyle GetEditStyle(ITypeDescriptorContext context)
		{
			return UITypeEditorEditStyle.Modal;
		}


	}
}
