<?php
	//This file handles administration module operations 
		
	session_start();

	// deny access for everyone except administrator
	if($_SESSION['isAdmin'] != "y")
		header("Location: logoff.php");
	
	require_once("tools.inc.php");

	//Adding selected semester and coming back to Admin's page
	if(isset($_GET['sem']) and $_GET['sem'] != "")
		{	addSemester($_GET['sem']);
			$_SESSION['adminPage'] = "Semesters";
			header("Location: admin.php");
		}
	
	//Setting current semester to work with and coming back to Admin's page
	if(isset($_GET['curSem']) and $_GET['curSem'] != "")
		{	$_SESSION['curSemester'] = $_GET['curSem'];
			$_SESSION['adminPage'] = "Semesters";
			header("Location: admin.php");
		}
	
	// Modify Class
	if(isset($_GET['course']) and isset($_GET['desc']) and isset($_GET['cap']) and isset($_GET['start']) and isset($_GET['end']) and isset($_GET['instr']) and isset($_GET['code']))
		{	updateClassData($_GET['course'], $_GET['desc'], $_GET['cap'], $_GET['start'], $_GET['end'], $_GET['instr'], $_GET['code']);
			$_SESSION['adminPage'] = "Classes";
			header("Location: admin.php");
		}
	
	// Add new class
	if(isset($_GET['desc']) and isset($_GET['start']) and isset($_GET['end']) and isset($_GET['cap']) and isset($_GET['instr']) and isset($_GET['code']) and isset($_GET['semester']))
		{	addNewClass($_GET['desc'], $_GET['start'], $_GET['end'], $_GET['cap'], $_GET['instr'], $_GET['code'], $_GET['semester']);
			$_SESSION['adminPage'] = "Classes";
			header("Location: admin.php");
		}
		
	// Take care about password generation
	if(isset($_GET['act']) and $_GET['act'] == "gp")
		{	if(isset($_SESSION['new_user']))
				{	$newUser = $_SESSION['new_user'];
					$newUser['password'] = generatePassword(9);
					$_SESSION['new_user'] = $newUser;
					$_SESSION['adminPage'] = "Create New User";

					header("Location: admin.php");
				}
		}

	// Create new user	
	if(isset($_GET['act']) and $_GET['act'] == "nu")
		{	if(isset($_SESSION['new_user']))
				{	$errors = "";
					$new_user = $_SESSION['new_user'];
					
					if(!isUserNameUnique($new_user['user_name']))
						$errors = "User name already exists. Specify another one. ";
					if(!validateStringLength($new_user['password'], 6))
						$errors = $errors."Password must be at least six characters long. ";
					if(!validateEMail($new_user['email']))
						$errors = $errors."Incorrect E-Mail address. Please correct. ";
						
					if($errors == "")
						{	createNewUser($new_user['fname'], $new_user['lname'], $new_user['password'], $new_user['isAdmin'], $new_user['user_name'], $new_user['email'], $new_user['send_email']);
							$_SESSION['adminPage'] = "User Manager";
							unset($_SESSION['new_user']);
							header("Location: admin.php");
							
						}
					else
						{	$new_user['errors'] = $errors;
							$_SESSION['adminPage'] = "Create New User";

							header("Location: admin.php");
						}
				}
		}
		
// DELETE question	
if($_GET['act'] == "del" and isset($_SESSION['curQuestion']))
	{	deleteQuestion($_SESSION['curQuestion']);
		unset($_SESSION['curQuestion']);
		$_SESSION['adminPage'] = "Questions Bank";
		
		header("Location: admin.php");
	}		
		
// Take care about user modification	
	if(isset($_GET['act']) and $_GET['act'] == "mu")
		{	if(isset($_SESSION['modified_user']))
				{	$errors = "";
					$modified_user = $_SESSION['modified_user'];
					
					if(!validateStringLength($modified_user['fname'], 1))
						$errors = $errors."First name cannot be blank.<br>";
					if(!validateStringLength($modified_user['lname'], 1))
						$errors = $errors."Last name cannot be blank.<br>";

					$old_user_name = getUserInfoByID($modified_user['id']);

					if(stripcslashes(trim(strip_tags(strtolower($modified_user['user_name'])))) != trim(strip_tags(strtolower($old_user_name['userName']))))
						{	if(!isUserNameUnique($modified_user['user_name']))
								$errors = $errors."User name already exists. Specify another one.<br>";
						}
					
					// if password is reset
					if(isset($modified_user['password']))
						{	if(!validateStringLength($modified_user['password'], 6))
								$errors = $errors."Password must be at least six characters long.<br>";
						}
					else 
						$modified_user['password'] = "";
						
					if(!validateEMail($modified_user['email']))
						$errors = $errors."Incorrect E-Mail address. Please correct.<br>";
					
					// everything is OK, modify user and return to admin module
					if($errors == "")
						{	modifyUser($modified_user['id'], $modified_user['fname'], $modified_user['lname'], $modified_user['password'], $modified_user['isAdmin'], $modified_user['user_name'], $modified_user['email'], $modified_user['send_email']);
							$_SESSION['adminPage'] = "User Manager";
							unset($_SESSION['modified_user']);
							
							header("Location: admin.php");
						}
					else // there are some errors -> return back to admin to correct'em
						{	$modified_user['errors'] = $errors;
							$_SESSION['modified_user'] = $modified_user;
							$_SESSION['adminPage'] = "View / Modify User";

							header("Location: admin.php");
						}
				}
		}

// Delete user
if(isset($_GET['du']) and $_GET['du'] != "")
	{	deleteUser($_GET['du']);
		$_SESSION['adminPage'] = "User Manager";
		
		header("Location: admin.php");
	}

?>