<?php

session_start();

if(!isset($_SESSION['authenticated']) or $_SESSION['authenticated'] != 1)
	header("Location: logoff.php");
	
require_once("tools.inc.php");




function createChart($array_In)
	{	header("Content-type: image/jpeg");
		DEFINE("RATIO_X", 5.5);
		DEFINE("RATIO_Y", 3);
		DEFINE("DIAMETER", 17);
		DEFINE("BASE_WIDTH", 600);
		DEFINE("BASE_HEIGHT", 400);
		DEFINE("SMALL_WIDTH", 550);
		DEFINE("SMALL_HEIGHT", 350);
		
		$numberOfScores = count($array_In);
		
		if($numberOfScores != 0)
			{	$space = SMALL_WIDTH / $numberOfScores;	
			}
		else
			{	$space = 0;
				$array_In = array(0);			
			}			
			
		//Create image
		$im = @imagecreate(BASE_WIDTH, BASE_HEIGHT)
			or die("Cannot Initialize new GD image stream");

		//Generating grids and other template stuff
		$background_color = imagecolorallocate($im, 239, 239, 239);
		$text_color = imagecolorallocate($im, 10, 100, 100);
		$white_color = imagecolorallocate($im, 255, 255, 255);
		$grey_color = imagecolorallocate($im, 204, 204, 204);
		$black_color = imagecolorallocate($im, 0, 0, 0);
		$blue_color = imagecolorallocate($im, 0, 0, 255);
		$red_color = imagecolorallocate($im, 255, 0, 0);

		//Draw frame and white background
		imagerectangle($im, 0, 0, BASE_WIDTH-1, BASE_HEIGHT-1, $black_color);
		imagefilledrectangle ($im, 50, 50, SMALL_WIDTH, SMALL_HEIGHT, $white_color);

		//Draw axes and lines
		for($i = 50; $i <= 350; $i = $i + 30)
			{	imageline($im, 50, $i, 550, $i, $grey_color);
				imageline($im, 50, $i, 56, $i, $black_color);

				if($i < 350)
					imageline($im, 50, $i + 15, 53, $i + 15, $black_color);
			}

		//Draw "score" label
		imagestringup($im, 5, 5, 220, score, $black_color);
		
		$offset = 343;

		for($i = 0; $i <= 100; $i = $i + 10)
			{	imagestring($im, 2, 30, $offset, $i, $text_color);
				$offset = $offset - 30;
			}

	//Draw axes
		imageline($im, 50, 50, 50, 350, $black_color);
		imageline($im, 50, 350, 550, 350, $text_color);

		sort($array_In);
		
		
		if($numberOfScores != 0)
			$averageScore = round((array_sum($array_In) / $numberOfScores), 1);
		else
			$averageScore = 0;
		
	 //Draw thick red average line and its label and returns thickness back to normal
		imagesetthickness($im, 2);
		imageline($im, 50, (100 - $averageScore) * RATIO_Y + 50, SMALL_WIDTH + 5, (100 - $averageScore) * RATIO_Y + 50, $red_color);
		imagestring($im, 2, SMALL_WIDTH - 39, (100 - $averageScore) * RATIO_Y + 60, "Average = ".$averageScore, $red_color);
		imagesetthickness($im, 1);
			
			
		for($i = 0; $i < $numberOfScores; $i++)
			{	imageellipse($im, 50 + $i * $space, ((100 - $array_In[$i]) * RATIO_Y + 50), DIAMETER + 1, DIAMETER + 1, $black_color);
				imagefilledellipse($im, 50 + $i * $space, ((100 - $array_In[$i]) * RATIO_Y + 50), DIAMETER, DIAMETER, $blue_color);
				imagestring($im, 1, 50 + centerLabel($array_In[$i]) + $i * $space, ((100 - $array_In[$i]) * RATIO_Y + 46), $array_In[$i], $background_color);
			}

	//Draw the image and erase it from memory
		imagejpeg($im, "", 97);
		imagedestroy($im);
	}
	
//This function returns offset value to align text within circles
function centerLabel($value_In)
	{	if($value_In < 10)
			$offset = -2;
		elseif($value_In >= 10 and $value_In <=99)
			$offset = -4;
		else
			$offset = -7;
		
		return $offset;
	}

if(isset($_SESSION['selectedTest']))
	{	$query = @mysql_query("SELECT grade.user_grade FROM grade WHERE grade.test_id=".$_SESSION['selectedTest'].";");
	
		if(!$query)
			die("Could not initialize image data!");
			
		while($row = @mysql_fetch_array($query))
			$score[] = $row['user_grade'];

		createChart($score);
	}


?>