<?php

// Create misc. HTML elements.

function makeDropDownList($array_In, $selected_Value, $list_Height=1, $list_Name, $jscript="")
	{	if(!isset($list_Height))
			$list_Height = 1;
		
		$dropDownList = "<select name='".$list_Name."' size='".$list_Height."'";
		
		if($jscript != "")
			$dropDownList = $dropDownList." ".$jscript.">\n";
		else
			$dropDownList = $dropDownList.">\n";
		if(count($array_In) == 0)
			$array_In[0] = "none available";
			
		foreach ($array_In as $key => $value)
			{	if($value == $selected_Value)
			  		$dropDownList = $dropDownList."\t<option value='".$value."' selected>$value</option>\n";
			  	else
			  		$dropDownList = $dropDownList."\t<option value='".$value."'>$value</option>\n";
			}
			

		$dropDownList = $dropDownList."</select>\n";
		
		return $dropDownList;
	
	}

// Creates DropDown list setting $array_in keys as values
// Usefull for linking PKs with some values.
function makeDropDownListByKey($array_In, $selected_Value, $list_Height=1, $list_Name, $jscript="")
	{	if(!isset($list_Height))
			$list_Height = 1;
		
		$dropDownList = "<select name='".$list_Name."' size='".$list_Height."'";
		
		if($jscript != "")
			$dropDownList = $dropDownList." ".$jscript.">\n";
		else
			$dropDownList = $dropDownList.">\n";

		foreach ($array_In as $key => $value)
			{	if($value == $selected_Value)
			  		$dropDownList = $dropDownList."\t<option value='".$key."' selected>$value</option>\n";
			  	else
			  		$dropDownList = $dropDownList."\t<option value='".$key."'>$value</option>\n";
			}
			
		$dropDownList = $dropDownList."</select>\n";
		
		echo $dropDownList;
		
	}
	
	
function makeHyperlink($url_text, $url_link, $status_bar_text, $title_text, $open_In = "_self")
	{	$url_text = htmlentities($url_text, ENT_QUOTES);
		$status_bar_text = htmlentities($status_bar_text, ENT_QUOTES);
		$title_text = htmlentities($title_text, ENT_QUOTES);
		
		$hyperlink = "<a href=\"".$url_link."\" title=\"".$title_text."\" target=\"".$open_In."\" onMouseOver=\"status='".$status_bar_text."';return document\" onMouseOut=\"status='';return document\">".$url_text."</a>\n";
				
		return $hyperlink;

	}
	
function makeRadioButton($radioButton_Name, $radioButton_Value, $checked = False)
	{	if($checked)
			$checkedValue = " checked";
		else
			$checkedValue = "";
		
	
		$radioButton = "\t<input type=\"radio\" name=\"".$radioButton_Name."\" value=\"".$radioButton_Value."\"$checkedValue>\n";
		
		return $radioButton;
	}

// Returns Dropdown list with all the specified style, JScript attributes.
// Allows to specify either values are set to its options, or to input array keys
function makeAdvancedDropDownList($array_In, $selected_Value, $list_Height=1, $list_Name, $jscript="", $style="", $valueBy="key", $allow_multiple=false)
	{	if($allow_multiple == true)
			$multiple = "multiple";
		else
			$multiple = "";
			
		$dropDownList = "\t<select name='".$list_Name."' id='".$list_Name."' size='".$list_Height."' ".$multiple." style='".$style."' ".$jscript.">\n";
		
		if(count($array_In) == 0)
			$array_In[0] = "none available";
		elseif(count($array_In) == 1 and $list_Height == 1)
			$array_In[0] = "select one";

		if($valueBy == "key")
			{	foreach ($array_In as $key => $value)
					{	if($key == $selected_Value)
							$dropDownList = $dropDownList."\t\t<option value='".$key."' selected>$value</option>\n";
						else
							$dropDownList = $dropDownList."\t\t<option value='".$key."'>$value</option>\n";
					}
			}
		elseif($valueBy == "value")
			{	foreach ($array_In as $key => $value)
					{	if($value == $selected_Value)
							$dropDownList = $dropDownList."\t\t<option value='".$value."' selected>$value</option>\n";
						else
							$dropDownList = $dropDownList."\t\t<option value='".$value."'>$value</option>\n";
					}
			}

		$dropDownList = $dropDownList."\t</select>\n";
		
		return $dropDownList;
		
	}

?>