<?PHP
	session_start();

	if(!isset($_SESSION['authenticated']) or $_SESSION['authenticated'] != 1)
		header("Location: logoff.php");

	if(!isset($_SESSION['curSemester']) or !isset($_SESSION['curClassID']))
		header("Location: welcome.php");

	require_once("tools.inc.php");

	if(getInstructorIDFromClasID($_SESSION['curClassID']) != $_SESSION['user_id'])
	header("Location: logoff.php");
	
	// Take care about user modification	
	if(isset($_GET['act']) and $_GET['act'] == "ms")
		{	if(isset($_SESSION['modified_user']))
				{	$errors = "";
					$modified_user = $_SESSION['modified_user'];

					if(!validateStringLength($modified_user['fname'], 1))
						$errors = $errors."First name cannot be blank.<br>";
					if(!validateStringLength($modified_user['lname'], 1))
						$errors = $errors."Last name cannot be blank.<br>";

					$old_user_name = getUserInfoByID($modified_user['id']);

					if(stripcslashes(trim(strip_tags(strtolower($modified_user['user_name'])))) != trim(strip_tags(strtolower($old_user_name['userName']))))
						{	if(!isUserNameUnique($modified_user['user_name']))
								$errors = $errors."User name already exists. Specify another one.<br>";
						}

					if(isset($modified_user['password']))
						{	if(!validateStringLength($modified_user['password'], 6))
								$errors = $errors."Password must be at least six characters long.<br>";
						}
					else
						$modified_user['password'] = "";

					if(!validateEMail($modified_user['email']))
						$errors = $errors."Incorrect E-Mail address. Please correct.<br>";

					if($errors == "")
						{	modifyUser($modified_user['id'], $modified_user['fname'], $modified_user['lname'], $modified_user['password'], "n", $modified_user['user_name'], $modified_user['email'], $modified_user['send_email']);
							$_SESSION['instrPage'] = "Roster";
							unset($_SESSION['modified_user']);

							header("Location: instructor.php");
						}
					else
						{	$modified_user['errors'] = $errors;
							$_SESSION['modified_user'] = $modified_user;
							$_SESSION['instrPage'] = "Modify Student";

							header("Location: instructor.php");
						}
				}
		}
		
// Withdraw student		
	if(isset($_GET['act']) and $_GET['act'] == "ds" and isset($_GET['sid']) and $_GET['sid'] != "")
		{	withdrawStudent($sid, $_SESSION['curClassID']);
			$_SESSION['instrPage'] = "Roster";
			header("Location: instructor.php");
		}
		
// Take care about class enrollment	
	if(isset($_GET['act']) and $_GET['act'] == "ens" and isset($_GET['sids']) and ($_GET['sids'] != "" or $_GET['sids'] != ","))
		{	$toAdd = explode(",", $_GET['sids']);
			$total = count($toAdd);
			
			for($i = 0; $i < $total; $i++)
						enrollStudent($toAdd[$i], $_SESSION['curClassID']);
			
			$_SESSION['instrPage'] = "Roster";
			header("Location: instructor.php");		
		}

// Create a new student		
	if(isset($_GET['act']) and $_GET['act'] == "ns")
		{	if(isset($_SESSION['new_user']))
				{	$errors = "";
					$new_user = $_SESSION['new_user'];
					
					if(!isUserNameUnique($new_user['user_name']))
						$errors = "User name already exists. Specify another one. ";
					if(!validateStringLength($new_user['password'], 6))
						$errors = $errors."Password must be at least six characters long. ";
					if(!validateEMail($new_user['email']))
						$errors = $errors."Incorrect E-Mail address. Please correct. ";
						
					if($errors == "")
						{	createNewUser($new_user['fname'], $new_user['lname'], $new_user['password'], "n", $new_user['user_name'], $new_user['email'], $new_user['send_email']);
							$_SESSION['instrPage'] = "Enroll More Students";
							unset($_SESSION['new_user']);
							header("Location: instructor.php");
							
						}
					else
						{	$new_user['errors'] = $errors;
							$_SESSION['new_user'] = $new_user;
							$_SESSION['instrPage'] = "Create New Student";

							header("Location: instructor.php");
						}
				}
		}

// Generate user's password		
if(isset($_GET['act']) and $_GET['act'] == "gp")
	{	if(isset($_SESSION['new_user']))
			{	$newUser = $_SESSION['new_user'];
				$newUser['password'] = generatePassword(9);
				$_SESSION['new_user'] = $newUser;
				$_SESSION['instrPage'] = "Create New Student";

				header("Location: instructor.php");
			}
	}		


// Creating new test
if(isset($_SESSION['new_test']) and !empty($_SESSION['new_test']))
	{	$test = $_SESSION['new_test'];	

		createTest($_SESSION['curClassID'], $test['test_description'], $test['test_date'], $test['test_start_time'], $test['test_end_time'], $test['test_duration']);
		
		unset($_SESSION['new_test']);
		unset($test);
		
		$_SESSION['instrPage'] = "Tests";
		header("Location: instructor.php");
	}

// Modify Test / Update questions' points
if(isset($_SESSION['modified_test']) and !empty($_SESSION['modified_test']))
	{	$modified_test = $_SESSION['modified_test'];

		modifyTest($_SESSION['editTest'], $modified_test['test_description'], $modified_test['test_start_time'], $modified_test['test_end_time'], $modified_test['test_date'], $modified_test['test_duration'], $modified_test['points']);
		
		unset($_SESSION['modified_test']);
		unset($modified_test);
		
		$_SESSION['instrPage'] = "Tests";
		header("Location: instructor.php");
	}


// Creating new question
if($_GET['act'] == "new_q" and isset($_SESSION['q_type']))
	{	if(trim($_SESSION['q_body']) == "")
			$errors = $errors."Question body cannot be blank <br>";
		if($_SESSION['correct_ans'] == "")
			$errors = $errors."Please select correct answer <br>";
		
		$blank_ans = false;
		
		$answers = $_SESSION['pos_answers'];
		
		foreach($answers as $value)
			{	if(trim($value) == "")
					$blank_ans = true;
			}
		
		if($_SESSION['q_type'] == 1)
			$blank_ans = false;
			
		if($blank_ans)
			$errors = $errors."You cannot have blank answer(s)";

		if($errors != "")
			{	$_SESSION['q_errors'] = $errors;
				$_SESSION['instrPage'] = "New Question";
				header("Location: instructor.php");
			}
		else
			{	createQuestion($_SESSION['q_type'], $_SESSION['q_body'], $answers, $_SESSION['correct_ans']);
				unset($_SESSION['pos_answers']);
				unset($_SESSION['q_body']);
				unset($_SESSION['correct_ans']);
				unset($_SESSION['q_type']);
				unset($_SESSION['q_errors']);
				$_SESSION['instrPage'] = "Questions Bank";
				
				header("Location: instructor.php");
			}
	}

// DELETE question	
if($_GET['act'] == "del" and isset($_SESSION['curQuestion']))
	{	deleteQuestion($_SESSION['curQuestion']);
		unset($_SESSION['curQuestion']);
		$_SESSION['instrPage'] = "Questions Bank";
		
		header("Location: instructor.php");
	}
	
// EDIT question	
if($_GET['act'] == "edit_q" and isset($_SESSION['edit_ans_ids']))
	{	$blank_ans = false;

		if(getQuestionInfo($_SESSION['curQuestion'], "type") != 1)
			{	$edited_answers = $_SESSION['edit_ans'];
		
				foreach($edited_answers as $value)
					{	if(trim($value) == "")
							$blank_ans = true;
					}
			}

		if($blank_ans)
			$errors = $errors."You cannot have blank answer(s) <br>";
		
		// This one is not necessary, but just in case...
		if(!isset($_SESSION['correct_ans']) or $_SESSION['correct_ans'] == "")
			$errors = $errors."Please select correct answer <br>";
			
		if(trim($_SESSION['edit_q_body']) == "")
			$errors = $errors."Question body cannot be blank <br>";
		
		if($errors != "")
			{	$_SESSION['edit_q_errors'] = $errors;
				$_SESSION['instrPage'] = "Edit Question";
				header("Location: instructor.php");
			}
		else
			{	updateQuestion($_SESSION['curQuestion'], $_SESSION['edit_q_body'], $edited_answers, $_SESSION['correct_ans']);
				$_SESSION['instrPage'] = "Questions Bank";
				unset($_SESSION['edit_q_body']);
				unset($_SESSION['edit_ans']);
				unset($_SESSION['correct_ans']);
				unset($_SESSION['curQuestion']);
				unset($_SESSION['edit_q_errors']);
				unset($_SESSION['edit_ans_ids']);
				
				header("Location: instructor.php");
			}	
	}

// Add question to test	
if($_GET['act'] == "add2test" and $_SESSION['q2add'] != "" and $_SESSION['add2test'] != "")
	{	addQuestionToTest($_SESSION['q2add'], $_SESSION['add2test']);
		
		unset($_SESSION['add2test']);
		unset($_SESSION['q2add']);
		
		$_SESSION['instrPage'] = "Questions Bank";
		header("Location: instructor.php");
	}

// Remove question from the test	
if($_GET['act'] == "rq")
	{	removeQuestionFromTest($_SESSION['editTest'], $_GET['qid']);	

		$_SESSION['instrPage'] = "Edit";
		header("Location: instructor.php");
	}
	
// Delete test
if($_GET['act'] == "dt")
	{	if(isset($_SESSION['editTest']) and $_SESSION['editTest'] != "")	
			deleteTest($_SESSION['editTest']);

		$_SESSION['instrPage'] = "Tests";
		unset($_SESSION['editTest']);

		header("Location: instructor.php");
	}
	
// Take care about profile modification	
if(isset($_GET['act']) and $_GET['act'] == "cp")
	{	if(isset($_SESSION['changed_profile']))
			{	$errors = "";
				$changed_profile = $_SESSION['changed_profile'];

				if(!validateStringLength($changed_profile['fname'], 1))
					$errors = $errors."First name cannot be blank.<br>";
				if(!validateStringLength($changed_profile['lname'], 1))
					$errors = $errors."Last name cannot be blank.<br>";

				if(isset($changed_profile['password']))
					{	if(!validateStringLength($changed_profile['password'], 6))
							$errors = $errors."Password must be at least six characters long.<br>";
					}
				else
					$changed_profile['password'] = "";

				if(!validateEMail($changed_profile['email']))
					$errors = $errors."Incorrect E-Mail address. Please correct.<br>";

				if($errors == "")
					{	changeProfile($_SESSION['user_id'], $changed_profile['fname'], $changed_profile['lname'], $changed_profile['password'], $changed_profile['email']);
						
						unset($_SESSION['changed_profile']);

						header("Location: instructor.php");
					}
				else
					{	$changed_profile['errors'] = $errors;
						$_SESSION['changed_profile'] = $changed_profile;
						$_SESSION['instrPage'] = "My Profile";

						header("Location: instructor.php");
					}
			}
	}
?>