<?PHP
	session_start();
	
	if(!isset($_SESSION['authenticated']) or $_SESSION['authenticated'] != 1)
		header("Location: logoff.php");
	
	if(!isset($_SESSION['curSemester']) or !isset($_SESSION['curClassID']))
		header("Location: welcome.php");
		
	require_once("tools.inc.php");
	require_once("calendar.inc.php");
	
	if(getInstructorIDFromClasID($_SESSION['curClassID']) != $_SESSION['user_id'])
		header("Location: logoff.php");
		
	if($_POST['action'] == "Log Off")
		header("Location: logoff.php");
	
	
	if($_POST['action'] == "Create New Student")
		unset($_SESSION['instrPage']);
	
// Cancel is cancel	
	if(isset($_POST['action']) and $_POST['action'] == 'Cancel')
		{	resetSessionVarsInstructor();		
		}
		
// Take care about setting session variables, passing them to instr.php to modify user	
	if(isset($_POST['action']) and $_POST['action'] == 'Modify')
		{	$modifiedUser['id'] = $_POST['userID'];
			$modifiedUser['fname'] = $_POST['fname'];
			$modifiedUser['lname'] = $_POST['lname'];
			$modifiedUser['user_name'] = $_POST['user_name'];
			
			if($_POST['validateReset'] == "y")
				$modifiedUser['password'] = $_POST['password'];
	
			$modifiedUser['email'] = $_POST['email'];
			$modifiedUser['send_email'] = $_POST['notification'];
			
			$_SESSION['modified_user'] = $modifiedUser;
			
			// Delete the temp array
			unset($modifiedUser);

			// Redirect to instr.php setting internal action to "ms" ("modify student")
			header("Location: instr.php?act=ms");
		}


// Take care about setting session variables, passing them to instr.php to create a new student	
	if(isset($_POST['action']) and $_POST['action'] == 'Create Student')
		{	$newUser['fname'] = $_POST['fname'];
			$newUser['lname'] = $_POST['lname'];
			$newUser['password'] = $_POST['password'];
			$newUser['user_name'] = $_POST['user_name'];
			$newUser['password'] = $_POST['password'];
			$newUser['email'] = $_POST['email'];
			$newUser['send_email'] = $_POST['notification'];
				
			$_SESSION['new_user'] = $newUser;
			
			// Delete the temp array
			unset($newUser);
			// Redirect to adm.php setting internal action to "ns" ("new student")
			header("Location: instr.php?act=ns");
		}
		
	// Taking care about setting variables while generating  password	
	if(isset($_POST['action']) and $_POST['action'] == 'Generate Password')
		{	$newUser['fname'] = $_POST['fname'];
			$newUser['lname'] = $_POST['lname'];
			$newUser['password'] = $_POST['password'];
			$newUser['isAdmin'] = $_POST['isAdmin'];
			$newUser['user_name'] = $_POST['user_name'];
			$newUser['password'] = $_POST['password'];
			$newUser['email'] = $_POST['email'];
			$newUser['send_email'] = $_POST['notification'];
			
			$_SESSION['new_user'] = $newUser;
			
			header("Location: instr.php?act=gp");
		}			
	
	// Switch class / semester
	if($_POST['action'] == "Change Class")
		{	unset($_SESSION['curSemester']);
			unset($_SESSION['curClassID']);
			header("Location: welcome.php");
		}
		
	// set vars for My Profile modification
	if($_POST['action'] == "Change")
		{	$changed_profile['fname'] = $_POST['fname'];
			$changed_profile['lname'] = $_POST['lname'];
			$changed_profile['email'] = $_POST['email'];
			
			if($_POST['validateReset'] == "y")
				$changed_profile['password'] = $_POST['password'];
			
			$_SESSION['changed_profile'] = $changed_profile;
			unset($changed_profile);

			header("Location: instr.php?act=cp");
		}
	

	
// Taking care about withdrawing student from a class
	if($_POST['action'] == "Withdraw Student")
		{	header("Location: instr.php?act=ds&sid=".$_POST['radiobutton']);
		}
	
// Enroll selected students	
	if($_POST['action'] == "Enroll Selected")
		{	if(isset($_POST['allUsers']))
				{	$toBeEnrolled = $_POST['allUsers'];
				
					$how_many = count($toBeEnrolled);

					$url_to_pass = "";

					for($i = 0; $i < $how_many; $i++)
						$url_to_pass = $url_to_pass.$toBeEnrolled[$i].",";

					$url_to_pass = substr($url_to_pass, 0, -1);
					
					header("Location: instr.php?act=ens&sids=".$url_to_pass);
				}
			else
				echo ("<h1>Incorrect Student Enrollment call!</h1>");
		}
		
// Create test
	if($_POST['action'] == "Create Test")
		{	$hours_start = $_POST['h_s'];
			$min_start = $_POST['m_s'];
			
			if($min_start < 10)
				$min_start = "0".$min_start;

			$start_time = $hours_start.":".$min_start.":00";
			
			$hours_end = $_POST['h_end'];
			$min_end = $_POST['m_end'];
			
			if($min_end < 10)
				$min_end = "0".$min_end;
			
			$end_time = $hours_end.":".$min_end.":00";
			$new_test = array("test_description"=>$_POST['testDescription'], "test_start_time"=>$start_time,
									"test_end_time"=>$end_time, "test_date"=>$_POST['testDate'], "test_duration"=>$_POST['testDuration']);
			
			$_SESSION['new_test'] = $new_test;
			
			header("Location: instr.php");
		}

		
	if($_POST['action'] == "Save Question")
		{	if($_POST['q_type'] == 1) //True-False
				{	$pos_answers[0] = "False";
					$pos_answers[1] = "True";
					$_SESSION['pos_answers'] = $pos_answers;
				}
			else
				$_SESSION['pos_answers'] = $_POST['ans'];
		
			$_SESSION['q_body'] = $_POST['q_body'];
			$_SESSION['correct_ans'] = $_POST['correct'];
			$_SESSION['q_type'] = $_POST['q_type'];
			
			header("Location: instr.php?act=new_q");
		}
		
	if($_POST['action'] == "Delete Question")
		{	if(isset($_SESSION['curQuestion']))
				header("Location: instr.php?act=del");	
		}


	if($_POST['action'] == "Remove Question")
		{	if(isset($_SESSION['editTest']) and $_SESSION['editTest'] != "")	
				header("Location: instr.php?act=rq&qid=".$_POST['selected_question']);
		}
		
	if($_POST['action'] == "Delete Test")
		{	if(isset($_SESSION['editTest']) and $_SESSION['editTest'] != "")
				header("Location: instr.php?act=dt");
		}
		
	if($_POST['action'] == "Modify Test")
		{	$hours_start = $_POST['h_s'];
			$min_start = $_POST['m_s'];

			if($min_start < 10)
				$min_start = "0".$min_start;

			$start_time = $hours_start.":".$min_start.":00";

			$hours_end = $_POST['h_end'];
			$min_end = $_POST['m_end'];

			if($min_end < 10)
				$min_end = "0".$min_end;

			$end_time = $hours_end.":".$min_end.":00";
			$modified_test = array("test_description"=>$_POST['testDescription'], "test_start_time"=>$start_time,
									"test_end_time"=>$end_time, "test_date"=>$_POST['testDate'], "test_duration"=>$_POST['testDuration'], "points"=>$_POST['q_score']);

			$_SESSION['modified_test'] = $modified_test;

			header("Location: instr.php");
		}

	
	if($_POST['action'] == "Modify Question")
		{	if(getQuestionInfo($_SESSION['curQuestion'], "type") == 1) //True-False
				{	$edit_ans[0] = "False";
					$edit_ans[1] = "True";
					$_SESSION['edit_ans'] = $edit_ans;
				}
			else
				$_SESSION['edit_ans'] = $_POST['ans'];
			
			$_SESSION['edit_q_body'] = $_POST['q_body'];
			$_SESSION['correct_ans'] = $_POST['correct'];
		
			header("Location: instr.php?act=edit_q");
		}
	
	
	if($_POST['action'] == "Add to test" and $_POST['all_questions'] != "" and $_POST['testSelector'] != "")
		{	$_SESSION['q2add'] = $_POST['all_questions'];
			$_SESSION['add2test'] = $_POST['testSelector'];
			
			header("Location: instr.php?act=add2test");
		}
	
	if(isset($_SESSION['instrPage']))
		{	$action = $_SESSION['instrPage'];
			unset($_SESSION['instrPage']);
		}
	
?>

<html>
<head>
<title>tesTerra Instructor</title>
<meta http-equiv="Content-Type" content="text/html; charset=windows-1251">
<script language="JavaScript" src="js.js"></script>
<script language="JavaScript" src="ajax.js"></script>
<link href="q_and_a.css" rel="stylesheet" type="text/css">
</head>

<body bgcolor="#F8F8F8">
<form name="form1" method="post" action="<?PHP echo $_SERVER['PHP_SELF']; ?>">
  <table width="950" border="0" align="center" cellpadding="0" cellspacing="0">
    <tr> 
      <td height="40" width="697" colspan="4" valign="middle"><font size="5" face="Verdana, Arial, Helvetica, sans-serif"><em>tesTerra 
        Instructor
        
			<?php
				if(isset($action) and $action != "Cancel")
					echo " - ".$action;
			?>
        
        </em></font></td>
      <td width="150" height="40" align="right" valign="middle"><input name="action" type="submit" id="change" style="border-style:solid; border-color:#000066; border-width:1px; font-size:15px;  color:#000066; font:bold; background-color:#FFFFFF; width:107px; height:27px;" value="Change Class"></td>
      <td width="103" height="40" align="right" valign="middle"><input name="action" type="submit" id="logoff" style="border-style:solid; border-color:#CC0000; border-width:1px; font-size:15px;  color:#990000; font:bold; background-color:#FFFFFF; width:77px; height:27px;" value="Log Off"></td>
    </tr>
    <tr valign="middle"> 
      <td height="23" colspan="6" bgcolor="#000066"><font color="#CCCCCC" size="2" face="Verdana, Arial, Helvetica, sans-serif"> &nbsp;
      
      <?PHP
      	
      	$classInfo = getClassInfoByID($_SESSION['curClassID']);
   
      	echo $classInfo['code']." - ".$classInfo['description']." &nbsp; :: &nbsp; ";
      	echo $_SESSION['curSemester']." &nbsp; :: &nbsp; ";
      	echo $classInfo['startDate']." - ".$classInfo['endDate'];
      
      ?>
 </font> </td>
    </tr>
    <tr align="right"> 
      <td colspan="6"><font color="#454545" size="1" face="Verdana, Arial, Helvetica, sans-serif">
      
		<?PHP
			if($_SESSION['last_logon_date'] == "")
				echo $_SESSION['fname']." ".$_SESSION['lname']."; This is your first login.";
			else
				echo $_SESSION['fname']." ".$_SESSION['lname']."; last time you logged in on ".$_SESSION['last_logon_date']." from IP ".$_SESSION['last_logon_ip']; 
		?>
      
      </font></td>
    </tr>
    <tr valign="top" bordercolor="#FFFFFF"> 
    </tr>
    <tr> 
      <td height="7" colspan="6"> </td>
    </tr>
  </table> 
<br>
  <table width="950" border="0" align="center" cellpadding="0" cellspacing="0">
    <tr> 
      <td width="157" height="7"> </td>
      <td width="2" height="7" bgcolor="#000066"> </td>
      <td width="15" height="7"> </td>
      <td width="787"></td>
    </tr>
    <tr> 
      <td width="157" rowspan="9" valign="top">
<table width="157" border="0" cellspacing="0" cellpadding="0">
          <tr>
            <td><input name="action" type="submit" <?php if($action == "Tests" or $action == "New Test" or $action == "Edit" or $action == "Results") echo "disabled='true'"; ?> id="action" style="border-style:solid; border-color:#000066; border-width:<?php if($action == "Tests" or $action == "New Test" or $action == "Edit" or $action == "Results") echo "2px;"; else echo "1px;";?> font-size:17px; color:#000066; background-color:#EAEAEA; width:137px; height:27px;" value="Tests"></td>
          </tr>
          <tr>
            <td>&nbsp;</td>
          </tr>
          <tr>
            <td><input name="action" type="submit" <?php if($action == "Roster" or $action == "Enroll More Students" or $action == "Modify Student" or $action == "Create New Student") echo "disabled='true'"; ?> id="action" style="border-style:solid; border-color:#000066; border-width:<?php if($action == "Roster" or $action == "Enroll More Students" or $action == "Modify Student" or $action == "Create New Student") echo "2px;"; else echo "1px;";?> font-size:17px; color:#000066; background-color:#EAEAEA; width:137px; height:27px;" value="Roster"></td>
          </tr>
          <tr>
            <td>&nbsp;</td>
          </tr>
          <tr>
            <td><input name="action" type="submit" <?php if($action == "Questions Bank" or $action == "Edit Question" or $action == "Add to test" or $action == "New Question") echo "disabled='true'"; ?> id="action" style="border-style:solid; border-color:#000066; border-width:<?php if($action == "Questions Bank" or $action == "New Question" or $action == "Edit Question" or $action == "New Question") echo "2px;"; else echo "1px;";?> font-size:17px; color:#000066; background-color:#EAEAEA; width:137px; height:27px;" value="Questions Bank"></td>
          </tr>
          <tr>
            <td>&nbsp;</td>
          </tr>
          <tr>
            <td><input name="action" type="submit" <?php if($action == "My Profile") echo "disabled='true'"; ?>id="action" style="border-style:solid; border-color:#000066; border-width:<?php if($action == "My Profile") echo "2px;"; else echo "1px;";?> font-size:17px; color:#000066; background-color:#EAEAEA; width:137px; height:27px;" value="My Profile"></td>
          </tr>
          <tr>
            <td>&nbsp;</td>
          </tr>
        </table></td>
      <td width="2" bgcolor="#000066"> </td>
      <td width="15" rowspan="9">&nbsp;</td>
      <td width="787" rowspan="9" valign="top">
      
      <?PHP
      
			if(isset($action))
				{	switch($action)
					{	case "Roster":

							echo drawRoster($_SESSION['curClassID']);

						break;
						
						case "Modify Student":
							
							if(isset($_SESSION['modified_user']))
								{	$modified_user = $_SESSION['modified_user'];
									echo drawModifyStudentInterface($modified_user['id'], $modified_user['fname'], $modified_user['lname'], $modified_user['user_name'], $modified_user['password'], $modified_user['email'], $modified_user['send_mail'], $modified_user['errors']); 
								}
							else
								echo drawModifyStudentInterface($_POST['radiobutton']);

							$_SESSION['instrPage'] = "Roster";
							resetSessionVarsInstructor();

						break;
						

						case "Enroll More Students":
							$_SESSION['instrPage'] = "Roster";
							echo drawEnrollStudentInterface($_SESSION['user_id'], $_SESSION['curClassID']);
						
						break;


						case "Create New Student":
						
							$_SESSION['instrPage'] = "Enroll More Students";

							if(isset($_SESSION['modified_user']))
								unset($_SESSION['modified_user']);

							if(isset($_SESSION['new_user']))
								{	$newUser = $_SESSION['new_user'];
									echo drawCreateUserInterface_Instructor($newUser['fname'], $newUser['lname'], $newUser['password'], $newUser['user_name'], $newUser['email'], $newUser['send_email'], $newUser['errors']);
								}
							else

								echo drawCreateUserInterface_Instructor();
						
						break;
						
						case "Tests";
							
							echo drawTestManagerInterface($_SESSION['curClassID']);

						break;


						case "Cancel":

							resetSessionVarsInstructor();
							$action = $_SESSION['instrPage'];

						break;

						
						case "New Test":
							$_SESSION['instrPage'] = "Tests";
							echo makeCalendarBrowser($_SESSION['curSemester'], 470, 225, "Test_Date");
							echo drawCreateTestInterface($_SESSION['curSemester']);
						
						break;
						
						
						case "Edit":

							if(!isset($_SESSION['editTest']))
								$_SESSION['editTest'] = $_POST['selectedTest'];
							
							echo makeCalendarBrowser($_SESSION['curSemester'], 470, 225, "Test_Date");
							echo drawEditTestInterface($_SESSION['editTest'], $_SESSION['curSemester']);
							$_SESSION['instrPage'] = "Tests";
						break;
						

						case "Statistics":
							if(isset($_SESSION['selectedTest']))
								{	echo drawTestStatistics($_SESSION['selectedTest']);
								}
						
						break;

						
						case "Questions Bank":
						
							echo drawQuestionsBankInterface($_SESSION['curClassID'], $_SESSION['curSemester']);
						
						break;
						
						case "New Question":
							$_SESSION['instrPage'] = "Questions Bank";
							if(isset($_SESSION['q_errors']) and $_SESSION['q_errors'] != "")
								{	echo drawCreateQuestionInterface($_SESSION['q_body'], $_SESSION['q_errors'], $_SESSION['q_type'], $_SESSION['pos_answers'], $_SESSION['correct_ans']);
								}
							else
								echo drawCreateQuestionInterface();
						
						break;
						
						case "Edit Question":
							$_SESSION['instrPage'] = "Questions Bank";
							if($_SESSION['curQuestion'] == "")
								{	$_SESSION['curQuestion'] = $_POST['all_questions'];
								}

							if(isset($_SESSION['edit_q_errors']) and $_SESSION['edit_q_errors'] != "")
								{	echo drawEditQuestionInterface($_SESSION['curQuestion'], $_SESSION['edit_ans'], $_SESSION['edit_q_body'], $_SESSION['correct_ans'], $_SESSION['edit_q_errors'], $_SESSION['edit_ans_ids']);	
								}
							else
								echo drawEditQuestionInterface($_SESSION['curQuestion']);
						
						break;
						
						case "Results":
							
							$_SESSION['selectedTest'] = $_POST['selectedTest'];							
							echo drawTestResults_Instructor($_POST['selectedTest']);
					
						break;

						
						case "View / Grade":
							
							if(isset($_SESSION['selectedTest']))
								echo viewGradeStudentTest_Instructor($_SESSION['selectedTest'], $_POST['student']);
							else
								{	echo "No test was selected.";
								}
						break;
						
						
						case "My Profile":
						
							if(isset($_SESSION['changed_profile']))
								{	$changed_profile = $_SESSION['changed_profile'];
									echo drawMyProfile($_SESSION['user_id'], $changed_profile['fname'], $changed_profile['lname'], $changed_profile['email'], $changed_profile['password'], $changed_profile['errors']); 
								}
							else
								echo drawMyProfile($_SESSION['user_id']);
								
							if(isset($_SESSION['changed_profile']))
								unset($_SESSION['changed_profile']);
								
							unset($_SESSION['instrPage']);
						
						break;
						
						default:
							echo "<i>Welcome to tesTerra</i>";
						break;
					}
				}
      
      ?>
      
      </td>
    </tr>
    <tr> 
      <td width="2" bgcolor="#000066"> </td>
    </tr>
    <tr> 
      <td width="2" bgcolor="#000066"> </td>
    </tr>
    <tr> 
      <td width="2" bgcolor="#000066"> </td>
    </tr>
    <tr> 
      <td width="2" bgcolor="#000066"> </td>
    </tr>
    <tr> 
      <td width="2" bgcolor="#000066"> </td>
    </tr>
    <tr> 
      <td width="2" bgcolor="#000066"> </td>
    </tr>
    <tr> 
      <td width="2" bgcolor="#000066"> </td>
    </tr>
    <tr> 
      <td width="2" bgcolor="#000066"> </td>
    </tr>
    <tr> 
      <td colspan="4">&nbsp; </td>
    </tr>
    <tr bgcolor="#000066"> 
      <td height="3" colspan="4"> </td>
    </tr>
    <tr align="right"> 
      <td colspan="4"><font color="#454545" size="1" face="Verdana, Arial, Helvetica, sans-serif">tesTerra 
        &copy;</font></td>
    </tr>
  </table>
</form>
</body>
</html>
