/*
 * Decompiled with CFR 0.152.
 */
import java.awt.Graphics;
import java.awt.Image;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import javax.imageio.ImageIO;

public class DungeonMap
extends Map {
    private Image floorImage;
    private Image entranceImage;
    private Image exitImage;
    private Image chestImage;
    private ArrayList wallList;
    private ArrayList roomList;
    private TreasureChest[] chest;
    private int random;
    public static final int TOP = 0;
    public static final int RIGHT = 1;
    public static final int BOTTOM = 2;
    public static final int LEFT = 3;
    public static final int TOP_BUFFER = 3;
    public static final int RIGHT_BUFFER = 3;
    public static final int BOTTOM_BUFFER = 3;
    public static final int LEFT_BUFFER = 4;

    public DungeonMap(int level, int levelChange) {
        int j;
        int i;
        try {
            this.floorImage = ImageIO.read(new File("image_files/cave_floor.gif"));
            this.entranceImage = ImageIO.read(new File("image_files/stairs_up.gif"));
            this.exitImage = ImageIO.read(new File("image_files/stairs_down.gif"));
            this.chestImage = ImageIO.read(new File("image_files/chest.gif"));
            if (level >= 1 && level <= 10) {
                this.image = ImageIO.read(new File("image_files/dungeon_floor_10x10.gif"));
            } else if (level > 10 && level <= 20) {
                this.image = ImageIO.read(new File("image_files/dungeon_floor_20x20.gif"));
            } else if (level > 20 && level <= 30) {
                this.image = ImageIO.read(new File("image_files/dungeon_floor_30x30.gif"));
            } else if (level > 30 && level <= 40) {
                this.image = ImageIO.read(new File("image_files/dungeon_floor_40x40.gif"));
            } else if (level > 40 && level <= 50) {
                this.image = ImageIO.read(new File("image_files/dungeon_floor_50x50.gif"));
            }
        }
        catch (IOException exception) {
            System.out.println("Caught exception: " + exception);
        }
        this.width = this.image.getWidth(null) / 32;
        this.height = this.image.getHeight(null) / 32;
        this.tile = new MazeTile[this.width][this.height];
        this.wallList = new ArrayList();
        this.roomList = new ArrayList();
        for (i = 0; i < this.width; ++i) {
            for (j = 0; j < this.height; ++j) {
                this.tile[i][j] = new MazeTile(i, j);
            }
        }
        for (i = 4; i < this.width - 3; ++i) {
            for (j = 3; j < this.height - 3; ++j) {
                if (i % 2 == 0) {
                    this.tile[i][j].setPassable(false);
                    continue;
                }
                if (j % 2 == 1) {
                    this.tile[i][j].setPassable(false);
                    continue;
                }
                this.roomList.add(this.tile[i][j]);
            }
        }
        this.chest = new TreasureChest[(level - 1) / 10 + 1];
        for (i = 0; i <= (level - 1) / 10; ++i) {
            this.random = (int)(Math.random() * (double)this.roomList.size());
            this.chest[i] = new TreasureChest(level, ((MazeTile)this.roomList.get(this.random)).getColumn(), ((MazeTile)this.roomList.get(this.random)).getRow());
            ((MazeTile)this.tile[((MazeTile)this.roomList.get(this.random)).getColumn()][((MazeTile)this.roomList.get(this.random)).getRow()]).setTreasureChest(true);
            ((MazeTile)this.tile[((MazeTile)this.roomList.get(this.random)).getColumn()][((MazeTile)this.roomList.get(this.random)).getRow()]).setPassable(false);
            this.roomList.remove(this.random);
        }
        this.random = (int)(Math.random() * (double)this.roomList.size());
        ((MazeTile)this.tile[((MazeTile)this.roomList.get(this.random)).getColumn()][((MazeTile)this.roomList.get(this.random)).getRow()]).setExit(true);
        if (levelChange < 0) {
            this.heroColumn = ((MazeTile)this.roomList.get(this.random)).getColumn();
            this.heroRow = ((MazeTile)this.roomList.get(this.random)).getRow();
        }
        this.roomList.remove(this.random);
        this.random = (int)(Math.random() * (double)this.roomList.size());
        ((MazeTile)this.tile[((MazeTile)this.roomList.get(this.random)).getColumn()][((MazeTile)this.roomList.get(this.random)).getRow()]).setVisited(true);
        ((MazeTile)this.tile[((MazeTile)this.roomList.get(this.random)).getColumn()][((MazeTile)this.roomList.get(this.random)).getRow()]).setEntrance(true);
        if (levelChange > 0) {
            this.heroColumn = ((MazeTile)this.roomList.get(this.random)).getColumn();
            this.heroRow = ((MazeTile)this.roomList.get(this.random)).getRow();
        }
        if (((MazeTile)this.roomList.get(this.random)).getRow() != 4) {
            this.wallList.add(this.tile[((MazeTile)this.roomList.get(this.random)).getColumn()][((MazeTile)this.roomList.get(this.random)).getRow() - 1]);
        }
        if (((MazeTile)this.roomList.get(this.random)).getColumn() != this.width - 5) {
            this.wallList.add(this.tile[((MazeTile)this.roomList.get(this.random)).getColumn() + 1][((MazeTile)this.roomList.get(this.random)).getRow()]);
        }
        if (((MazeTile)this.roomList.get(this.random)).getRow() != this.height - 5) {
            this.wallList.add(this.tile[((MazeTile)this.roomList.get(this.random)).getColumn()][((MazeTile)this.roomList.get(this.random)).getRow() + 1]);
        }
        if (((MazeTile)this.roomList.get(this.random)).getColumn() != 5) {
            this.wallList.add(this.tile[((MazeTile)this.roomList.get(this.random)).getColumn() - 1][((MazeTile)this.roomList.get(this.random)).getRow()]);
        }
        while (!this.wallList.isEmpty()) {
            this.random = (int)(Math.random() * (double)this.wallList.size());
            if (((MazeTile)this.wallList.get(this.random)).getColumn() % 2 == 0) {
                if (!((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn() - 1][((MazeTile)this.wallList.get(this.random)).getRow()]).hasBeenVisited() || !((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn() + 1][((MazeTile)this.wallList.get(this.random)).getRow()]).hasBeenVisited()) {
                    if (!((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn() - 1][((MazeTile)this.wallList.get(this.random)).getRow()]).hasBeenVisited()) {
                        ((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn() - 1][((MazeTile)this.wallList.get(this.random)).getRow()]).setVisited(true);
                        ((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn()][((MazeTile)this.wallList.get(this.random)).getRow()]).setPassable(true);
                        if (((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn() - 1][((MazeTile)this.wallList.get(this.random)).getRow()]).getRow() != 4 && !((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn() - 1][((MazeTile)this.wallList.get(this.random)).getRow() - 1]).isInWallList()) {
                            this.wallList.add((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn() - 1][((MazeTile)this.wallList.get(this.random)).getRow() - 1]);
                        }
                        if (((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn() - 1][((MazeTile)this.wallList.get(this.random)).getRow()]).getRow() != this.height - 5 && !((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn()][((MazeTile)this.wallList.get(this.random)).getRow() + 1]).isInWallList()) {
                            this.wallList.add((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn() - 1][((MazeTile)this.wallList.get(this.random)).getRow() + 1]);
                        }
                        if (((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn() - 1][((MazeTile)this.wallList.get(this.random)).getRow()]).getColumn() != 5 && !((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn() - 2][((MazeTile)this.wallList.get(this.random)).getRow()]).isInWallList()) {
                            this.wallList.add((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn() - 2][((MazeTile)this.wallList.get(this.random)).getRow()]);
                        }
                    } else if (!((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn() + 1][((MazeTile)this.wallList.get(this.random)).getRow()]).hasBeenVisited()) {
                        ((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn() + 1][((MazeTile)this.wallList.get(this.random)).getRow()]).setVisited(true);
                        ((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn()][((MazeTile)this.wallList.get(this.random)).getRow()]).setPassable(true);
                        if (((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn() + 1][((MazeTile)this.wallList.get(this.random)).getRow()]).getRow() != 4 && !((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn() + 1][((MazeTile)this.wallList.get(this.random)).getRow() - 1]).isInWallList()) {
                            this.wallList.add((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn() + 1][((MazeTile)this.wallList.get(this.random)).getRow() - 1]);
                        }
                        if (((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn() + 1][((MazeTile)this.wallList.get(this.random)).getRow()]).getColumn() != this.width - 5 && !((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn() + 2][((MazeTile)this.wallList.get(this.random)).getRow()]).isInWallList()) {
                            this.wallList.add((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn() + 2][((MazeTile)this.wallList.get(this.random)).getRow()]);
                        }
                        if (((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn() + 1][((MazeTile)this.wallList.get(this.random)).getRow()]).getRow() != this.height - 5 && !((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn() + 1][((MazeTile)this.wallList.get(this.random)).getRow() + 1]).isInWallList()) {
                            this.wallList.add((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn() + 1][((MazeTile)this.wallList.get(this.random)).getRow() + 1]);
                        }
                    }
                }
            } else if (!((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn()][((MazeTile)this.wallList.get(this.random)).getRow() - 1]).hasBeenVisited() || !((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn()][((MazeTile)this.wallList.get(this.random)).getRow() + 1]).hasBeenVisited()) {
                if (!((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn()][((MazeTile)this.wallList.get(this.random)).getRow() - 1]).hasBeenVisited()) {
                    ((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn()][((MazeTile)this.wallList.get(this.random)).getRow() - 1]).setVisited(true);
                    ((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn()][((MazeTile)this.wallList.get(this.random)).getRow()]).setPassable(true);
                    if (((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn()][((MazeTile)this.wallList.get(this.random)).getRow() - 1]).getRow() != 4 && !((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn()][((MazeTile)this.wallList.get(this.random)).getRow() - 2]).isInWallList()) {
                        this.wallList.add((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn()][((MazeTile)this.wallList.get(this.random)).getRow() - 2]);
                    }
                    if (((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn()][((MazeTile)this.wallList.get(this.random)).getRow() - 1]).getColumn() != this.width - 5 && !((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn() + 1][((MazeTile)this.wallList.get(this.random)).getRow() - 1]).isInWallList()) {
                        this.wallList.add((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn() + 1][((MazeTile)this.wallList.get(this.random)).getRow() - 1]);
                    }
                    if (((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn()][((MazeTile)this.wallList.get(this.random)).getRow() - 1]).getColumn() != 5 && !((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn() - 1][((MazeTile)this.wallList.get(this.random)).getRow() - 1]).isInWallList()) {
                        this.wallList.add((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn() - 1][((MazeTile)this.wallList.get(this.random)).getRow() - 1]);
                    }
                } else if (!((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn()][((MazeTile)this.wallList.get(this.random)).getRow() + 1]).hasBeenVisited()) {
                    ((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn()][((MazeTile)this.wallList.get(this.random)).getRow() + 1]).setVisited(true);
                    ((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn()][((MazeTile)this.wallList.get(this.random)).getRow()]).setPassable(true);
                    if (((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn()][((MazeTile)this.wallList.get(this.random)).getRow() + 1]).getColumn() != this.width - 5 && !((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn() + 1][((MazeTile)this.wallList.get(this.random)).getRow() + 1]).isInWallList()) {
                        this.wallList.add((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn() + 1][((MazeTile)this.wallList.get(this.random)).getRow() + 1]);
                    }
                    if (((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn()][((MazeTile)this.wallList.get(this.random)).getRow() + 1]).getRow() != this.height - 5 && !((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn()][((MazeTile)this.wallList.get(this.random)).getRow() + 2]).isInWallList()) {
                        this.wallList.add((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn()][((MazeTile)this.wallList.get(this.random)).getRow() + 2]);
                    }
                    if (((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn()][((MazeTile)this.wallList.get(this.random)).getRow() + 1]).getColumn() != 5 && !((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn() - 1][((MazeTile)this.wallList.get(this.random)).getRow() + 1]).isInWallList()) {
                        this.wallList.add((MazeTile)this.tile[((MazeTile)this.wallList.get(this.random)).getColumn() - 1][((MazeTile)this.wallList.get(this.random)).getRow() + 1]);
                    }
                }
            }
            this.wallList.remove(this.random);
        }
    }

    public void drawMap(Graphics g, int upperLeftX, int upperLeftY, int lowerRightX, int lowerRightY) {
        super.drawMap(g, upperLeftX, upperLeftY, lowerRightX, lowerRightY);
        int panelX = 0;
        for (int i = upperLeftX / 32; i < lowerRightX / 32; ++i) {
            int panelY = 0;
            for (int j = upperLeftY / 32; j < lowerRightY / 32; ++j) {
                if (this.tile[i][j].isPassable() && i >= 4 && i < this.width - 3 && j >= 3 && j < this.height - 3) {
                    g.drawImage(this.floorImage, panelX, panelY, null);
                }
                if (((MazeTile)this.tile[i][j]).isEntrance()) {
                    g.drawImage(this.entranceImage, panelX, panelY, null);
                }
                if (((MazeTile)this.tile[i][j]).isExit()) {
                    g.drawImage(this.exitImage, panelX, panelY, null);
                }
                if (((MazeTile)this.tile[i][j]).isTreasureChest()) {
                    g.drawImage(this.chestImage, panelX, panelY, null);
                }
                panelY += 32;
            }
            panelX += 32;
        }
    }

    public TreasureChest getChest(int column, int row) {
        for (int i = 0; i < this.chest.length; ++i) {
            if (this.chest[i].getColumn() != column || this.chest[i].getRow() != row) continue;
            return this.chest[i];
        }
        return null;
    }
}

