/*
FILE: DebuffingSpell.java
AUTHOR: Trevor Evans
CREATED: 3-31-06
MODIFIED: 4-24-06
*/

import java.io.*;
import java.applet.*;
import java.net.*;

/*
CLASS: DebuffingSpell
PURPOSE: Creates a spell of type DEBUFFING. These spells lower the target's stats when cast.
*/
public class DebuffingSpell extends Spell implements Serializable
{
	private double WISmultiplier; //this multiplied by caster's WIS determines the strength of the spell
	private int stat; //determines the stat that is affected by this spell

	public DebuffingSpell(String nameIn, int costIn, double multiplierIn, int statIn)
	{
		super(nameIn, costIn);
		type = DEBUFFING;
		WISmultiplier = multiplierIn;
		stat = statIn;
	}

	/*
	METHOD: cast(Hero, Monster)
	PURPOSE: Casts this spell on the specified target. Returns the appropriate message to
	be displayed in the battle log. Called when the hero is the caster and a monster is the
	target.
	*/
	public String cast(Hero caster, Monster target)
	{	//calculate strength of spell minus the target's resistance to spells
		int statDecrease = (int)(caster.getStat(GameCharacter.WIS) * WISmultiplier) - target.getStat(GameCharacter.MDEF);
		if(statDecrease < 0) statDecrease = 0; //stat decrease cannot be negative
		//update target's and caster's affected stats
		target.setStat(target.getStat(stat) - statDecrease, stat);
		caster.setMP(caster.getMP() - MPcost);
		//play casting sound effect
		try
		{
			soundEffectClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" +
													 	  "audio_files/spell.wav"));
		}
		catch (IOException exception)
		{
			soundEffectClip = null;
		}
		soundEffectClip.play();
		//return appropriate message
		String statName = "";
		if(stat == GameCharacter.ATK) statName = "ATK";
		else if(stat == GameCharacter.ACC) statName = "ACC";
		else if(stat == GameCharacter.DEF) statName = "DEF";
		else if(stat == GameCharacter.EVA) statName = "EVA";
		else if(stat == GameCharacter.WIS) statName = "WIS";
		else if(stat == GameCharacter.MDEF) statName = "MDEF";
		else if(stat == GameCharacter.SPD) statName = "SPD";
		return (caster.getName() + " casts " + this.name + ". The " + target.getName() + "'s " + statName +
				" decreases by " + statDecrease + ".");
	}

	/*
	METHOD: cast(Monster, Hero)
	PURPOSE: Casts this spell on the specified target. Returns the appropriate message to
	be displayed in the battle log. Called when a monster is the caster and the hero is the
	target.
	*/
	public String cast(Monster caster, Hero target)
	{	//calculate strength of spell minus the target's resistance to spells
		int statDecrease = (int)(caster.getStat(GameCharacter.WIS) * WISmultiplier) - target.getStat(GameCharacter.MDEF);
		if(statDecrease < 0) statDecrease = 0;
		//update target's and caster's affected stats
		target.setStat(target.getStat(stat) - statDecrease, stat);
		caster.setMP(caster.getMP() - MPcost);
		//play casting sound effect
		try
		{
			soundEffectClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" +
													  	  "audio_files/spell.wav"));
		}
		catch (IOException exception)
		{
			soundEffectClip = null;
		}
		soundEffectClip.play();
		//return appropriate message
		String statName = "";
		if(stat == GameCharacter.ATK) statName = "ATK";
		else if(stat == GameCharacter.ACC) statName = "ACC";
		else if(stat == GameCharacter.DEF) statName = "DEF";
		else if(stat == GameCharacter.EVA) statName = "EVA";
		else if(stat == GameCharacter.WIS) statName = "WIS";
		else if(stat == GameCharacter.MDEF) statName = "MDEF";
		else if(stat == GameCharacter.SPD) statName = "SPD";
		return ("The " + caster.getName() + " casts " + this.name + ". " + target.getName() + "'s " + statName +
				" decreases by " + statDecrease + ".");
	}

	/*
	METHOD: getStat
	PURPOSE: Returns the stat affected by this spell.
	*/
	public int getStat()
	{
		return stat;
	}
}