/*
FILE: GameCharacter.java
AUTHOR: Trevor Evans
CREATED: 12-19-05
MODIFIED: 4-24-06
*/

import java.io.*;
import javax.imageio.*;
import java.awt.*;

/*
CLASS: GameCharacter
PURPOSE: Creates a new game character. There are two types of game characters: heroes and
monsters. Heroes are controlled directly by the player, while monsters are the player's
adversaries controlled by the system.
*/
public class GameCharacter implements Serializable
{
	String name; //the name of the character
	int LVL; //Level: the higher the level, the more powerful the character
	int EXP; //Experience Points: earned after each battle; a character will level up after
			 //earning a certain number of these
	int gold; //earned after each battle; used to purchase items
	int HP; //Hit (Health) points: the character's life force; if this drops to zero, the
			//character is slain
	int MP; //Magic (Mana) points: used to cast spells; each spell has an MP cost
	int[] stat; //each characterhas 9 other stats...

	public static final int MAX_HP = 0; //the character's maximum number of HP
	public static final int MAX_MP = 1; //the character's maximum number of MP
	public static final int ATK = 2; //Attack: how much damage the character does with melee attacks
	public static final int ACC = 3; //Accuracy: how accurate the character's melee attacks are
	public static final int DEF = 4; //Defense: how resistant the character is to melee attacks
	public static final int EVA = 5; //Evasion: the character's ability to dodge melee attacks
	public static final int WIS = 6; //Wisdom: how effective the character's spell casting is
	public static final int MDEF = 7; //Magic Defense: how resistant the character is to attack spells
	public static final int SPD = 8; //Speed: determines which character's actions are executed first

	public GameCharacter()
	{
		name = "";
		int LVL = 1;
		int EXP = 0;
		int gold = 0;
		int HP = 0;
		int MP = 0;
		stat = new int[9];

		for(int i = 0; i < 9; i++)
		{
			stat[i] = 0;
		}
	}

	/*
	METHOD: getName
	PURPOSE: Returns this character's name.
	*/
	public String getName()
	{
		return name;
	}

	/*
	METHOD: setName(String)
	PURPOSE: Sets this character's name to the specified string.
	*/
	public void setName(String nameIn)
	{
		name = nameIn;
	}

	/*
	METHOD: getLVL
	PURPOSE: Returns this character's level.
	*/
	public int getLVL()
	{
		return LVL;
	}

	/*
	METHOD: setLVL(int)
	PURPOSE: Sets this character's level to the specified value.
	*/
	public void setLVL(int lvlIn)
	{
		LVL = lvlIn;
	}

	/*
	METHOD: getEXP
	PURPOSE: Returns this character's experience points.
	*/
	public int getEXP()
	{
		return EXP;
	}

	/*
	METHOD: setEXP(int)
	PURPOSE: Sets this character's experience points to the specified value.
	*/
	public void setEXP(int expIn)
	{
		EXP = expIn;
	}

	/*
	METHOD: getHP
	PURPOSE: Returns this character's current hit (health) points
	*/
	public int getHP()
	{
		return HP;
	}

	/*
	METHOD: setHP(int)
	PURPOSE: Sets this character's current hit (health) points to the specified value.
	*/
	public void setHP(int hpIn)
	{
		HP = hpIn;
		if(HP < 0) HP = 0; //HP cannot be less than zero
		if(HP > stat[MAX_HP]) HP = stat[MAX_HP]; //HP cannot be greater than max HP
	}

	/*
	METHOD: getMP
	PURPOSE: Returns this character's current magic (mana) points
	*/
	public int getMP()
	{
		return MP;
	}

	/*
	METHOD: setMP(int)
	PURPOSE: Sets this character's current magic (mana) points to the specified value.
	*/
	public void setMP(int mpIn)
	{
		MP = mpIn;
		if(MP < 0) MP = 0; //MP cannot be less than zero
		if(MP > stat[MAX_MP]) MP = stat[MAX_MP]; //MP cannot be greater than max MP
	}

	/*
	METHOD: getStat(int)
	PURPOSE: Returns this character's specified stat.
	*/
	public int getStat(int statIn)
	{
		return stat[statIn];
	}

	/*
	METHOD: setStat(int, int)
	PURPOSE: Sets this character's specified stat to the specified value.
	*/
	public void setStat(int value, int statIn)
	{
		stat[statIn] = value;

		if(statIn == MAX_HP)
		{	//HP cannot be greater than max HP
			if(HP > stat[statIn]) HP = stat[statIn];
		}
		else if(statIn == MAX_MP)
		{	//MP cannot be greater than max MP
			if(MP > stat[statIn]) MP = stat[statIn];
		}
	}

	/*
	METHOD: getGold
	PURPOSE: Returns this character's gold count.
	*/
	public int getGold()
	{
		return gold;
	}

	/*
	METHOD: setGold(int)
	PURPOSE: Sets this character's gold count to the specified value.
	*/
	public void setGold(int goldIn)
	{
		gold = goldIn;
	}
}