/*
FILE: HealingItem.java
AUTHOR: Trevor Evans
CREATED: 3-9-06
MODIFIED: 4-24-06
*/

import java.io.*;

/*
CLASS: HealingItem
PURPOSE: Creates an item of type HEALING. These items recover the user's HP and/or MP.
*/
public class HealingItem extends Item implements Serializable
{
	private int HPrestored; //the amount of HP restored when this item is used
	private int MPrestored; //the amount of MP restored when this item is used

	public HealingItem(String nameIn, int valueIn, int HPrestoredIn, int MPrestoredIn)
	{
		super(nameIn, valueIn);
		type = HEALING;
		HPrestored = HPrestoredIn;
		MPrestored = MPrestoredIn;
	}

	/*
	METHOD: use(GameCharacter)
	PURPOSE: Uses this item on the specified target. Returns the appropriate message to
	be displayed in the battle log.
	*/
	public String use(GameCharacter target)
	{
		int actualHPrestored = HPrestored;
		int actualMPrestored = HPrestored;
		//if the item restores more HP than the target has lost...
		if((target.getStat(GameCharacter.MAX_HP) - target.getHP()) < HPrestored)
		{	//...calculate the actual HP restored
			actualHPrestored = target.getStat(GameCharacter.MAX_HP) - target.getHP();
		}
		//if the item restores more MP than the target has lost...
		if((target.getStat(GameCharacter.MAX_MP) - target.getMP()) < MPrestored)
		{	//...calculate the actual MP restored
			actualMPrestored = target.getStat(GameCharacter.MAX_MP) - target.getMP();
		}
		//update target's HP and MP
		target.setHP(target.getHP() + HPrestored);
		target.setMP(target.getMP() + MPrestored);
		//return the appropriate message
		if(HPrestored != 0 && MPrestored != 0)
		{
			return (target.getName() + " uses " + this.name + ". He recovers " + actualHPrestored + " HP and "
					+ actualMPrestored + " MP.");
		}
		else if(HPrestored != 0)
		{
			return (target.getName() + " uses " + this.name + ". He recovers " + actualHPrestored + " HP.");
		}
		else if(MPrestored != 0)
		{
			return (target.getName() + " uses " + this.name + ". He recovers " + actualMPrestored + " MP.");
		}
		else
		{
			return null;
		}
	}
}