/*
FILE: Map.java
AUTHOR: Trevor Evans
CREATED: 12-18-06
MODIFIED: 4-24-06
*/

/*
CLASS: Map
PURPOSE: Creates a new map, which is then displayed in the map panel. The game world is
made up of these maps, which the player navigates using the arrow keys.
*/
import javax.imageio.*;
import java.awt.*;
import java.io.*;

public class Map
{
	Tile[][] tile; //the map is comprised of 32 X 32 pixel tiles
	Image image; //the pre-made image associated with this map
	int width; //the width of this map, in tiles
	int height; //the height of this map, in tiles
	int heroColumn; //the current column position of the hero
	int heroRow; //the current row position of the hero

	public Map()
	{

	}

	/*
	METHOD: getImage
	PURPOSE: Returns the pre-made image associated with this map.
	*/
	public Image getImage()
	{
		return image;
	}

	/*
	METHOD: getTile(int, int)
	PURPOSE: Returns the tile at the specified column-row position.
	*/
	public Tile getTile(int column, int row)
	{
		return tile[column][row];
	}

	/*
	METHOD: getWidth
	PURPOSE: Returns the width, in tiles, of this map.
	*/
	public int getWidth()
	{
		return width;
	}

	/*
	METHOD: getHeight
	PURPOSE: Returns the height, in tiles, of this map.
	*/
	public int getHeight()
	{
		return height;
	}

	/*
	METHOD: getHeroColumn
	PURPOSE: Returns the hero's current column position.
	*/
	public int getHeroColumn()
	{
		return heroColumn;
	}

	/*
	METHOD: getHeroRow
	PURPOSE: Returns the hero's current row position.
	*/
	public int getHeroRow()
	{
		return heroRow;
	}

	/*
	METHOD: moveHeroRight
	PURPOSE: Moves the hero's map position one tile to the right.
	*/
	public void moveHeroRight()
	{
		heroColumn++;
	}

	/*
	METHOD: moveHeroLeft
	PURPOSE: Moves the hero's map position one tile to the left.
	*/
	public void moveHeroLeft()
	{
		heroColumn--;
	}

	/*
	METHOD: moveHeroDown
	PURPOSE: Moves the hero's map position down one tile.
	*/
	public void moveHeroDown()
	{
		heroRow++;
	}

	/*
	METHOD: moveHeroUp
	PURPOSE: Moves the hero's map position up one tile.
	*/
	public void moveHeroUp()
	{
		heroRow--;
	}

	/*
	METHOD: drawMap(Graphics, int, int, int, int)
	PURPOSE: Draws the map.
	PARAMETERS:
		Graphics g -> The graphics object being drawn to
		int upperLeftX -> x-coordinate of top-left corner of the displayed portion of map
		int upperLeftY -> y-coordinate of top-left corner of the displayed portion of map
		int lowerRightX -> x-coordinate of lower-right corner of the displayed portion of map
		int lowerRightY -> y-coordinate of lower-right corner of the displayed portion of map
	*/
	public void drawMap(Graphics g, int upperLeftX, int upperLeftY, int lowerRightX, int lowerRightY)
	{
		g.drawImage(image, 0, 0, 320, 288, upperLeftX, upperLeftY, lowerRightX, lowerRightY, null);
	}
}