/*
FILE: MazeTile.java
AUTHOR: Trevor Evans
CREATED: 2-22-06
MODIFIED: 4-24-06
*/

/*
CLASS: MazeTile
PURPOSE: Creates a new maze tile. These tiles are used to construct the randomly generated
mazes for the dungeon maps and thus possess more properties than normal tiles.
*/
public class MazeTile extends Tile
{
	private boolean inWallList; //determines if tile is in the wall list used to construct a maze
	private boolean visited; //determines if tile has been visited in the maze construction algorithm
	private boolean entrance; //determines if this tile is where the maze entrance is located
	private boolean exit; //determines if this tile is where the maze exit is located
	private boolean treasureChest; //determines if this tile contains a treasure chest
	private int column; //used to find a tile's position after it has been pulled from an ArrayList
	private int row; //used to find a tile's position after it has been pulled from an ArrayList

	public MazeTile(int columnIn, int rowIn)
	{
		super();

		inWallList = false;
		visited = false;
		entrance = false;
		exit = false;
		treasureChest = false;
		column = columnIn;
		row = rowIn;
	}

	/*
	METHOD: setInWallList (boolean)
	PURPOSE: Sets inWallList to the specified boolean value.
	*/
	public void setInWallList(boolean input)
	{
		inWallList = input;
	}

	/*
	METHOD: isInWallList
	PURPOSE: Returns the boolean value of inWallList.
	*/
	public boolean isInWallList()
	{
		return inWallList;
	}

	/*
	METHOD: setVisited (boolean)
	PURPOSE: Sets visited to the specified boolean value.
	*/
	public void setVisited(boolean input)
	{
		visited = input;
	}

	/*
	METHOD: hasBeenVisited
	PURPOSE: Returns the boolean value of visited.
	*/
	public boolean hasBeenVisited()
	{
		return visited;
	}

	/*
	METHOD: setEntrance(boolean)
	PURPOSE: Sets entrance to the specified boolean value.
	*/
	public void setEntrance(boolean input)
	{
		entrance = input;
	}

	/*
	METHOD: isEntrance
	PURPOSE: Returns the boolean value of entrance.
	*/
	public boolean isEntrance()
	{
		return entrance;
	}

	/*
	METHOD: setExit(boolean)
	PURPOSE: Sets exit to the specified boolean value.
	*/
	public void setExit(boolean input)
	{
		exit = input;
	}

	/*
	METHOD: isExit
	PURPOSE: Returns the boolean value of exit.
	*/
	public boolean isExit()
	{
		return exit;
	}

	/*
	METHOD: setTreasureChest(boolean)
	PURPOSE: Sets treasureChest to the specified boolean value.
	*/
	public void setTreasureChest(boolean input)
	{
		treasureChest = input;
	}

	/*
	METHOD: isTreasureChest
	PURPOSE: Returns the boolean value of treasureChest.
	*/
	public boolean isTreasureChest()
	{
		return treasureChest;
	}

	/*
	METHOD: getColumn
	PURPOSE: Returns the column position of this tile.
	*/
	public int getColumn()
	{
		return column;
	}

	/*
	METHOD: getRow
	PURPOSE: Returns the row position of this tile.
	*/
	public int getRow()
	{
		return row;
	}
}