/*
FILE: MonsterLookUpTable.java
AUTHOR: Trevor Evans
CREATED: 4-4-06
MODIFIED: 4-24-06
*/

import java.io.*;
import java.util.*;

/*
CLASS: MonsterLookUpTable
PURPOSE: A look-up table containing all monsters. Implemented using a hash table to ensure no
duplication and quick accessibility. All monsters are created here and added to the hash table,
using their names as keys.
*/
public class MonsterLookUpTable
{
	private Hashtable monsterTable; //stores all items using their names as keys

	public MonsterLookUpTable()
	{
		monsterTable = new Hashtable();

		Monster goop = new Monster("goop", "goop.gif", 1);
		goop.setStat(3, GameCharacter.MAX_HP); goop.setHP(goop.getStat(GameCharacter.MAX_HP));
		goop.setStat(0, GameCharacter.MAX_MP); goop.setMP(goop.getStat(GameCharacter.MAX_MP));
		goop.setStat(5, GameCharacter.ATK);
		goop.setStat(1, GameCharacter.ACC);
		goop.setStat(1, GameCharacter.DEF);
		goop.setStat(1, GameCharacter.EVA);
		goop.setStat(0, GameCharacter.WIS);
		goop.setStat(1, GameCharacter.MDEF);
		goop.setStat(1, GameCharacter.SPD);
		goop.setSpell("melee attack", 0);
		goop.setSpell("melee attack", 1);
		goop.setSpell("melee attack", 2);
		goop.setSpell("melee attack", 3);
		goop.setSpell("melee attack", 4);
		goop.setEXP(1);
		goop.setGold(2);
		monsterTable.put(goop.getName(), goop);

		Monster redGoop = new Monster("red goop", "red_goop.gif", 2);
		redGoop.setStat(4, GameCharacter.MAX_HP); redGoop.setHP(redGoop.getStat(GameCharacter.MAX_HP));
		redGoop.setStat(0, GameCharacter.MAX_MP); redGoop.setMP(redGoop.getStat(GameCharacter.MAX_MP));
		redGoop.setStat(7, GameCharacter.ATK);
		redGoop.setStat(2, GameCharacter.ACC);
		redGoop.setStat(1, GameCharacter.DEF);
		redGoop.setStat(2, GameCharacter.EVA);
		redGoop.setStat(0, GameCharacter.WIS);
		redGoop.setStat(2, GameCharacter.MDEF);
		redGoop.setStat(2, GameCharacter.SPD);
		redGoop.setSpell("melee attack", 0);
		redGoop.setSpell("melee attack", 1);
		redGoop.setSpell("melee attack", 2);
		redGoop.setSpell("melee attack", 3);
		redGoop.setSpell("melee attack", 4);
		redGoop.setEXP(1);
		redGoop.setGold(3);
		monsterTable.put(redGoop.getName(), redGoop);

		Monster bat = new Monster("bat", "bat.gif", 3);
		bat.setStat(6, GameCharacter.MAX_HP); bat.setHP(bat.getStat(GameCharacter.MAX_HP));
		bat.setStat(0, GameCharacter.MAX_MP); bat.setMP(bat.getStat(GameCharacter.MAX_MP));
		bat.setStat(9, GameCharacter.ATK);
		bat.setStat(3, GameCharacter.ACC);
		bat.setStat(3, GameCharacter.DEF);
		bat.setStat(3, GameCharacter.EVA);
		bat.setStat(0, GameCharacter.WIS);
		bat.setStat(3, GameCharacter.MDEF);
		bat.setStat(3, GameCharacter.SPD);
		bat.setSpell("melee attack", 0);
		bat.setSpell("melee attack", 1);
		bat.setSpell("melee attack", 2);
		bat.setSpell("melee attack", 3);
		bat.setSpell("melee attack", 4);
		bat.setEXP(2);
		bat.setGold(3);
		monsterTable.put(bat.getName(), bat);

		Monster spook = new Monster("spook", "spook.gif", 4);
		spook.setStat(7, GameCharacter.MAX_HP); spook.setHP(spook.getStat(GameCharacter.MAX_HP));
		spook.setStat(10, GameCharacter.MAX_MP); spook.setMP(spook.getStat(GameCharacter.MAX_MP));
		spook.setStat(11, GameCharacter.ATK);
		spook.setStat(11, GameCharacter.ACC);
		spook.setStat(4, GameCharacter.DEF);
		spook.setStat(4, GameCharacter.EVA);
		spook.setStat(12, GameCharacter.WIS);
		spook.setStat(4, GameCharacter.MDEF);
		spook.setStat(4, GameCharacter.SPD);
		spook.setSpell("melee attack", 0);
		spook.setSpell("minor blast", 1);
		spook.setSpell("minor blast", 2);
		spook.setSpell("minor agility", 3);
		spook.setSpell("minor blind", 4);
		spook.setEXP(3);
		spook.setGold(5);
		monsterTable.put(spook.getName(), spook);

		Monster abra = new Monster("abra", "abra.gif", 6);
		abra.setStat(13, GameCharacter.MAX_HP); abra.setHP(abra.getStat(GameCharacter.MAX_HP));
		abra.setStat(60, GameCharacter.MAX_MP); abra.setMP(abra.getStat(GameCharacter.MAX_MP));
		abra.setStat(11, GameCharacter.ATK);
		abra.setStat(6, GameCharacter.ACC);
		abra.setStat(6, GameCharacter.DEF);
		abra.setStat(6, GameCharacter.EVA);
		abra.setStat(30, GameCharacter.WIS);
		abra.setStat(12, GameCharacter.MDEF);
		abra.setStat(0, GameCharacter.SPD);
		abra.setSpell("minor blast", 0);
		abra.setSpell("melee attack", 1);
		abra.setSpell("minor exposure", 2);
		abra.setSpell("minor weakness", 3);
		abra.setSpell("minor heal", 4);
		abra.setEXP(4);
		abra.setGold(12);
		monsterTable.put(abra.getName(), abra);

		Monster redBat = new Monster("red bat", "red_bat.gif", 7);
		redBat.setStat(15, GameCharacter.MAX_HP); redBat.setHP(redBat.getStat(GameCharacter.MAX_HP));
		redBat.setStat(70, GameCharacter.MAX_MP); redBat.setMP(redBat.getStat(GameCharacter.MAX_MP));
		redBat.setStat(14, GameCharacter.ATK);
		redBat.setStat(7, GameCharacter.ACC);
		redBat.setStat(7, GameCharacter.DEF);
		redBat.setStat(7, GameCharacter.EVA);
		redBat.setStat(35, GameCharacter.WIS);
		redBat.setStat(14, GameCharacter.MDEF);
		redBat.setStat(0, GameCharacter.SPD);
		redBat.setSpell("minor blast", 0);
		redBat.setSpell("melee attack", 1);
		redBat.setSpell("melee attack", 2);
		redBat.setSpell("minor accelerate", 3);
		redBat.setSpell("minor agility", 4);
		redBat.setEXP(5);
		redBat.setGold(12);
		monsterTable.put(redBat.getName(), redBat);

		Monster sting = new Monster("sting", "sting.gif", 8);
		sting.setStat(20, GameCharacter.MAX_HP); sting.setHP(sting.getStat(GameCharacter.MAX_HP));
		sting.setStat(5, GameCharacter.MAX_MP); sting.setMP(sting.getStat(GameCharacter.MAX_MP));
		sting.setStat(36, GameCharacter.ATK);
		sting.setStat(8, GameCharacter.ACC);
		sting.setStat(8, GameCharacter.DEF);
		sting.setStat(8, GameCharacter.EVA);
		sting.setStat(8, GameCharacter.WIS);
		sting.setStat(8, GameCharacter.MDEF);
		sting.setStat(8, GameCharacter.SPD);
		sting.setSpell("melee attack", 0);
		sting.setSpell("melee attack", 1);
		sting.setSpell("minor shield", 2);
		sting.setSpell("minor strength", 3);
		sting.setSpell("minor strength", 4);
		sting.setEXP(6);
		sting.setGold(16);
		monsterTable.put(sting.getName(), sting);

		Monster beholder = new Monster("beholder", "beholder.gif", 9);
		beholder.setStat(22, GameCharacter.MAX_HP); beholder.setHP(beholder.getStat(GameCharacter.MAX_HP));
		beholder.setStat(5, GameCharacter.MAX_MP); beholder.setMP(beholder.getStat(GameCharacter.MAX_MP));
		beholder.setStat(40, GameCharacter.ATK);
		beholder.setStat(9, GameCharacter.ACC);
		beholder.setStat(9, GameCharacter.DEF);
		beholder.setStat(9, GameCharacter.EVA);
		beholder.setStat(9, GameCharacter.WIS);
		beholder.setStat(9, GameCharacter.MDEF);
		beholder.setStat(9, GameCharacter.SPD);
		beholder.setSpell("melee attack", 0);
		beholder.setSpell("melee attack", 1);
		beholder.setSpell("minor agility", 2);
		beholder.setSpell("minor opening", 3);
		beholder.setSpell("minor accelerate", 4);
		beholder.setEXP(7);
		beholder.setGold(16);
		monsterTable.put(beholder.getName(), beholder);

		Monster spookier = new Monster("spookier", "spookier.gif", 11);
		spookier.setStat(23, GameCharacter.MAX_HP); spookier.setHP(spookier.getStat(GameCharacter.MAX_HP));
		spookier.setStat(20, GameCharacter.MAX_MP); spookier.setMP(spookier.getStat(GameCharacter.MAX_MP));
		spookier.setStat(36, GameCharacter.ATK);
		spookier.setStat(11, GameCharacter.ACC);
		spookier.setStat(10, GameCharacter.DEF);
		spookier.setStat(11, GameCharacter.EVA);
		spookier.setStat(33, GameCharacter.WIS);
		spookier.setStat(22, GameCharacter.MDEF);
		spookier.setStat(0, GameCharacter.SPD);
		spookier.setSpell("melee attack", 0);
		spookier.setSpell("minor blast", 1);
		spookier.setSpell("minor blast", 2);
		spookier.setSpell("minor agility", 3);
		spookier.setSpell("minor blind", 4);
		spookier.setEXP(8);
		spookier.setGold(18);
		monsterTable.put(spookier.getName(), spookier);

		Monster giantSnail = new Monster("giant snail", "giant_snail.gif", 12);
		giantSnail.setStat(25, GameCharacter.MAX_HP); giantSnail.setHP(giantSnail.getStat(GameCharacter.MAX_HP));
		giantSnail.setStat(5, GameCharacter.MAX_MP); giantSnail.setMP(giantSnail.getStat(GameCharacter.MAX_MP));
		giantSnail.setStat(48, GameCharacter.ATK);
		giantSnail.setStat(12, GameCharacter.ACC);
		giantSnail.setStat(12, GameCharacter.DEF);
		giantSnail.setStat(12, GameCharacter.EVA);
		giantSnail.setStat(12, GameCharacter.WIS);
		giantSnail.setStat(12, GameCharacter.MDEF);
		giantSnail.setStat(0, GameCharacter.SPD);
		giantSnail.setSpell("melee attack", 0);
		giantSnail.setSpell("melee attack", 1);
		giantSnail.setSpell("minor shield", 2);
		giantSnail.setSpell("minor brakes", 3);
		giantSnail.setSpell("minor brakes", 4);
		giantSnail.setEXP(10);
		giantSnail.setGold(24);
		monsterTable.put(giantSnail.getName(), giantSnail);

		Monster goldBat = new Monster("gold bat", "gold_bat.gif", 13);
		goldBat.setStat(20, GameCharacter.MAX_HP); goldBat.setHP(goldBat.getStat(GameCharacter.MAX_HP));
		goldBat.setStat(25, GameCharacter.MAX_MP); goldBat.setMP(goldBat.getStat(GameCharacter.MAX_MP));
		goldBat.setStat(44, GameCharacter.ATK);
		goldBat.setStat(13, GameCharacter.ACC);
		goldBat.setStat(13, GameCharacter.DEF);
		goldBat.setStat(13, GameCharacter.EVA);
		goldBat.setStat(39, GameCharacter.WIS);
		goldBat.setStat(26, GameCharacter.MDEF);
		goldBat.setStat(32, GameCharacter.SPD);
		goldBat.setSpell("melee attack", 0);
		goldBat.setSpell("melee attack", 1);
		goldBat.setSpell("minor blast", 2);
		goldBat.setSpell("minor accelerate", 3);
		goldBat.setSpell("minor agility", 4);
		goldBat.setEXP(11);
		goldBat.setGold(20);
		monsterTable.put(goldBat.getName(), goldBat);

		Monster bones = new Monster("bones", "bones.gif", 14);
		bones.setStat(30, GameCharacter.MAX_HP); bones.setHP(bones.getStat(GameCharacter.MAX_HP));
		bones.setStat(5, GameCharacter.MAX_MP); bones.setMP(bones.getStat(GameCharacter.MAX_MP));
		bones.setStat(56, GameCharacter.ATK);
		bones.setStat(14, GameCharacter.ACC);
		bones.setStat(11, GameCharacter.DEF);
		bones.setStat(14, GameCharacter.EVA);
		bones.setStat(14, GameCharacter.WIS);
		bones.setStat(14, GameCharacter.MDEF);
		bones.setStat(15, GameCharacter.SPD);
		bones.setSpell("melee attack", 0);
		bones.setSpell("melee attack", 1);
		bones.setSpell("minor strength", 2);
		bones.setSpell("minor sight", 3);
		bones.setSpell("minor sight", 4);
		bones.setEXP(11);
		bones.setGold(30);
		monsterTable.put(bones.getName(), bones);

		Monster cadabra = new Monster("cadabra", "cadabra.gif", 16);
		cadabra.setStat(30, GameCharacter.MAX_HP); cadabra.setHP(cadabra.getStat(GameCharacter.MAX_HP));
		cadabra.setStat(160, GameCharacter.MAX_MP); cadabra.setMP(cadabra.getStat(GameCharacter.MAX_MP));
		cadabra.setStat(56, GameCharacter.ATK);
		cadabra.setStat(16, GameCharacter.ACC);
		cadabra.setStat(11, GameCharacter.DEF);
		cadabra.setStat(16, GameCharacter.EVA);
		cadabra.setStat(48, GameCharacter.WIS);
		cadabra.setStat(64, GameCharacter.MDEF);
		cadabra.setStat(49, GameCharacter.SPD);
		cadabra.setSpell("mid blast", 0);
		cadabra.setSpell("melee attack", 1);
		cadabra.setSpell("mid exposure", 2);
		cadabra.setSpell("mid weakness", 3);
		cadabra.setSpell("mid heal", 4);
		cadabra.setEXP(13);
		cadabra.setGold(35);
		monsterTable.put(cadabra.getName(), cadabra);

		Monster metalSting = new Monster("metal sting", "metal_sting.gif", 17);
		metalSting.setStat(22, GameCharacter.MAX_HP); metalSting.setHP(metalSting.getStat(GameCharacter.MAX_HP));
		metalSting.setStat(5, GameCharacter.MAX_MP); metalSting.setMP(metalSting.getStat(GameCharacter.MAX_MP));
		metalSting.setStat(72, GameCharacter.ATK);
		metalSting.setStat(17, GameCharacter.ACC);
		metalSting.setStat(21, GameCharacter.DEF);
		metalSting.setStat(17, GameCharacter.EVA);
		metalSting.setStat(17, GameCharacter.WIS);
		metalSting.setStat(34, GameCharacter.MDEF);
		metalSting.setStat(15, GameCharacter.SPD);
		metalSting.setSpell("melee attack", 0);
		metalSting.setSpell("melee attack", 1);
		metalSting.setSpell("minor shield", 2);
		metalSting.setSpell("minor strength", 3);
		metalSting.setSpell("minor strength", 4);
		metalSting.setEXP(14);
		metalSting.setGold(40);
		monsterTable.put(metalSting.getName(), metalSting);

		Monster wereMan = new Monster("were man", "were_man.gif", 18);
		wereMan.setStat(34, GameCharacter.MAX_HP); wereMan.setHP(wereMan.getStat(GameCharacter.MAX_HP));
		wereMan.setStat(5, GameCharacter.MAX_MP); wereMan.setMP(wereMan.getStat(GameCharacter.MAX_MP));
		wereMan.setStat(80, GameCharacter.ATK);
		wereMan.setStat(18, GameCharacter.ACC);
		wereMan.setStat(15, GameCharacter.DEF);
		wereMan.setStat(18, GameCharacter.EVA);
		wereMan.setStat(18, GameCharacter.WIS);
		wereMan.setStat(36, GameCharacter.MDEF);
		wereMan.setStat(31, GameCharacter.SPD);
		wereMan.setSpell("melee attack", 0);
		wereMan.setSpell("melee attack", 1);
		wereMan.setSpell("minor strength", 2);
		wereMan.setSpell("minor sight", 3);
		wereMan.setSpell("minor sight", 4);
		wereMan.setEXP(16);
		wereMan.setGold(50);
		monsterTable.put(wereMan.getName(), wereMan);

		Monster numbSkull = new Monster("numb skull", "numb_skull.gif", 19);
		numbSkull.setStat(36, GameCharacter.MAX_HP); numbSkull.setHP(numbSkull.getStat(GameCharacter.MAX_HP));
		numbSkull.setStat(5, GameCharacter.MAX_MP); numbSkull.setMP(numbSkull.getStat(GameCharacter.MAX_MP));
		numbSkull.setStat(88, GameCharacter.ATK);
		numbSkull.setStat(19, GameCharacter.ACC);
		numbSkull.setStat(17, GameCharacter.DEF);
		numbSkull.setStat(19, GameCharacter.EVA);
		numbSkull.setStat(19, GameCharacter.WIS);
		numbSkull.setStat(38, GameCharacter.MDEF);
		numbSkull.setStat(112, GameCharacter.SPD);
		numbSkull.setSpell("melee attack", 0);
		numbSkull.setSpell("melee attack", 1);
		numbSkull.setSpell("minor strength", 2);
		numbSkull.setSpell("minor sight", 3);
		numbSkull.setSpell("minor sight", 4);
		numbSkull.setEXP(17);
		numbSkull.setGold(60);
		monsterTable.put(numbSkull.getName(), numbSkull);

		Monster metalGoop = new Monster("metal goop", "metal_goop.gif", 21);
		metalGoop.setStat(4, GameCharacter.MAX_HP); metalGoop.setHP(metalGoop.getStat(GameCharacter.MAX_HP));
		metalGoop.setStat(40, GameCharacter.MAX_MP); metalGoop.setMP(metalGoop.getStat(GameCharacter.MAX_MP));
		metalGoop.setStat(20, GameCharacter.ATK);
		metalGoop.setStat(80, GameCharacter.ACC);
		metalGoop.setStat(40, GameCharacter.DEF);
		metalGoop.setStat(80, GameCharacter.EVA);
		metalGoop.setStat(21, GameCharacter.WIS);
		metalGoop.setStat(255, GameCharacter.MDEF);
		metalGoop.setStat(255, GameCharacter.SPD);
		metalGoop.setSpell("melee attack", 0);
		metalGoop.setSpell("melee attack", 1);
		metalGoop.setSpell("minor agility", 2);
		metalGoop.setSpell("minor shield", 3);
		metalGoop.setSpell("minor shield", 4);
		metalGoop.setEXP(115);
		metalGoop.setGold(6);
		monsterTable.put(metalGoop.getName(), metalGoop);

		Monster spookiest = new Monster("spookiest", "spookiest.gif", 22);
		spookiest.setStat(72, GameCharacter.MAX_HP); spookiest.setHP(spookiest.getStat(GameCharacter.MAX_HP));
		spookiest.setStat(45, GameCharacter.MAX_MP); spookiest.setMP(spookiest.getStat(GameCharacter.MAX_MP));
		spookiest.setStat(80, GameCharacter.ATK);
		spookiest.setStat(42, GameCharacter.ACC);
		spookiest.setStat(19, GameCharacter.DEF);
		spookiest.setStat(42, GameCharacter.EVA);
		spookiest.setStat(44, GameCharacter.WIS);
		spookiest.setStat(66, GameCharacter.MDEF);
		spookiest.setStat(49, GameCharacter.SPD);
		spookiest.setSpell("melee attack", 0);
		spookiest.setSpell("mid blast", 1);
		spookiest.setSpell("mid blast", 2);
		spookiest.setSpell("mid agility", 3);
		spookiest.setSpell("mid blind", 4);
		spookiest.setEXP(18);
		spookiest.setGold(70);
		monsterTable.put(spookiest.getName(), spookiest);

		Monster manWere = new Monster("man were", "man_were.gif", 24);
		manWere.setStat(76, GameCharacter.MAX_HP); manWere.setHP(manWere.getStat(GameCharacter.MAX_HP));
		manWere.setStat(5, GameCharacter.MAX_MP); manWere.setMP(manWere.getStat(GameCharacter.MAX_MP));
		manWere.setStat(100, GameCharacter.ATK);
		manWere.setStat(44, GameCharacter.ACC);
		manWere.setStat(18, GameCharacter.DEF);
		manWere.setStat(44, GameCharacter.EVA);
		manWere.setStat(24, GameCharacter.WIS);
		manWere.setStat(48, GameCharacter.MDEF);
		manWere.setStat(71, GameCharacter.SPD);
		manWere.setSpell("melee attack", 0);
		manWere.setSpell("melee attack", 1);
		manWere.setSpell("minor strength", 2);
		manWere.setSpell("minor sight", 3);
		manWere.setSpell("minor sight", 4);
		manWere.setEXP(20);
		manWere.setGold(80);
		monsterTable.put(manWere.getName(), manWere);

		Monster stoneGaze = new Monster("stone gaze", "stone_gaze.gif", 25);
		stoneGaze.setStat(70, GameCharacter.MAX_HP); stoneGaze.setHP(stoneGaze.getStat(GameCharacter.MAX_HP));
		stoneGaze.setStat(5, GameCharacter.MAX_MP); stoneGaze.setMP(stoneGaze.getStat(GameCharacter.MAX_MP));
		stoneGaze.setStat(94, GameCharacter.ATK);
		stoneGaze.setStat(45, GameCharacter.ACC);
		stoneGaze.setStat(20, GameCharacter.DEF);
		stoneGaze.setStat(45, GameCharacter.EVA);
		stoneGaze.setStat(25, GameCharacter.WIS);
		stoneGaze.setStat(50, GameCharacter.MDEF);
		stoneGaze.setStat(240, GameCharacter.SPD);
		stoneGaze.setSpell("melee attack", 0);
		stoneGaze.setSpell("melee attack", 1);
		stoneGaze.setSpell("minor agility", 2);
		stoneGaze.setSpell("minor opening", 3);
		stoneGaze.setSpell("minor accelerate", 4);
		stoneGaze.setEXP(20);
		stoneGaze.setGold(85);
		monsterTable.put(stoneGaze.getName(), stoneGaze);

		Monster escargot = new Monster("escargot", "escargot.gif", 26);
		escargot.setStat(76, GameCharacter.MAX_HP); escargot.setHP(escargot.getStat(GameCharacter.MAX_HP));
		escargot.setStat(260, GameCharacter.MAX_MP); escargot.setMP(escargot.getStat(GameCharacter.MAX_MP));
		escargot.setStat(104, GameCharacter.ATK);
		escargot.setStat(46, GameCharacter.ACC);
		escargot.setStat(25, GameCharacter.DEF);
		escargot.setStat(46, GameCharacter.EVA);
		escargot.setStat(78, GameCharacter.WIS);
		escargot.setStat(104, GameCharacter.MDEF);
		escargot.setStat(38, GameCharacter.SPD);
		escargot.setSpell("mid blast", 0);
		escargot.setSpell("melee attack", 1);
		escargot.setSpell("mid shield", 2);
		escargot.setSpell("mid brakes", 3);
		escargot.setSpell("mid brakes", 4);
		escargot.setEXP(22);
		escargot.setGold(90);
		monsterTable.put(escargot.getName(), escargot);

		Monster buzzard = new Monster("buzzard", "buzzard.gif", 27);
		buzzard.setStat(84, GameCharacter.MAX_HP); buzzard.setHP(buzzard.getStat(GameCharacter.MAX_HP));
		buzzard.setStat(5, GameCharacter.MAX_MP); buzzard.setMP(buzzard.getStat(GameCharacter.MAX_MP));
		buzzard.setStat(112, GameCharacter.ATK);
		buzzard.setStat(47, GameCharacter.ACC);
		buzzard.setStat(24, GameCharacter.DEF);
		buzzard.setStat(47, GameCharacter.EVA);
		buzzard.setStat(27, GameCharacter.WIS);
		buzzard.setStat(54, GameCharacter.MDEF);
		buzzard.setStat(79, GameCharacter.SPD);
		buzzard.setSpell("melee attack", 0);
		buzzard.setSpell("melee attack", 1);
		buzzard.setSpell("minor agility", 2);
		buzzard.setSpell("minor sight", 3);
		buzzard.setSpell("minor sight", 4);
		buzzard.setEXP(24);
		buzzard.setGold(100);
		monsterTable.put(buzzard.getName(), buzzard);

		Monster rogueSting = new Monster("rogue sting", "rogue_sting.gif", 29);
		rogueSting.setStat(70, GameCharacter.MAX_HP); rogueSting.setHP(rogueSting.getStat(GameCharacter.MAX_HP));
		rogueSting.setStat(5, GameCharacter.MAX_MP); rogueSting.setMP(rogueSting.getStat(GameCharacter.MAX_MP));
		rogueSting.setStat(120, GameCharacter.ATK);
		rogueSting.setStat(49, GameCharacter.ACC);
		rogueSting.setStat(45, GameCharacter.DEF);
		rogueSting.setStat(49, GameCharacter.EVA);
		rogueSting.setStat(29, GameCharacter.WIS);
		rogueSting.setStat(58, GameCharacter.MDEF);
		rogueSting.setStat(127, GameCharacter.SPD);
		rogueSting.setSpell("melee attack", 0);
		rogueSting.setSpell("melee attack", 1);
		rogueSting.setSpell("minor shield", 2);
		rogueSting.setSpell("minor strength", 3);
		rogueSting.setSpell("minor strength", 4);
		rogueSting.setEXP(26);
		rogueSting.setGold(110);
		monsterTable.put(rogueSting.getName(), rogueSting);

		Monster knuckleHead = new Monster("knuckle head", "knuckle_head.gif", 30);
		knuckleHead.setStat(92, GameCharacter.MAX_HP); knuckleHead.setHP(knuckleHead.getStat(GameCharacter.MAX_HP));
		knuckleHead.setStat(5, GameCharacter.MAX_MP); knuckleHead.setMP(knuckleHead.getStat(GameCharacter.MAX_MP));
		knuckleHead.setStat(136, GameCharacter.ATK);
		knuckleHead.setStat(50, GameCharacter.ACC);
		knuckleHead.setStat(28, GameCharacter.DEF);
		knuckleHead.setStat(50, GameCharacter.EVA);
		knuckleHead.setStat(30, GameCharacter.WIS);
		knuckleHead.setStat(60, GameCharacter.MDEF);
		knuckleHead.setStat(80, GameCharacter.SPD);
		knuckleHead.setSpell("melee attack", 0);
		knuckleHead.setSpell("melee attack", 1);
		knuckleHead.setSpell("minor strength", 2);
		knuckleHead.setSpell("minor sight", 3);
		knuckleHead.setSpell("minor sight", 4);
		knuckleHead.setEXP(28);
		knuckleHead.setGold(120);
		monsterTable.put(knuckleHead.getName(), knuckleHead);

		Monster brickMan = new Monster("brick man", "brick_man.gif", 31);
		brickMan.setStat(140, GameCharacter.MAX_HP); brickMan.setHP(brickMan.getStat(GameCharacter.MAX_HP));
		brickMan.setStat(5, GameCharacter.MAX_MP); brickMan.setMP(brickMan.getStat(GameCharacter.MAX_MP));
		brickMan.setStat(240, GameCharacter.ATK);
		brickMan.setStat(71, GameCharacter.ACC);
		brickMan.setStat(30, GameCharacter.DEF);
		brickMan.setStat(51, GameCharacter.EVA);
		brickMan.setStat(31, GameCharacter.WIS);
		brickMan.setStat(62, GameCharacter.MDEF);
		brickMan.setStat(0, GameCharacter.SPD);
		brickMan.setSpell("melee attack", 0);
		brickMan.setSpell("melee attack", 1);
		brickMan.setSpell("minor strength", 2);
		brickMan.setSpell("minor shield", 3);
		brickMan.setSpell("minor shield", 4);
		brickMan.setEXP(31);
		brickMan.setGold(100);
		monsterTable.put(brickMan.getName(), brickMan);

		Monster goldBrick = new Monster("gold brick", "gold_brick.gif", 32);
		goldBrick.setStat(100, GameCharacter.MAX_HP); goldBrick.setHP(goldBrick.getStat(GameCharacter.MAX_HP));
		goldBrick.setStat(5, GameCharacter.MAX_MP); goldBrick.setMP(goldBrick.getStat(GameCharacter.MAX_MP));
		goldBrick.setStat(96, GameCharacter.ATK);
		goldBrick.setStat(72, GameCharacter.ACC);
		goldBrick.setStat(20, GameCharacter.DEF);
		goldBrick.setStat(52, GameCharacter.EVA);
		goldBrick.setStat(32, GameCharacter.WIS);
		goldBrick.setStat(64, GameCharacter.MDEF);
		goldBrick.setStat(0, GameCharacter.SPD);
		goldBrick.setSpell("melee attack", 0);
		goldBrick.setSpell("melee attack", 1);
		goldBrick.setSpell("minor strength", 2);
		goldBrick.setSpell("minor shield", 3);
		goldBrick.setSpell("minor shield", 4);
		goldBrick.setEXP(6);
		goldBrick.setGold(200);
		monsterTable.put(goldBrick.getName(), goldBrick);

		Monster hollowArmor = new Monster("hollow armor", "hollow_armor.gif", 34);
		hollowArmor.setStat(110, GameCharacter.MAX_HP); hollowArmor.setHP(hollowArmor.getStat(GameCharacter.MAX_HP));
		hollowArmor.setStat(5, GameCharacter.MAX_MP); hollowArmor.setMP(hollowArmor.getStat(GameCharacter.MAX_MP));
		hollowArmor.setStat(152, GameCharacter.ATK);
		hollowArmor.setStat(74, GameCharacter.ACC);
		hollowArmor.setStat(39, GameCharacter.DEF);
		hollowArmor.setStat(54, GameCharacter.EVA);
		hollowArmor.setStat(34, GameCharacter.WIS);
		hollowArmor.setStat(68, GameCharacter.MDEF);
		hollowArmor.setStat(103, GameCharacter.SPD);
		hollowArmor.setSpell("melee attack", 0);
		hollowArmor.setSpell("melee attack", 1);
		hollowArmor.setSpell("minor strength", 2);
		hollowArmor.setSpell("minor shield", 3);
		hollowArmor.setSpell("minor shield", 4);
		hollowArmor.setEXP(33);
		hollowArmor.setGold(130);
		monsterTable.put(hollowArmor.getName(), hollowArmor);

		Monster birdBrain = new Monster("bird brain", "bird_brain.gif", 35);
		birdBrain.setStat(116, GameCharacter.MAX_HP); birdBrain.setHP(birdBrain.getStat(GameCharacter.MAX_HP));
		birdBrain.setStat(350, GameCharacter.MAX_MP); birdBrain.setMP(birdBrain.getStat(GameCharacter.MAX_MP));
		birdBrain.setStat(156, GameCharacter.ATK);
		birdBrain.setStat(75, GameCharacter.ACC);
		birdBrain.setStat(34, GameCharacter.DEF);
		birdBrain.setStat(55, GameCharacter.EVA);
		birdBrain.setStat(105, GameCharacter.WIS);
		birdBrain.setStat(140, GameCharacter.MDEF);
		birdBrain.setStat(32, GameCharacter.SPD);
		birdBrain.setSpell("major blast", 0);
		birdBrain.setSpell("melee attack", 1);
		birdBrain.setSpell("major agility", 2);
		birdBrain.setSpell("major sight", 3);
		birdBrain.setSpell("major sight", 4);
		birdBrain.setEXP(34);
		birdBrain.setGold(140);
		monsterTable.put(birdBrain.getName(), birdBrain);

		Monster death = new Monster("death", "death.gif", 36);
		death.setStat(100, GameCharacter.MAX_HP); death.setHP(death.getStat(GameCharacter.MAX_HP));
		death.setStat(5, GameCharacter.MAX_MP); death.setMP(death.getStat(GameCharacter.MAX_MP));
		death.setStat(158, GameCharacter.ATK);
		death.setStat(76, GameCharacter.ACC);
		death.setStat(32, GameCharacter.DEF);
		death.setStat(56, GameCharacter.EVA);
		death.setStat(36, GameCharacter.WIS);
		death.setStat(108, GameCharacter.MDEF);
		death.setStat(255, GameCharacter.SPD);
		death.setSpell("melee attack", 0);
		death.setSpell("melee attack", 1);
		death.setSpell("minor strength", 2);
		death.setSpell("minor sight", 3);
		death.setSpell("minor sight", 4);
		death.setEXP(37);
		death.setGold(150);
		monsterTable.put(death.getName(), death);

		Monster wolfMan = new Monster("wolf man", "wolf_man.gif", 37);
		wolfMan.setStat(120, GameCharacter.MAX_HP); wolfMan.setHP(wolfMan.getStat(GameCharacter.MAX_HP));
		wolfMan.setStat(5, GameCharacter.MAX_MP); wolfMan.setMP(wolfMan.getStat(GameCharacter.MAX_MP));
		wolfMan.setStat(172, GameCharacter.ATK);
		wolfMan.setStat(77, GameCharacter.ACC);
		wolfMan.setStat(35, GameCharacter.DEF);
		wolfMan.setStat(57, GameCharacter.EVA);
		wolfMan.setStat(37, GameCharacter.WIS);
		wolfMan.setStat(111, GameCharacter.MDEF);
		wolfMan.setStat(74, GameCharacter.SPD);
		wolfMan.setSpell("melee attack", 0);
		wolfMan.setSpell("melee attack", 1);
		wolfMan.setSpell("minor strength", 2);
		wolfMan.setSpell("minor sight", 3);
		wolfMan.setSpell("minor sight", 4);
		wolfMan.setEXP(40);
		wolfMan.setGold(155);
		monsterTable.put(wolfMan.getName(), wolfMan);

		Monster earthDragon = new Monster("earth dragon", "earth_dragon.gif", 39);
		earthDragon.setStat(130, GameCharacter.MAX_HP); earthDragon.setHP(earthDragon.getStat(GameCharacter.MAX_HP));
		earthDragon.setStat(75, GameCharacter.MAX_MP); earthDragon.setMP(earthDragon.getStat(GameCharacter.MAX_MP));
		earthDragon.setStat(176, GameCharacter.ATK);
		earthDragon.setStat(79, GameCharacter.ACC);
		earthDragon.setStat(37, GameCharacter.DEF);
		earthDragon.setStat(58, GameCharacter.EVA);
		earthDragon.setStat(78, GameCharacter.WIS);
		earthDragon.setStat(156, GameCharacter.MDEF);
		earthDragon.setStat(79, GameCharacter.SPD);
		earthDragon.setSpell("melee attack", 0);
		earthDragon.setSpell("major blast", 1);
		earthDragon.setSpell("major blast", 2);
		earthDragon.setSpell("major sight", 3);
		earthDragon.setSpell("major strength", 4);
		earthDragon.setEXP(45);
		earthDragon.setGold(160);
		monsterTable.put(earthDragon.getName(), earthDragon);

		Monster baldEagle = new Monster("bald eagle", "bald_eagle.gif", 40);
		baldEagle.setStat(130, GameCharacter.MAX_HP); baldEagle.setHP(baldEagle.getStat(GameCharacter.MAX_HP));
		baldEagle.setStat(75, GameCharacter.MAX_MP); baldEagle.setMP(baldEagle.getStat(GameCharacter.MAX_MP));
		baldEagle.setStat(172, GameCharacter.ATK);
		baldEagle.setStat(80, GameCharacter.ACC);
		baldEagle.setStat(40, GameCharacter.DEF);
		baldEagle.setStat(60, GameCharacter.EVA);
		baldEagle.setStat(80, GameCharacter.WIS);
		baldEagle.setStat(160, GameCharacter.MDEF);
		baldEagle.setStat(80, GameCharacter.SPD);
		baldEagle.setSpell("melee attack", 0);
		baldEagle.setSpell("major blast", 1);
		baldEagle.setSpell("major blast", 2);
		baldEagle.setSpell("major sight", 3);
		baldEagle.setSpell("major agility", 4);
		baldEagle.setEXP(43);
		baldEagle.setGold(160);
		monsterTable.put(baldEagle.getName(), baldEagle);

		Monster allakazam = new Monster("allakazam", "allakazam.gif", 41);
		allakazam.setStat(130, GameCharacter.MAX_HP); allakazam.setHP(allakazam.getStat(GameCharacter.MAX_HP));
		allakazam.setStat(410, GameCharacter.MAX_MP); allakazam.setMP(allakazam.getStat(GameCharacter.MAX_MP));
		allakazam.setStat(160, GameCharacter.ATK);
		allakazam.setStat(101, GameCharacter.ACC);
		allakazam.setStat(35, GameCharacter.DEF);
		allakazam.setStat(71, GameCharacter.EVA);
		allakazam.setStat(123, GameCharacter.WIS);
		allakazam.setStat(246, GameCharacter.MDEF);
		allakazam.setStat(247, GameCharacter.SPD);
		allakazam.setSpell("major blast", 0);
		allakazam.setSpell("melee attack", 1);
		allakazam.setSpell("major exposure", 2);
		allakazam.setSpell("major weakness", 3);
		allakazam.setSpell("major heal", 4);
		allakazam.setEXP(50);
		allakazam.setGold(165);
		monsterTable.put(allakazam.getName(), allakazam);

		Monster axeMan = new Monster("axe man", "axe_man.gif", 43);
		axeMan.setStat(140, GameCharacter.MAX_HP); axeMan.setHP(axeMan.getStat(GameCharacter.MAX_HP));
		axeMan.setStat(5, GameCharacter.MAX_MP); axeMan.setMP(axeMan.getStat(GameCharacter.MAX_MP));
		axeMan.setStat(188, GameCharacter.ATK);
		axeMan.setStat(103, GameCharacter.ACC);
		axeMan.setStat(41, GameCharacter.DEF);
		axeMan.setStat(73, GameCharacter.EVA);
		axeMan.setStat(43, GameCharacter.WIS);
		axeMan.setStat(172, GameCharacter.MDEF);
		axeMan.setStat(243, GameCharacter.SPD);
		axeMan.setSpell("melee attack", 0);
		axeMan.setSpell("melee attack", 1);
		axeMan.setSpell("minor strength", 2);
		axeMan.setSpell("minor shield", 3);
		axeMan.setSpell("minor shield", 4);
		axeMan.setEXP(54);
		axeMan.setGold(165);
		monsterTable.put(axeMan.getName(), axeMan);

		Monster iceDragon = new Monster("ice dragon", "ice_dragon.gif", 45);
		iceDragon.setStat(140, GameCharacter.MAX_HP); iceDragon.setHP(iceDragon.getStat(GameCharacter.MAX_HP));
		iceDragon.setStat(90, GameCharacter.MAX_MP); iceDragon.setMP(iceDragon.getStat(GameCharacter.MAX_MP));
		iceDragon.setStat(196, GameCharacter.ATK);
		iceDragon.setStat(105, GameCharacter.ACC);
		iceDragon.setStat(42, GameCharacter.DEF);
		iceDragon.setStat(75, GameCharacter.EVA);
		iceDragon.setStat(90, GameCharacter.WIS);
		iceDragon.setStat(225, GameCharacter.MDEF);
		iceDragon.setStat(255, GameCharacter.SPD);
		iceDragon.setSpell("melee attack", 0);
		iceDragon.setSpell("major blast", 1);
		iceDragon.setSpell("major blast", 2);
		iceDragon.setSpell("major sight", 3);
		iceDragon.setSpell("major strength", 4);
		iceDragon.setEXP(60);
		iceDragon.setGold(150);
		monsterTable.put(iceDragon.getName(), iceDragon);

		Monster masonMan = new Monster("mason man", "mason_man.gif", 46);
		masonMan.setStat(320, GameCharacter.MAX_HP); masonMan.setHP(masonMan.getStat(GameCharacter.MAX_HP));
		masonMan.setStat(5, GameCharacter.MAX_MP); masonMan.setMP(masonMan.getStat(GameCharacter.MAX_MP));
		masonMan.setStat(200, GameCharacter.ATK);
		masonMan.setStat(126, GameCharacter.ACC);
		masonMan.setStat(20, GameCharacter.DEF);
		masonMan.setStat(91, GameCharacter.EVA);
		masonMan.setStat(46, GameCharacter.WIS);
		masonMan.setStat(184, GameCharacter.MDEF);
		masonMan.setStat(65, GameCharacter.SPD);
		masonMan.setSpell("melee attack", 0);
		masonMan.setSpell("melee attack", 1);
		masonMan.setSpell("minor strength", 2);
		masonMan.setSpell("minor shield", 3);
		masonMan.setSpell("minor shield", 4);
		masonMan.setEXP(65);
		masonMan.setGold(140);
		monsterTable.put(masonMan.getName(), masonMan);

		Monster executioner = new Monster("executioner", "executioner.gif", 48);
		executioner.setStat(180, GameCharacter.MAX_HP); executioner.setHP(executioner.getStat(GameCharacter.MAX_HP));
		executioner.setStat(5, GameCharacter.MAX_MP); executioner.setMP(executioner.getStat(GameCharacter.MAX_MP));
		executioner.setStat(210, GameCharacter.ATK);
		executioner.setStat(128, GameCharacter.ACC);
		executioner.setStat(43, GameCharacter.DEF);
		executioner.setStat(93, GameCharacter.EVA);
		executioner.setStat(48, GameCharacter.WIS);
		executioner.setStat(192, GameCharacter.MDEF);
		executioner.setStat(70, GameCharacter.SPD);
		executioner.setSpell("melee attack", 0);
		executioner.setSpell("melee attack", 1);
		executioner.setSpell("minor strength", 2);
		executioner.setSpell("minor shield", 3);
		executioner.setSpell("minor shield", 4);
		executioner.setEXP(70);
		executioner.setGold(140);
		monsterTable.put(executioner.getName(), executioner);

		Monster fireDragon = new Monster("fire dragon", "fire_dragon.gif", 50);
		fireDragon.setStat(200, GameCharacter.MAX_HP); fireDragon.setHP(fireDragon.getStat(GameCharacter.MAX_HP));
		fireDragon.setStat(105, GameCharacter.MAX_MP); fireDragon.setMP(fireDragon.getStat(GameCharacter.MAX_MP));
		fireDragon.setStat(240, GameCharacter.ATK);
		fireDragon.setStat(130, GameCharacter.ACC);
		fireDragon.setStat(45, GameCharacter.DEF);
		fireDragon.setStat(95, GameCharacter.EVA);
		fireDragon.setStat(100, GameCharacter.WIS);
		fireDragon.setStat(250, GameCharacter.MDEF);
		fireDragon.setStat(247, GameCharacter.SPD);
		fireDragon.setSpell("melee attack", 0);
		fireDragon.setSpell("major blast", 1);
		fireDragon.setSpell("major blast", 2);
		fireDragon.setSpell("major sight", 3);
		fireDragon.setSpell("major strength", 4);
		fireDragon.setEXP(100);
		fireDragon.setGold(140);
		monsterTable.put(fireDragon.getName(), fireDragon);
	}

	/*
	METHOD: getRandomMonster(int)
	PURPOSE: Takes a random monster from the hash table and returns it. The possibilities of
	monsters returned are based on the dungeon level specified.
	*/
	public Monster getRandomMonster(int dungeonLevel)
	{
		Monster monster = new Monster();
		int random = (int) (Math.random() * 100);

		if(dungeonLevel >= 1 && dungeonLevel <= 5)
		{
			if(random >= 0 && random < 35)
			{
				monster = (Monster) monsterTable.get("goop");
			}
			else if(random >= 35 && random < 60)
			{
				monster = (Monster) monsterTable.get("red goop");
			}
			else if(random >= 60 && random < 85)
			{
				monster = (Monster) monsterTable.get("bat");
			}
			else
			{
				monster = (Monster) monsterTable.get("spook");
			}
		}
		else if(dungeonLevel >= 6 && dungeonLevel <= 10)
		{
			if(random >= 0 && random < 35)
			{
				monster = (Monster) monsterTable.get("red bat");
			}
			else if(random >= 35 && random < 60)
			{
				monster = (Monster) monsterTable.get("abra");
			}
			else if(random >= 60 && random < 85)
			{
				monster = (Monster) monsterTable.get("sting");
			}
			else
			{
				monster = (Monster) monsterTable.get("beholder");
			}
		}
		else if(dungeonLevel >= 11 && dungeonLevel <= 15)
		{
			if(random >= 0 && random < 35)
			{
				monster = (Monster) monsterTable.get("giant snail");
			}
			else if(random >= 35 && random < 60)
			{
				monster = (Monster) monsterTable.get("spookier");
			}
			else if(random >= 60 && random < 85)
			{
				monster = (Monster) monsterTable.get("gold bat");
			}
			else
			{
				monster = (Monster) monsterTable.get("bones");
			}
		}
		else if(dungeonLevel >= 16 && dungeonLevel <= 20)
		{
			if(random >= 0 && random < 35)
			{
				monster = (Monster) monsterTable.get("were man");
			}
			else if(random >= 35 && random < 60)
			{
				monster = (Monster) monsterTable.get("cadabra");
			}
			else if(random >= 60 && random < 85)
			{
				monster = (Monster) monsterTable.get("numb skull");
			}
			else
			{
				monster = (Monster) monsterTable.get("metal sting");
			}
		}
		else if(dungeonLevel >= 21 && dungeonLevel <= 25)
		{
			if(random >= 0 && random < 35)
			{
				monster = (Monster) monsterTable.get("spookiest");
			}
			else if(random >= 35 && random < 60)
			{
				monster = (Monster) monsterTable.get("man were");
			}
			else if(random >= 60 && random < 85)
			{
				monster = (Monster) monsterTable.get("stone gaze");
			}
			else
			{
				monster = (Monster) monsterTable.get("metal goop");
			}
		}
		else if(dungeonLevel >= 26 && dungeonLevel <= 30)
		{
			if(random >= 0 && random < 35)
			{
				monster = (Monster) monsterTable.get("buzzard");
			}
			else if(random >= 35 && random < 60)
			{
				monster = (Monster) monsterTable.get("escargot");
			}
			else if(random >= 60 && random < 85)
			{
				monster = (Monster) monsterTable.get("rogue sting");
			}
			else
			{
				monster = (Monster) monsterTable.get("knuckle head");
			}
		}
		else if(dungeonLevel >= 31 && dungeonLevel <= 35)
		{
			if(random >= 0 && random < 35)
			{
				monster = (Monster) monsterTable.get("hollow armor");
			}
			else if(random >= 35 && random < 60)
			{
				monster = (Monster) monsterTable.get("brick man");
			}
			else if(random >= 60 && random < 85)
			{
				monster = (Monster) monsterTable.get("bird brain");
			}
			else
			{
				monster = (Monster) monsterTable.get("gold brick");
			}
		}
		else if(dungeonLevel >= 36 && dungeonLevel <= 40)
		{
			if(random >= 0 && random < 35)
			{
				monster = (Monster) monsterTable.get("death");
			}
			else if(random >= 35 && random < 60)
			{
				monster = (Monster) monsterTable.get("wolf man");
			}
			else if(random >= 60 && random < 85)
			{
				monster = (Monster) monsterTable.get("bald eagle");
			}
			else
			{
				monster = (Monster) monsterTable.get("earth dragon");
			}
		}
		else if(dungeonLevel >= 41 && dungeonLevel <= 45)
		{
			if(random >= 0 && random < 40)
			{
				monster = (Monster) monsterTable.get("allakazam");
			}
			else if(random >= 40 && random < 80)
			{
				monster = (Monster) monsterTable.get("axe man");
			}
			else
			{
				monster = (Monster) monsterTable.get("ice dragon");
			}
		}
		else if(dungeonLevel >= 46 && dungeonLevel <= 50)
		{
			if(random >= 0 && random < 40)
			{
				monster = (Monster) monsterTable.get("mason man");
			}
			else if(random >= 40 && random < 80)
			{
				monster = (Monster) monsterTable.get("executioner");
			}
			else
			{
				monster = (Monster) monsterTable.get("fire dragon");
			}
		}

		return monster;
	}
}
