/*
FILE: MonsterMelee.java
AUTHOR: Trevor Evans
CREATED: 4-9-06
MODIFIED: 4-24-06
*/

import java.io.*;
import java.applet.*;
import java.net.*;

/*
CLASS: MonsterMelee
PURPOSE: Creates a spell of type MONSTER_MELEE. This is not a true spell, per se. This was
simply the most convenient way to implement a monster's melee attack while still being
able to add it to an array of Spell objects. Unlike a true spell, it has no MP cost and its
strength is ATK based, not WIS based.
*/
public class MonsterMelee extends Spell
{
	public MonsterMelee()
	{
		super("melee attack", 0);
		type = MONSTER_MELEE;
	}

	/*
	METHOD: attack(Monster, Hero)
	PURPOSE: The specified monster attacks the specified hero. Returns the appropriate
	message to be displayed to the battle log.
	*/
	public String attack(Monster monster, Hero hero)
	{
		//The odds of the monster's attack landing successfully are determined by the
		//difference between the monster's ACC and the hero's EVA. The odds are 50-50 if
		//they are equal, 51-49 if the monster's ACC is one higher than the hero's EVA, and
		//so on.
		int random = (int) (Math.random() * 100);
		if(random >= (50 - (monster.getStat(GameCharacter.ACC) - hero.getStat(GameCharacter.EVA))))
		{	//the monster's attack is successful
			//calculate the damage done
			int damageDone = monster.getStat(GameCharacter.ATK) - hero.getStat(GameCharacter.DEF);
			if(damageDone <= 0) damageDone = 1; //melee attacks always do at least 1 HP of damage
			//if attack takes more HP than the hero has left...
			if(hero.getHP() < damageDone) damageDone = hero.getHP();
			hero.setHP(hero.getHP() - damageDone);
			//play hit sound effect
			try
			{
				soundEffectClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" +
														  	  "audio_files/enemy_hit.wav"));
			}
			catch (IOException exception)
			{
				soundEffectClip = null;
			}
			soundEffectClip.play();
			//return appropriate message
			return ("The " + monster.getName() + " hits " + hero.getName() + " for " + damageDone + " HP.");
		}
		else
		{	//the monster's attack is unsuccessful; the hero dodges the attack
			//play dodge sound effect
			try
			{
				soundEffectClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" +
														  	  "audio_files/dodge.wav"));
			}
			catch (IOException exception)
			{
				soundEffectClip = null;
			}
			soundEffectClip.play();
			//return appropriate message
			return ("The " + monster.getName() + " takes a swing at " + hero.getName() + ", but he evades its attack.");
		}
	}
}