/*
FILE: OffensiveSpell.java
AUTHOR: Trevor Evans
CREATED: 3-29-06
MODIFIED: 4-24-06
*/

import java.io.*;
import java.applet.*;
import java.net.*;

/*
CLASS: OffensiveSpell
PURPOSE: Creates a spell of type OFFENSIVE. These spells damage the target's HP when cast.
*/
public class OffensiveSpell extends Spell implements Serializable
{
	private double WISmultiplier; //this multiplied by caster's WIS determines the strength of the spell

	public OffensiveSpell(String nameIn, int costIn, double multiplierIn)
	{
		super(nameIn, costIn);
		type = OFFENSIVE;
		WISmultiplier = multiplierIn;
	}

	/*
	METHOD: cast(Hero, Monster)
	PURPOSE: Casts this spell on the specified target. Returns the appropriate message to
	be displayed in the battle log. Called when the hero is the caster and a monster is the
	target.
	*/
	public String cast(Hero caster, Monster target)
	{	//calculate strength of spell minus the target's resistance to spells
		int damageDone = (int)(caster.getStat(GameCharacter.WIS) * WISmultiplier) - target.getStat(GameCharacter.MDEF);
		if(damageDone < 0) damageDone = 0; //damage done cannot be negative
		//update target's and caster's affected stats
		target.setHP(target.getHP() - damageDone);
		caster.setMP(caster.getMP() - MPcost);
		//play casting sound effect
		try
		{
			soundEffectClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" +
													  	  "audio_files/boom.wav"));
		}
		catch (IOException exception)
		{
			soundEffectClip = null;
		}
		soundEffectClip.play();
		//return appropriate message
		return (caster.getName() + " casts " + name + ". The " + target.getName() + " takes "
				+ damageDone + " HP of damage.");
	}

	/*
	METHOD: cast(Monster, Hero)
	PURPOSE: Casts this spell on the specified target. Returns the appropriate message to
	be displayed in the battle log. Called when a monster is the caster and the hero is the
	target.
	*/
	public String cast(Monster caster, Hero target)
	{	//calculate strength of spell minus the target's resistance to spells
		int damageDone = (int)(caster.getStat(GameCharacter.WIS) * WISmultiplier) - target.getStat(GameCharacter.MDEF);
		if(damageDone < 0) damageDone = 0; //damage done cannot be negative
		//if spell takes more HP than the hero has left....
		if(target.getHP() < damageDone) damageDone = target.getHP();
		//update target's and caster's affected stats
		target.setHP(target.getHP() - damageDone);
		caster.setMP(caster.getMP() - MPcost);
		//play casting sound effect
		try
		{
			soundEffectClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" +
													  	  "audio_files/boom.wav"));
		}
		catch (IOException exception)
		{
			soundEffectClip = null;
		}
		soundEffectClip.play();
		//return appropriate message
		return ("The " + caster.getName() + " casts " + name + ". " + target.getName() + " takes "
				+ damageDone + " HP of damage.");
	}
}