/*
FILE: Spell.java
AUTHOR: Trevor Evans
CREATED: 12-19-05
MODIFIED: 4-24-06
*/

import java.io.*;
import java.applet.*;
import java.net.*;

/*
CLASS: Spell
PURPOSE: Creates a new spell. Each spell requires a set amount of MP to cast. Spells come
in four types: healing spells that recover HP, buffing spells that boost stats, debuffing
spells that lower stats, and offensive spells that deal out damage.
*/
public class Spell implements Serializable
{
	String name; //the name of the spell
	String description; //a short description of the spell
	int MPcost; //the amount of MP required to cast the spell
	int type; //the spell's type; determines how it is used
	AudioClip soundEffectClip; //the sound effect associated with the spell

	public static final int EMPTY = -1; //spell's of this type are place holders
	public static final int HEALING = 0;
	public static final int OFFENSIVE = 1;
	public static final int BUFFING = 2;
	public static final int DEBUFFING = 3;
	public static final int MONSTER_MELEE = 4;

	public Spell(String nameIn, int costIn)
	{
		name = nameIn;
		description = "";
		MPcost = costIn;
		type = EMPTY;
	}

	/*
	METHOD: getName
	PURPOSE: Returns the name of this spell.
	*/
	public String getName()
	{
		return name;
	}

	/*
	METHOD: getDescription
	PURPOSE: Returns the description of this spell.
	*/
	public String getDescription()
	{
		return description;
	}

	/*
	METHOD: setDescription(String)
	PURPOSE; Sets this spell's description to the specified string.
	*/
	public void setDescription(String descriptionIn)
	{
		description = descriptionIn;
	}

	/*
	METHOD: getMPCost
	PURPOSE: Returns the amount of MP required to cast this spell.
	*/
	public int getMPcost()
	{
		return MPcost;
	}

	/*
	METHOD: getType
	PUPOSE: Returns the type of this spell.
	*/
	public int getType()
	{
		return type;
	}
}