/*
FILE: Tile.java
AUTHOR: Trevor Evans
CREATED: 12-18-05
MODIFIED: 4-24-06
*/

/*
CLASS: Tile
PURPOSE: Creates a new tile. Each map is made up of an array of these 32 X 32 pixel tiles.
*/
public class Tile
{
	boolean passable; //determines if this tile is passable or not

	public static final int TILE_SIZE = 32; //the height and width of a tile, in pixels

	public Tile()
	{
		passable = true;
	}

	/*
	METHOD: setPassable (boolean)
	PURPOSE: Sets passable to the specified boolean value.
	*/
	public void setPassable(boolean input)
	{
		passable = input;
	}

	/*
	METHOD: isPassable
	PURPOSE: Returns the boolean value of passable.
	*/
	public boolean isPassable()
	{
		return passable;
	}
}