/*
FILE: WarpScroll.java
AUTHOR: Trevor Evans
CREATED: 4-27-06
MODIFIED: 4-27-06
*/

import java.io.*;
import java.applet.*;
import java.net.*;

/*
CLASS: WarpScroll
PURPOSE: Creates a new item of type WARP_SCROLL. Warp scrolls instantly transport the user
from the dungeon to the town, or from the town to the most recently visited dungeon floor.
*/
public class WarpScroll extends Item implements Serializable
{
	public WarpScroll(int valueIn)
	{
		super("warp scroll", valueIn);
		type = WARP_SCROLL;
	}

	/*
	METHOD: use(Hero, MapPanel)
	PURPOSE: Uses this scroll on the specified hero within the specified map panel. Returns
	the appropriate message to be displayed.
	*/
	public void use(Hero hero, DQFrame frame)
	{	//if currently in dungeon...
		if(frame.getMapPanel().getCurrentMap() == frame.getMapPanel().DUNGEON)
		{	//...warp to world map, just outside of town
			hero.setLastVisitedDungeonLevel(frame.getMapPanel().getDungeonLevel());
			frame.getMapPanel().setUpWorldMap(5, 14);
			frame.getMapPanel().setDungeonLevel(0);
			frame.getMapPanel().setHeroFacing(frame.getMapPanel().FRONT);
		}
		else
		{	//...warp to last dungeon floor where a warp scroll was used
			frame.getMapPanel().setUpDungeonMap(hero.getLastVisitedDungeonLevel());
			frame.getMapPanel().setHeroFacing(frame.getMapPanel().FRONT);
			//play dungeon theme
			frame.getMusicClip().stop();
			AudioClip musicClip;
			try
			{
				musicClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" +
														"audio_files/dungeon.mid"));
			}
			catch (IOException exception)
			{
				musicClip = null;
			}
			frame.setMusicClip(musicClip);
			frame.getMusicClip().loop();
		}
		//play warp sound effect
		frame.getSoundEffectClip().stop();
		try
		{
			soundEffectClip = Applet.newAudioClip(new URL("file:" + System.getProperty("user.dir") + "/" +
													  	  "audio_files/warp.wav"));
		}
		catch (IOException exception)
		{
			soundEffectClip = null;
		}
		soundEffectClip.play();
	}
}