using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

/// 
///  Repository for La Scala configuration settings
/// 
public static class LaScalaConfiguration
{
    //Caches the connection string
    private readonly static string dbConnectionString;
    //Caches the data provider naem
    private readonly static string dbProviderName;

    //store number of food per page
    private readonly static int foodsPerPage;

    //Store the food description length for food list
    private readonly static int foodsDescriptionLength;

    private readonly static string siteName;

    //store the number of days for shopping cart expiration
    private readonly static int cartPersistDays;

    static LaScalaConfiguration()
    {
        dbConnectionString = ConfigurationManager.ConnectionStrings["LaScalaConnection"].ConnectionString;
        dbProviderName = ConfigurationManager.ConnectionStrings["LaScalaConnection"].ProviderName;

        foodsPerPage = Int32.Parse(ConfigurationManager.AppSettings["FoodsPerPage"]);

        foodsDescriptionLength = Int32.Parse(ConfigurationManager.AppSettings["FoodsDescriptionLength"]);

        siteName = ConfigurationManager.AppSettings["SiteName"];

        cartPersistDays = Int32.Parse(ConfigurationManager.AppSettings["CartPersistDays"]);

    }

    //Returns the connection string for the BalloonShop database
    public static string DbConnectionString
    {
        get
        {
            return dbConnectionString;
        }
    }

    //Returns the data provider name
    public static string DbProviderName
    {
        get
        {
            return dbProviderName;
        }
    }

    //Returns the address of the mail server
    public static string MailServer
    {
        get
        {
            return ConfigurationManager.AppSettings["MailServer"];
        }
    }

    //Send error log emails?
    public static bool EnableErrorLogEmail
    {
        get
        {
            return bool.Parse(ConfigurationManager.AppSettings["EnableErrorLogEmail"]);
        }
    }

    //Returns the email address wheree to send error reports
    public static string ErrorLogEmail
    {
        get
        {
            return ConfigurationManager.AppSettings["ErrorLogEmail"];
        }
    }

    //Returns the maximum number of food to be displayed on a page
    public static int FoodsPerPage
    {
        get
        {
            return foodsPerPage;
        }
    }

    //Returns the lenth of food dedscription in food lists
    public static int FoodDescriptionLength
    {
        get
        {
            return foodsDescriptionLength;
        }
    }

    //Returns to the site name
    public static string SiteName
    {
        get
        {
            return siteName;
        }
    }

    //Returns the number of days for shopping cart expiration
    public static int CartPersistDays
    {
        get
        {
            return cartPersistDays;
        }
    }

    //Returns the email address for customers to contact the site
    public static string CustomerServiceEmail
    {
        get
        {
            return ConfigurationManager.AppSettings["CustomerServiceEmail"];

        }
    }

    //the 'form' address for auto generated order process emails
    public static string OrderProcessorEmail
    {
        get
        {
            return ConfigurationManager.AppSettings["OrderProcessorEmail"];
        }
    }
}
