using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Food : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        PopulateControls();
    }

    private void PopulateControls()
    {
        string foodId = Request.QueryString["FoodID"];
        FoodDetalis fd;

        fd = MenuAccess.GetFoodDetails(foodId);
        titleLabel.Text = fd.Name;
        descriptionLabel.Text = fd.Description;
        priceLabel.Text = String.Format("{0:c}", fd.Price);

        this.Title = LaScalaConfiguration.SiteName + " : Food : " + fd.Name;
    }

    //Add the food to cart
    protected void addToCartButton_Click(object sender, EventArgs e)
    {
        string foodId = Request.QueryString["FoodID"];

        ShoppingCartAccess.AddItem(foodId);
    }

    protected void continueShoppingButton_Click(object sender, EventArgs e)
    {
        object page;

        if ((page = Session["LastVisitedMenuItemPage"]) != null)
            Response.Redirect(page.ToString());
        else
            Response.Redirect(Request.ApplicationPath);
    }
}

