using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class MenuItem : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            PopulateControls();
        }
    }

    private void PopulateControls()
    {
        //Retrieve DirectoryID from the query string
        string directoryId = Request.QueryString["DirectoryID"];
        //Retrive MenuItemID from the query string
        string menuItemsId = Request.QueryString["MenuItemsID"];
        //if browsing the menu item
        if (menuItemsId != null)
        {
            //retrive menu items details and display them
            MenuItemsDetails md = MenuAccess.GetMenuItemsDetails(menuItemsId);
            MenuItemTitleLabel.Text = md.Name;
            MenuItemDescriptionLabel.Text = md.Description;

            //set the title  of the page
            this.Title = LaScalaConfiguration.SiteName + " :Menu : " + md.Name;
        }

        //If browsing a directory
        else if (directoryId != null)
        {
            DirectoryDetails dd = MenuAccess.GetDirectoryDetail(directoryId);
            MenuItemTitleLabel.Text = dd.Name;
            MenuItemDescriptionLabel.Text = dd.Description;

            this.Title = LaScalaConfiguration.SiteName + " : Directory: " + dd.Name;
        }
    }
}
