using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;

public partial class OrdersAdmin : System.Web.UI.Page
{
    protected void Page_Load(object sender, EventArgs e)
    {
        this.Title = LaScalaConfiguration.SiteName + " : Orders Admin";

        Utilities.TieButton(this.Page, orderIDBox, byIDGo);
        Utilities.TieButton(this.Page, recentCountTextBox, byRecentGo);
        Utilities.TieButton(this.Page, startDateTextBox, byDateGo);
        Utilities.TieButton(this.Page, endDateTextBox, byDateGo);
    }

    //Display orders by customer
    protected void byCustomerGo_Click(object sender, EventArgs e)
    {
        try
        {
            List<CommerceLibOrderInfo> orders = CommerceLibAccess.GetOrdersByCustomer(userDropDown.SelectedValue);
            grid.DataSource = orders;
            if (orders.Count == 0)
            {
                errorLabel.Text = "<br />Selected customer has made no orders.";
            }
        }
        catch
        {
            errorLabel.Text = "<br/>Couldn't get the requested orders.";
        }
        finally
        {
            grid.DataBind();
        }
    }

    //Display single order only
    protected void byIDGo_Click(object sender, EventArgs e)
    {
        try
        {
            List<CommerceLibOrderInfo> orders = new List<CommerceLibOrderInfo>();
            grid.DataSource = orders;
            Session["AdminOrderID"] = orderIDBox.Text;
            //display the order details admin control
            orderDetailsAdmin.Visible = true;
        }
        catch
        {
            errorLabel.Text = "<br /> Couldn't get the requested order!";

        }
        finally
        {
            grid.DataBind();
        }
    }

    protected void byRecentGo_Click(object sender, EventArgs e)
    {
        try
        {
            int recordCount = Int32.Parse(recentCountTextBox.Text);
            List<CommerceLibOrderInfo> orders =
              CommerceLibAccess.GetOrdersByRecent(recordCount);
            grid.DataSource = orders;
            if (orders.Count == 0)
            {
                errorLabel.Text = "<br />No orders to get.";
            }
        }
        catch
        {
            errorLabel.Text = "<br />Couldn't get the requested orders!";
        }
        finally
        {
            grid.DataBind();
        }
    }


    protected void byDateGo_Click(object sender, EventArgs e)
    {
        try
        {
            string startDate = startDateTextBox.Text;
            string endDate = endDateTextBox.Text;
            List<CommerceLibOrderInfo> orders =
              CommerceLibAccess.GetOrdersByDate(startDate, endDate);
            grid.DataSource = orders;
            if (orders.Count == 0)
            {
                errorLabel.Text =
                  "<br />No orders between selected dates.";
            }
        }
        catch
        {
            errorLabel.Text = "<br />Couldn't get the requested orders!";
        }
        finally
        {
            grid.DataBind();
        }
    }

    /*
    protected void unverfiedGo_Click(object sender, EventArgs e)
    {
        // load the grid with the requested data
        grid.DataSource = OrdersAccess.GetUnverifiedUncanceled();
        // refresh the data grid
        grid.DataBind();
        // no order is selected
        Session["AdminOrderID"] = null;
    }
    protected void uncompletedGo_Click(object sender, EventArgs e)
    {
        // load the grid with the requested data
        grid.DataSource = OrdersAccess.GetVerifiedUnCompleted();
        // refresh the data grid
        grid.DataBind();
        // no order is selected
        Session["AdminOrderID"] = null;
    }*/
    protected void grid_SelectedIndexChanged(object sender, EventArgs e)
    {
        Session["AdminOrderID"] = grid.DataKeys[grid.SelectedIndex].Value.ToString();

        orderDetailsAdmin.Visible = true;
    }

}
