using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class UserControls_CartSummary : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
        PopulateControls();
    }

    private void PopulateControls()
    {
        DataTable dt = ShoppingCartAccess.GetItems();

        if (dt.Rows.Count == 0)
        {
            cartSummaryLabel.Text = "Your order cart is empty.";
            totalAmountLabel.Text = String.Format("{0:c}", 0);
            viewCartLink.Visible = false;
            list.Visible = false;
        }
        else
        {
            list.Visible = true;
            list.DataSource = dt;
            list.DataBind();

            //set up controls
            cartSummaryLabel.Text = " Order Cart summary";
            viewCartLink.Visible = true;
            //display the totatl amount
            decimal amount = ShoppingCartAccess.GetTotalAmount();
            totalAmountLabel.Text = String.Format("{0:c}", amount);
        }
    }

    //
    protected void Page_Init(object sender, EventArgs e)
    {
        string page = Request.AppRelativeCurrentExecutionFilePath;

        if (String.Compare(page, "~/ShoppingCArt.aspx", true) == 0)
            this.Visible = false;
        else
            this.Visible = true;
    }
}
