using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class UserControls_FoodAdmin : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!Page.IsPostBack)
        {
            string menuItemsId = Request.QueryString["MenuItemsID"];
            MenuItemsDetails md = MenuAccess.GetMenuItemsDetails(menuItemsId);
            string menuItemsName = md.Name;

            statusLabel.ForeColor = System.Drawing.Color.Red;
            locationLabel.Text = "Displaying Foods fo Menu items <b>" + menuItemsName + "</b>";

            BindGrid();
        }
    }

    //populate the gridview with data
    private void BindGrid()
    {
        string menuItemsId = Request.QueryString["MenuItemsID"];
        grid.DataSource = MenuAccess.GetAllFoodsInMenuItems(menuItemsId);
        grid.DataBind();
    }


    //Enter row into edit mode
    protected void grid_RowEditing(object sender, GridViewEditEventArgs e)
    {
        //set the row for which to enable edit mode
        grid.EditIndex = e.NewEditIndex;
        //set status message
        statusLabel.Text = "Editing Row # " + e.NewEditIndex.ToString();

        BindGrid();
    }

    protected void grid_RowCancelingEdit(object sender, GridViewCancelEditEventArgs e)
    {
        //cancel edit mode
        grid.EditIndex = -1;
        //set status message
        statusLabel.Text = "Editing canceled";
        //Reload the grid
        BindGrid();
    }

    protected void grid_RowUpdating(object sender, GridViewUpdateEventArgs e)
    {
        string id = grid.DataKeys[e.RowIndex].Value.ToString();
        string name = ((TextBox)grid.Rows[e.RowIndex].FindControl("nameTextBox")).Text;

        string description = ((TextBox)grid.Rows[e.RowIndex].FindControl("descriptionTextBox")).Text;
        string price = ((TextBox)grid.Rows[e.RowIndex].FindControl("priceTextBox")).Text;
        string image1FileName = ((TextBox)grid.Rows[e.RowIndex].FindControl("image1TextBox")).Text;

        bool success = MenuAccess.UpdateFood(id, name, description, price, image1FileName);
        grid.EditIndex = -1;
        statusLabel.Text = success ? "Update successful" : "Update failed";

        BindGrid();

    }


    protected void createFood_Click(object sender, EventArgs e)
    {
        string menuItemsId = Request.QueryString["MenuItemsID"];
        bool success = MenuAccess.CreateFood(menuItemsId, newName.Text, newDescription.Text, newPrice.Text, newImage1FileName.Text);

        statusLabel.Text = success ? "Insert Successful" : "Insert Failed";
        BindGrid();
    }

    protected void goBackLink_Click(object sender, EventArgs e)
    {
        string directoryId = Request.QueryString["DirectoryID"];
        Response.Redirect(Request.ApplicationPath + "/MenuItemAdmin.aspx?DirectoryID=" + directoryId);
    }
}

