using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Specialized;

public partial class FoodsList : System.Web.UI.UserControl
{
    protected void Page_Load(object sender, EventArgs e)
    {
        PopulateControls();
    }

    private void PopulateControls()
    {
        //get directoryId, search and menuitemid form the query string
        string menuItemsId = Request.QueryString["MenuItemsID"];
        string directoryId = Request.QueryString["DirectoryID"];


        //get page form the query string
        string page = Request.QueryString["Page"];
        if (page == null)
            page = "1";
        string searchString = Request.QueryString["Search"];
        //how many pages of foods?
        int howManyPages = 1;

        if (searchString != null)
        {
            string allWords = Request.QueryString["AllWords"];

            list.DataSource = MenuAccess.Search(searchString, allWords, page, out howManyPages);
            list.DataBind();
        }
        else if (menuItemsId != null)
        {
            //get list of appetizer in a menuitem
            list.DataSource = MenuAccess.GetFoodInMenuItem(menuItemsId, page, out howManyPages);
            list.DataBind();
        }

        if (howManyPages > 1)
        {
            //have the current page as integer
            int currentPage = Int32.Parse(page);
            //make controls visible
            pagingLabel.Visible = true;
            previousLink.Visible = true;
            nextLink.Visible = true;
            //set the paging text
            pagingLabel.Text = "Page" + page + " of " + howManyPages.ToString();

            //create the previous link
            if (currentPage == 1)
                previousLink.Enabled = false;
            else
            {
                NameValueCollection query = Request.QueryString;
                string paramName, newQueryString = "?";
                for (int i = 0; i < query.Count; i++)
                    if (query.AllKeys[i] != null)
                        if ((paramName = query.AllKeys[i].ToString()).ToUpper() != "PAGE")
                            newQueryString += paramName + "=" + query[i] + "&";
                previousLink.NavigateUrl = Request.Url.AbsolutePath + newQueryString + "Page=" + (currentPage - 1).ToString();

            }

            //create the next Link
            if (currentPage == howManyPages)
                nextLink.Enabled = false;
            else
            {
                NameValueCollection query = Request.QueryString;
                string paramName, newQueryString = "?";
                for (int i = 0; i < query.Count; i++)
                    if (query.AllKeys[i] != null)
                        if ((paramName = query.AllKeys[i].ToString()).ToUpper() != "PAGE")
                            newQueryString += paramName + "=" + query[i] + "&";
                nextLink.NavigateUrl = Request.Url.AbsolutePath + newQueryString + "Page=" + (currentPage + 1).ToString();
            }
        }
    }
}
