/*
 * Decompiled with CFR 0.152.
 */
package fileio;

import finance.Account;
import finance.AccountType;
import finance.FinancialDatabase;
import finance.JournalEntry;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import utility.Status;

public final class FileManager {
    public static final Status NULL_DB = new Status("FileManager.NULL_DB");
    public static final Status FILE_NOT_FOUND = new Status("FileManager.FILE_NOT_FOUND");
    public static final Status BAD_FILE_TYPE = new Status("FileManager.BAD_FILE_TYPE");
    public static final Status FILE_CORRUPTED = new Status("FileManager.FILE_CORRUPTED");
    private static final int FILE_VERSION = 1;
    private static final int ACCOUNT_TYPE_BEGIN = 1;
    private static final int ACCOUNT_TYPE_END = 2;
    private static final int ACCOUNT_BEGIN = 3;
    private static final int ACCOUNT_END = 4;
    private static final int JOURNAL_ENTRY_BEGIN = 5;
    private static final int JOURNAL_ENTRY_END = 6;
    private static final int DELETION_RECORD_BEGIN = 7;
    private static final int DELETION_RECORD_END = 8;
    private File dbFile = null;
    private boolean isLoading = false;

    public static Status createNew(File file) {
        if (file.exists()) {
            return Status.ERROR;
        }
        BufferedOutputStream bufferedOutputStream = null;
        try {
            bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(file));
        }
        catch (Exception exception) {
            return Status.ERROR;
        }
        try {
            byte[] byArray = null;
            byte[] byArray2 = new byte[4];
            ByteBuffer byteBuffer = ByteBuffer.wrap(byArray2);
            bufferedOutputStream.write(68);
            bufferedOutputStream.write(69);
            bufferedOutputStream.write(65);
            bufferedOutputStream.write(80);
            bufferedOutputStream.write(1);
            for (AccountType accountType : AccountType.getList()) {
                bufferedOutputStream.write(1);
                byArray = AccountType.convertToBytes(accountType);
                byteBuffer.putInt(0, byArray.length);
                bufferedOutputStream.write(byArray2);
                bufferedOutputStream.write(byArray);
                bufferedOutputStream.write(2);
            }
            bufferedOutputStream.close();
            return Status.OK;
        }
        catch (Exception exception) {
            try {
                bufferedOutputStream.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            file.delete();
            return Status.ERROR;
        }
    }

    public FileManager(File file) {
        this.dbFile = file;
    }

    public Status loadFile(FinancialDatabase financialDatabase) {
        if (financialDatabase == null) {
            return NULL_DB;
        }
        if (!this.dbFile.exists()) {
            return FILE_NOT_FOUND;
        }
        RandomAccessFile randomAccessFile = null;
        int n = 0;
        try {
            randomAccessFile = new RandomAccessFile(this.dbFile, "rwd");
        }
        catch (Exception exception) {
            return Status.ERROR;
        }
        try {
            if (randomAccessFile.read() == 68) {
                ++n;
            }
            if (randomAccessFile.read() == 69) {
                ++n;
            }
            if (randomAccessFile.read() == 65) {
                ++n;
            }
            if (randomAccessFile.read() == 80) {
                ++n;
            }
            if (randomAccessFile.read() == 1) {
                ++n;
            }
            if (n != 5) {
                randomAccessFile.close();
                return BAD_FILE_TYPE;
            }
            this.isLoading = true;
            int n2 = 0;
            int n3 = 0;
            while ((n2 = randomAccessFile.read()) != -1) {
                if (n2 == 1) {
                    n3 = this.loadAccountType(randomAccessFile, financialDatabase);
                } else if (n2 == 3) {
                    n3 = this.loadAccount(randomAccessFile, financialDatabase);
                } else if (n2 == 5) {
                    n3 = this.loadJournalEntry(randomAccessFile, financialDatabase);
                } else if (n2 == 7) {
                    n3 = this.loadDeletion(randomAccessFile, financialDatabase);
                }
                if (n3 == -1) break;
                n += n3;
            }
            this.isLoading = false;
            randomAccessFile.close();
            if (n3 != -1) {
                return Status.OK;
            }
            return FILE_CORRUPTED;
        }
        catch (Exception exception) {
            System.out.println(exception);
            exception.printStackTrace();
            try {
                randomAccessFile.close();
            }
            catch (Exception exception2) {
                // empty catch block
            }
            return Status.ERROR;
        }
    }

    private int loadAccountType(RandomAccessFile randomAccessFile, FinancialDatabase financialDatabase) {
        try {
            byte[] byArray = new byte[4];
            randomAccessFile.readFully(byArray);
            int n = ByteBuffer.wrap(byArray).getInt(0);
            byte[] byArray2 = new byte[n];
            randomAccessFile.readFully(byArray2);
            if (randomAccessFile.read() != 2) {
                return -1;
            }
            financialDatabase.addAccountType(AccountType.convertFromBytes(byArray2));
            return byArray2.length + 5;
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    public Status recordAccountType(AccountType accountType) {
        byte[] byArray = AccountType.convertToBytes(accountType);
        byte[] byArray2 = new byte[byArray.length + 6];
        byte[] byArray3 = new byte[4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray3);
        byteBuffer.putInt(0, byArray.length);
        byArray2[0] = 1;
        System.arraycopy(byArray3, 0, byArray2, 1, byArray3.length);
        System.arraycopy(byArray, 0, byArray2, 5, byArray.length);
        byArray2[byArray2.length - 1] = 2;
        return this.writeBytes(byArray2);
    }

    private int loadAccount(RandomAccessFile randomAccessFile, FinancialDatabase financialDatabase) {
        try {
            byte[] byArray = new byte[4];
            randomAccessFile.readFully(byArray);
            int n = ByteBuffer.wrap(byArray).getInt(0);
            byte[] byArray2 = new byte[n];
            randomAccessFile.readFully(byArray2);
            if (randomAccessFile.read() != 4) {
                return -1;
            }
            financialDatabase.addAccount(Account.convertFromBytes(byArray2));
            return byArray2.length + 5;
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    public Status recordAccount(Account account) {
        byte[] byArray = Account.convertToBytes(account);
        byte[] byArray2 = new byte[byArray.length + 6];
        byte[] byArray3 = new byte[4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray3);
        byteBuffer.putInt(0, byArray.length);
        byArray2[0] = 3;
        System.arraycopy(byArray3, 0, byArray2, 1, byArray3.length);
        System.arraycopy(byArray, 0, byArray2, 5, byArray.length);
        byArray2[byArray2.length - 1] = 4;
        return this.writeBytes(byArray2);
    }

    private int loadJournalEntry(RandomAccessFile randomAccessFile, FinancialDatabase financialDatabase) {
        try {
            byte[] byArray = new byte[4];
            randomAccessFile.readFully(byArray);
            int n = ByteBuffer.wrap(byArray).getInt(0);
            byte[] byArray2 = new byte[n];
            randomAccessFile.readFully(byArray2);
            if (randomAccessFile.read() != 6) {
                return -1;
            }
            financialDatabase.addJournalEntry(JournalEntry.convertFromBytes(byArray2));
            return byArray2.length + 5;
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    public Status recordJournalEntry(JournalEntry journalEntry) {
        byte[] byArray = JournalEntry.convertToBytes(journalEntry);
        byte[] byArray2 = new byte[byArray.length + 6];
        byte[] byArray3 = new byte[4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray3);
        byteBuffer.putInt(0, byArray.length);
        byArray2[0] = 5;
        System.arraycopy(byArray3, 0, byArray2, 1, byArray3.length);
        System.arraycopy(byArray, 0, byArray2, 5, byArray.length);
        byArray2[byArray2.length - 1] = 6;
        return this.writeBytes(byArray2);
    }

    private int loadDeletion(RandomAccessFile randomAccessFile, FinancialDatabase financialDatabase) {
        try {
            byte[] byArray = new byte[4];
            randomAccessFile.readFully(byArray);
            int n = ByteBuffer.wrap(byArray).getInt(0);
            byte[] byArray2 = new byte[n];
            randomAccessFile.readFully(byArray2);
            if (randomAccessFile.read() != 8) {
                return -1;
            }
            financialDatabase.addDeletion(byArray2);
            return byArray2.length + 5;
        }
        catch (IOException iOException) {
            return -1;
        }
    }

    public Status recordDeletion(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length + 6];
        byte[] byArray3 = new byte[4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray3);
        byteBuffer.putInt(0, byArray.length);
        byArray2[0] = 7;
        System.arraycopy(byArray3, 0, byArray2, 1, byArray3.length);
        System.arraycopy(byArray, 0, byArray2, 5, byArray.length);
        byArray2[byArray2.length - 1] = 8;
        return this.writeBytes(byArray2);
    }

    private Status writeBytes(byte[] byArray) {
        if (this.isLoading) {
            return Status.OK;
        }
        if (!this.dbFile.exists()) {
            return FILE_NOT_FOUND;
        }
        RandomAccessFile randomAccessFile = null;
        long l = 0L;
        try {
            randomAccessFile = new RandomAccessFile(this.dbFile, "rwd");
            l = randomAccessFile.length();
            randomAccessFile.seek(l);
        }
        catch (Exception exception) {
            return Status.ERROR;
        }
        try {
            randomAccessFile.write(byArray);
            randomAccessFile.close();
            return Status.OK;
        }
        catch (Exception exception) {
            System.out.println(exception);
            try {
                randomAccessFile.setLength(l);
                randomAccessFile.close();
                return Status.ERROR;
            }
            catch (Exception exception2) {
                try {
                    randomAccessFile.close();
                }
                catch (Exception exception3) {
                    // empty catch block
                }
                return FILE_CORRUPTED;
            }
        }
    }
}

