/*
 * Decompiled with CFR 0.152.
 */
package finance;

import finance.AccountEntry;
import finance.AccountType;
import finance.Amount;
import finance.JournalEntry;
import gui.Main;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.SortedSet;
import java.util.TreeSet;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.TableModel;
import utility.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Account {
    private static int newID = 0;
    private int id;
    AccountType type;
    String name;
    String number;
    Date refDate;
    Amount refBalance;
    Amount currentBalance;
    String comments;
    TreeSet<AccountEntry> entries = new TreeSet<AccountEntry>(AccountEntry.COMPARATOR);
    SortedSet<AccountEntry> entriesHead = null;
    SortedSet<AccountEntry> entriesTail = null;
    DataModel dataModel = null;

    public static byte[] convertToBytes(Account account) {
        int n = 0;
        byte[] byArray = new byte[4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byte[] byArray2 = new byte[4];
        ByteBuffer.wrap(byArray2).putInt(account.id);
        n += 4;
        byte[] byArray3 = new byte[4];
        ByteBuffer.wrap(byArray3).putInt(account.type.getID());
        n += 4;
        byte[] byArray4 = account.name.getBytes();
        n += byArray4.length + 4;
        byte[] byArray5 = account.number.getBytes();
        n += byArray5.length + 4;
        byte[] byArray6 = new byte[8];
        ByteBuffer.wrap(byArray6).putLong(account.refDate.getTime());
        n += 8;
        byte[] byArray7 = Amount.convertToBytes(account.refBalance);
        n += byArray7.length + 4;
        byte[] byArray8 = Amount.convertToBytes(account.currentBalance);
        n += byArray8.length + 4;
        byte[] byArray9 = account.comments.getBytes();
        byte[] byArray10 = new byte[n += byArray9.length + 4];
        int n2 = 0;
        System.arraycopy(byArray2, 0, byArray10, n2, 4);
        System.arraycopy(byArray3, 0, byArray10, n2 += 4, 4);
        byteBuffer.putInt(0, byArray4.length);
        System.arraycopy(byArray, 0, byArray10, n2 += 4, 4);
        System.arraycopy(byArray4, 0, byArray10, n2 += 4, byArray4.length);
        byteBuffer.putInt(0, byArray5.length);
        System.arraycopy(byArray, 0, byArray10, n2 += byArray4.length, 4);
        System.arraycopy(byArray5, 0, byArray10, n2 += 4, byArray5.length);
        System.arraycopy(byArray6, 0, byArray10, n2 += byArray5.length, 8);
        byteBuffer.putInt(0, byArray7.length);
        System.arraycopy(byArray, 0, byArray10, n2 += 8, 4);
        System.arraycopy(byArray7, 0, byArray10, n2 += 4, byArray7.length);
        byteBuffer.putInt(0, byArray8.length);
        System.arraycopy(byArray, 0, byArray10, n2 += byArray7.length, 4);
        System.arraycopy(byArray8, 0, byArray10, n2 += 4, byArray8.length);
        byteBuffer.putInt(0, byArray9.length);
        System.arraycopy(byArray, 0, byArray10, n2 += byArray8.length, 4);
        System.arraycopy(byArray9, 0, byArray10, n2 += 4, byArray9.length);
        n2 += byArray9.length;
        return byArray10;
    }

    public static Account convertFromBytes(byte[] byArray) {
        Account account = new Account();
        int n = 0;
        int n2 = 0;
        account.id = ByteBuffer.wrap(byArray, n, 4).getInt();
        n += 4;
        if (newID <= account.id) {
            newID = account.id + 1;
        }
        int n3 = ByteBuffer.wrap(byArray, n, 4).getInt();
        account.type = Main.getDB().getAccountType(n3);
        n2 = ByteBuffer.wrap(byArray, n += 4, 4).getInt();
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n += 4, byArray2, 0, n2);
        n += n2;
        account.name = new String(byArray2);
        n2 = ByteBuffer.wrap(byArray, n, 4).getInt();
        byte[] byArray3 = new byte[n2];
        System.arraycopy(byArray, n += 4, byArray3, 0, n2);
        account.number = new String(byArray3);
        long l = ByteBuffer.wrap(byArray, n += n2, 8).getLong();
        account.refDate = new Date(l);
        n2 = ByteBuffer.wrap(byArray, n += 8, 4).getInt();
        byte[] byArray4 = new byte[n2];
        System.arraycopy(byArray, n += 4, byArray4, 0, n2);
        n += n2;
        account.refBalance = Amount.convertFromBytes(byArray4);
        n2 = ByteBuffer.wrap(byArray, n, 4).getInt();
        byte[] byArray5 = new byte[n2];
        System.arraycopy(byArray, n += 4, byArray5, 0, n2);
        n += n2;
        account.currentBalance = account.refBalance;
        n2 = ByteBuffer.wrap(byArray, n, 4).getInt();
        byte[] byArray6 = new byte[n2];
        System.arraycopy(byArray, n += 4, byArray6, 0, n2);
        n += n2;
        account.comments = new String(byArray6);
        account.configureSets();
        return account;
    }

    private Account() {
    }

    public Account(String string, String string2, AccountType accountType, Date date, Amount amount, String string3) {
        if (string == null || accountType == null || date == null || amount == null) {
            throw new NullPointerException();
        }
        Account account = Main.getDB().getAccountByName(string);
        if (account != null && account != this) {
            throw new IllegalArgumentException();
        }
        account = Main.getDB().getAccountByNumber(string2);
        if (account != null && account != this) {
            throw new IllegalArgumentException();
        }
        this.id = newID++;
        this.name = string;
        this.type = accountType;
        this.refDate = date;
        this.currentBalance = this.refBalance = amount;
        this.number = string2 != null ? string2 : "";
        this.comments = string3 != null ? string3 : "";
        this.configureSets();
    }

    public int getID() {
        return this.id;
    }

    public AccountType getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getNumber() {
        return this.number;
    }

    public Date getReferenceDate() {
        return this.refDate;
    }

    public Amount getReferenceBalance() {
        return this.refBalance;
    }

    public Amount getBalance() {
        return this.currentBalance;
    }

    public String getComments() {
        return this.comments;
    }

    public Collection<AccountEntry> getEntries() {
        return Collections.unmodifiableCollection(this.entries);
    }

    void add(AccountEntry accountEntry) {
        int n;
        if (accountEntry == null) {
            return;
        }
        this.entries.add(accountEntry);
        accountEntry.balance = this.type.getZero();
        ArrayList<AccountEntry> arrayList = new ArrayList<AccountEntry>(this.entries);
        int n2 = n = this.getIndex(accountEntry);
        int n3 = n;
        if (accountEntry.getDate().compareTo(this.refDate) >= 0) {
            this.currentBalance = this.currentBalance.add(accountEntry.amount);
            accountEntry.balance = n > 0 ? arrayList.get((int)(n - 1)).balance.add(accountEntry.amount) : accountEntry.amount.add(this.refBalance);
            for (int i = n + 1; i < arrayList.size(); ++i) {
                arrayList.get((int)i).balance = arrayList.get((int)i).balance.add(accountEntry.amount);
            }
            n2 = n;
            n3 = arrayList.size() - 1;
        } else {
            accountEntry.balance = n < this.entriesHead.size() - 1 ? arrayList.get((int)(n + 1)).balance.subtract(arrayList.get((int)(n + 1)).amount) : this.refBalance;
            for (int i = n - 1; i >= 0; --i) {
                arrayList.get((int)i).balance = arrayList.get((int)i).balance.subtract(accountEntry.amount);
            }
            n2 = 0;
            n3 = n;
        }
        this.fireAddEvent(this.getIndex(accountEntry));
        if (this.dataModel != null) {
            this.dataModel.fireTableRowsUpdated(n2, n3);
        }
    }

    void remove(AccountEntry accountEntry) {
        if (accountEntry == null) {
            return;
        }
        int n = this.getIndex(accountEntry);
        this.entries.remove(accountEntry);
        if (accountEntry.getDate().compareTo(this.refDate) >= 0) {
            this.currentBalance = this.currentBalance.subtract(accountEntry.amount);
            SortedSet<AccountEntry> sortedSet = this.entries.tailSet(accountEntry);
            for (AccountEntry accountEntry2 : sortedSet) {
                accountEntry2.balance = accountEntry2.balance.subtract(accountEntry.amount);
            }
        } else {
            SortedSet<AccountEntry> sortedSet = this.entries.headSet(accountEntry);
            for (AccountEntry accountEntry3 : sortedSet) {
                accountEntry3.balance = accountEntry3.balance.add(accountEntry.amount);
            }
        }
        this.fireRemoveEvent(n);
    }

    public Status update(String string, String string2, AccountType accountType, Date date, Amount amount, String string3) {
        if (string == null || accountType == null || date == null || amount == null) {
            return Status.ERROR;
        }
        Account account = Main.getDB().getAccountByName(string);
        if (account != null && account != this) {
            return Status.ERROR;
        }
        account = Main.getDB().getAccountByNumber(string2);
        if (account != null && account != this) {
            return Status.ERROR;
        }
        boolean bl = false;
        if (!date.equals(this.refDate) || !amount.equals(this.refBalance)) {
            bl = true;
        }
        this.name = string;
        this.type = accountType;
        this.refDate = date;
        this.refBalance = amount;
        this.number = string2 != null ? string2 : "";
        String string4 = this.comments = string3 != null ? string3 : "";
        if (!bl) {
            return Status.OK;
        }
        TreeSet<AccountEntry> treeSet = this.entries;
        this.entries = new TreeSet<AccountEntry>(AccountEntry.COMPARATOR);
        this.configureSets();
        this.currentBalance = this.refBalance;
        for (AccountEntry accountEntry : treeSet) {
            this.add(accountEntry);
        }
        if (this.dataModel != null) {
            this.dataModel.updateList();
            this.dataModel.fireTableRowsUpdated(0, this.entries.size() - 1);
        }
        return Status.OK;
    }

    Status update(Account account) {
        return this.update(account.name, account.number, account.type, account.refDate, account.refBalance, account.comments);
    }

    private void configureSets() {
        JournalEntry journalEntry = Main.getDB().getJournal().newEntry(this.refDate, "");
        AccountEntry accountEntry = new AccountEntry(this, this.type.getZero());
        journalEntry.add(accountEntry);
        this.entriesHead = this.entries.headSet(accountEntry);
        this.entriesTail = this.entries.tailSet(accountEntry);
    }

    private int getIndex(AccountEntry accountEntry) {
        SortedSet<AccountEntry> sortedSet = this.entries.headSet(accountEntry);
        return sortedSet.size();
    }

    public TableModel getDataModel() {
        if (this.dataModel == null) {
            this.dataModel = new DataModel(this);
        }
        return this.dataModel;
    }

    private void fireAddEvent(int n) {
        if (this.dataModel == null) {
            return;
        }
        this.dataModel.updateList();
        this.dataModel.fireTableRowsInserted(n, n);
    }

    private void fireRemoveEvent(int n) {
        if (this.dataModel == null) {
            return;
        }
        this.dataModel.updateList();
        this.dataModel.fireTableRowsDeleted(n, n);
    }

    public static final class DataModel
    extends AbstractTableModel {
        public static final int DATE_COL = 0;
        public static final int DESC_COL = 1;
        public static final int DEBIT_COL = 2;
        public static final int CREDIT_COL = 3;
        public static final int BALANCE_COL = 4;
        public static final int COLUMN_COUNT = 5;
        Account account = null;
        ArrayList<AccountEntry> list = null;

        DataModel(Account account) {
            this.account = account;
            this.updateList();
        }

        private void updateList() {
            this.list = new ArrayList<AccountEntry>(this.account.entries);
        }

        public int getRowCount() {
            return this.list.size();
        }

        public int getColumnCount() {
            return 5;
        }

        public Object getValueAt(int n, int n2) {
            if (n2 >= 0 && n2 < 5 && n >= 0 && n < this.getRowCount()) {
                return this.list.get(n);
            }
            return null;
        }

        public String getColumnName(int n) {
            switch (n) {
                case 0: {
                    return "Date";
                }
                case 1: {
                    return "Description";
                }
                case 2: {
                    return "Debit";
                }
                case 3: {
                    return "Credit";
                }
                case 4: {
                    return "Balance";
                }
            }
            return super.getColumnName(n);
        }
    }
}

