/*
 * Decompiled with CFR 0.152.
 */
package finance;

import finance.Account;
import finance.Amount;
import finance.BalanceType;
import finance.JournalEntry;
import gui.Main;
import java.nio.ByteBuffer;
import java.util.Date;

public class AccountEntry {
    public static final Comparator<AccountEntry> COMPARATOR = new Comparator();
    Account account = null;
    JournalEntry entry = null;
    Amount amount = Amount.ZERO;
    Amount balance = Amount.ZERO;

    public static byte[] convertToBytes(AccountEntry accountEntry) {
        int n = 4;
        byte[] byArray = new byte[4];
        ByteBuffer.wrap(byArray).putInt(accountEntry.account.getID());
        byte[] byArray2 = Amount.convertToBytes(accountEntry.amount);
        byte[] byArray3 = new byte[n += byArray2.length];
        System.arraycopy(byArray, 0, byArray3, 0, 4);
        System.arraycopy(byArray2, 0, byArray3, 4, byArray2.length);
        return byArray3;
    }

    public static AccountEntry convertFromBytes(byte[] byArray) {
        Account account = Main.getDB().getAccountByID(ByteBuffer.wrap(byArray, 0, 4).getInt());
        byte[] byArray2 = new byte[byArray.length - 4];
        System.arraycopy(byArray, 4, byArray2, 0, byArray2.length);
        return new AccountEntry(account, Amount.convertFromBytes(byArray2));
    }

    public static AccountEntry copy(AccountEntry accountEntry) {
        AccountEntry accountEntry2 = new AccountEntry(accountEntry.account, accountEntry.amount);
        accountEntry2.entry = accountEntry.entry;
        accountEntry2.balance = accountEntry.balance;
        return accountEntry2;
    }

    public AccountEntry(Account account, Amount amount) {
        this.account = account;
        this.amount = amount;
    }

    public Account getAccount() {
        return this.account;
    }

    public Amount getAmount() {
        return this.amount;
    }

    public Amount getBalance() {
        return this.balance;
    }

    public Date getDate() {
        return this.entry.getDate();
    }

    public String getAccountName() {
        return this.account.getName();
    }

    public BalanceType getBalanceType() {
        return this.account.getType().getNormalBalance();
    }

    public String getDescription() {
        return this.entry.getDescription();
    }

    public String getDebit() {
        return this.getAmount(BalanceType.DEBIT);
    }

    public String getCredit() {
        return this.getAmount(BalanceType.CREDIT);
    }

    public String getBalanceString() {
        return String.format("%.2f", this.balance.getValue());
    }

    String getAmount(BalanceType balanceType) {
        if (this.amount.getType() == balanceType) {
            return String.format("%.2f", this.amount.getValue());
        }
        return "";
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Comparator<T extends AccountEntry>
    implements java.util.Comparator<T> {
        @Override
        public int compare(T t, T t2) {
            return JournalEntry.COMP_DATE.compare(((AccountEntry)t).entry, ((AccountEntry)t2).entry);
        }

        @Override
        public boolean equals(Object object) {
            return object != null && this.getClass() == object.getClass();
        }
    }
}

