/*
 * Decompiled with CFR 0.152.
 */
package finance;

import finance.BalanceType;
import java.math.BigDecimal;

public final class Amount {
    public static final Amount ZERO;
    public static final Amount ZERO_DEBIT;
    public static final Amount ZERO_CREDIT;
    private final BigDecimal value;
    private final BalanceType type;

    public static byte[] convertToBytes(Amount amount) {
        int n = 1;
        byte[] byArray = String.format("%.2f", amount.value).getBytes();
        byte[] byArray2 = new byte[n += byArray.length];
        System.arraycopy(byArray, 0, byArray2, 0, byArray.length);
        if (amount.type == BalanceType.DEBIT) {
            byArray2[n - 1] = 1;
        } else if (amount.type == BalanceType.CREDIT) {
            byArray2[n - 1] = 2;
        }
        return byArray2;
    }

    public static Amount convertFromBytes(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length - 1];
        System.arraycopy(byArray, 0, byArray2, 0, byArray2.length);
        BalanceType balanceType = null;
        if (byArray[byArray.length - 1] == 1) {
            balanceType = BalanceType.DEBIT;
        } else if (byArray[byArray.length - 1] == 2) {
            balanceType = BalanceType.CREDIT;
        }
        return new Amount(new String(byArray2), balanceType);
    }

    public static Amount add(Amount amount, Amount amount2) {
        if (amount != null && amount2 != null) {
            if (amount.type == amount2.type) {
                return new Amount(amount.value.add(amount2.value), amount.type);
            }
            if (amount.value.compareTo(amount2.value) < 0) {
                return new Amount(amount2.value.subtract(amount.value), amount2.type);
            }
            if (amount.value.compareTo(amount2.value) > 0) {
                return new Amount(amount.value.subtract(amount2.value), amount.type);
            }
            return ZERO;
        }
        if (amount == null && amount2 == null) {
            return ZERO;
        }
        if (amount == null) {
            return Amount.add(ZERO, amount2);
        }
        if (amount2 == null) {
            return Amount.add(ZERO, amount);
        }
        return ZERO;
    }

    public static Amount subtract(Amount amount, Amount amount2) {
        if (amount != null && amount2 != null) {
            if (amount.type != amount2.type) {
                return new Amount(amount.value.add(amount2.value), amount.type);
            }
            if (amount.value.compareTo(amount2.value) > 0) {
                return new Amount(amount.value.subtract(amount2.value), amount.type);
            }
            if (amount.value.compareTo(amount2.value) < 0) {
                return new Amount(amount2.value.subtract(amount.value), Amount.switchType(amount.type));
            }
            return ZERO;
        }
        if (amount == null && amount2 == null) {
            return ZERO;
        }
        if (amount == null) {
            return Amount.subtract(ZERO, amount2);
        }
        if (amount2 == null) {
            return Amount.subtract(amount, ZERO);
        }
        return ZERO;
    }

    public Amount(BigDecimal bigDecimal, BalanceType balanceType) {
        if (bigDecimal == null) {
            throw new IllegalArgumentException("value == null");
        }
        if (balanceType == null) {
            throw new IllegalArgumentException("type == null");
        }
        if (bigDecimal.signum() == -1) {
            throw new IllegalArgumentException("value < 0");
        }
        this.value = bigDecimal;
        this.type = balanceType;
    }

    public Amount(String string, BalanceType balanceType) {
        this(new BigDecimal(string), balanceType);
    }

    public Amount add(Amount amount) {
        return Amount.add(this, amount);
    }

    public Amount subtract(Amount amount) {
        return Amount.subtract(this, amount);
    }

    public BigDecimal getValue() {
        return this.value;
    }

    public BalanceType getType() {
        return this.type;
    }

    public boolean equals(Object object) {
        if (object != null && object instanceof Amount) {
            Amount amount = (Amount)object;
            return this.type == amount.type && this.value.compareTo(amount.value) == 0;
        }
        return false;
    }

    private static BalanceType switchType(BalanceType balanceType) {
        if (balanceType == BalanceType.DEBIT) {
            return BalanceType.CREDIT;
        }
        return BalanceType.DEBIT;
    }

    static {
        ZERO_DEBIT = ZERO = new Amount(BigDecimal.ZERO, BalanceType.DEBIT);
        ZERO_CREDIT = new Amount(BigDecimal.ZERO, BalanceType.CREDIT);
    }
}

