/*
 * Decompiled with CFR 0.152.
 */
package finance;

import fileio.FileManager;
import finance.Account;
import finance.AccountType;
import finance.BalanceType;
import finance.Journal;
import finance.JournalEntry;
import finance.Ledger;
import java.io.File;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import utility.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FinancialDatabase {
    private static final int DELETE_ACCOUNT_TYPE = 1;
    private static final int DELETE_ACCOUNT = 2;
    private static final int DELETE_JOURNAL_ENTRY = 3;
    LinkedList<AccountType> accountTypes = new LinkedList();
    Journal journal = new Journal(this, 0, "General Journal");
    Ledger ledger = new Ledger(this);
    FileManager fileManager = null;

    public static Status createNew(File file) {
        return FileManager.createNew(file);
    }

    public FinancialDatabase(File file) {
        this.fileManager = new FileManager(file);
    }

    public Status loadFile() {
        return this.fileManager.loadFile(this);
    }

    public Status saveFileAs(File file) {
        if (file.exists() && !file.delete()) {
            return Status.ERROR;
        }
        Status status = FileManager.createNew(file);
        if (status != Status.OK) {
            return status;
        }
        FileManager fileManager = new FileManager(file);
        for (AccountType object : this.accountTypes) {
            if (status != Status.OK) break;
            fileManager.recordAccountType(object);
        }
        for (Account account : this.ledger.getAccounts()) {
            if (status != Status.OK) break;
            fileManager.recordAccount(account);
        }
        for (JournalEntry journalEntry : this.journal.getEntries()) {
            if (status != Status.OK) break;
            fileManager.recordJournalEntry(journalEntry);
        }
        if (status != Status.OK) {
            file.delete();
            return status;
        }
        this.fileManager = fileManager;
        return Status.OK;
    }

    public void parseAccountTypes(String string) {
        String[] stringArray;
        if (string == null) {
            return;
        }
        for (String string2 : stringArray = string.split(";")) {
            int n = string2.lastIndexOf(",");
            if (n == -1) continue;
            String string3 = string2.substring(0, n).trim();
            String string4 = string2.substring(n + 1).trim();
            BalanceType balanceType = null;
            if (string4.equalsIgnoreCase("debit")) {
                balanceType = BalanceType.DEBIT;
            } else if (string4.equalsIgnoreCase("credit")) {
                balanceType = BalanceType.CREDIT;
            }
            if (string3.equals("") || balanceType == null) continue;
            this.addAccountType(new AccountType(string3, balanceType));
        }
    }

    public Journal getJournal() {
        return this.journal;
    }

    public Ledger getLedger() {
        return this.ledger;
    }

    public void addAccountType(AccountType accountType) {
        if (accountType == null || this.getAccountType(accountType.getName()) != null) {
            return;
        }
        this.accountTypes.add(accountType);
        this.ledger.addAccountType(accountType);
        this.fileManager.recordAccountType(accountType);
    }

    public void removeAccountType(AccountType accountType) {
        if (accountType == null || this.getAccountType(accountType.getName()) == null) {
            return;
        }
        this.accountTypes.remove(accountType);
        this.ledger.removeAccountType(accountType);
        this.recordDeletion(accountType);
    }

    public List<AccountType> getAccountTypes() {
        return Collections.unmodifiableList(this.accountTypes);
    }

    public AccountType getAccountType(String string) {
        if (string == null) {
            return null;
        }
        for (AccountType accountType : this.accountTypes) {
            if (!string.equalsIgnoreCase(accountType.getName())) continue;
            return accountType;
        }
        return null;
    }

    public AccountType getAccountType(int n) {
        for (AccountType accountType : this.accountTypes) {
            if (n != accountType.getID()) continue;
            return accountType;
        }
        return null;
    }

    public void addAccount(Account account) {
        if (account == null) {
            return;
        }
        Account account2 = this.getAccountByID(account.getID());
        if (account2 == null) {
            account2 = account;
        } else {
            account2.update(account);
        }
        this.ledger.addOrUpdate(account2);
        this.recordAccount(account2);
    }

    public void removeAccount(Account account) {
        if (account == null || this.getAccountByID(account.getID()) == null) {
            return;
        }
        this.ledger.removeAccount(account);
        this.recordDeletion(account);
    }

    public void recordAccount(Account account) {
        this.fileManager.recordAccount(account);
    }

    public Account getAccountByName(String string) {
        for (Account account : this.ledger.getAccounts()) {
            if (!account.getName().equalsIgnoreCase(string)) continue;
            return account;
        }
        return null;
    }

    public Account getAccountByNumber(String string) {
        if (string == null || string.equals("")) {
            return null;
        }
        for (Account account : this.ledger.getAccounts()) {
            if (!account.getNumber().equalsIgnoreCase(string)) continue;
            return account;
        }
        return null;
    }

    public Account getAccountByID(int n) {
        for (Account account : this.ledger.getAccounts()) {
            if (account.getID() != n) continue;
            return account;
        }
        return null;
    }

    public String[] getAccountNames() {
        String[] stringArray = new String[this.ledger.getAccounts().size()];
        int n = 0;
        for (Account account : this.ledger.getAccounts()) {
            stringArray[n++] = account.getName();
        }
        return stringArray;
    }

    public void addJournalEntry(JournalEntry journalEntry) {
        this.journal.addOrUpdate(journalEntry);
    }

    public void recordEntry(JournalEntry journalEntry) {
        this.fileManager.recordJournalEntry(journalEntry);
    }

    public void addDeletion(byte[] byArray) {
        int n = 0;
        switch (byArray[0]) {
            case 1: {
                n = ByteBuffer.wrap(byArray, 1, 4).getInt();
                this.removeAccountType(this.getAccountType(n));
                break;
            }
            case 2: {
                n = ByteBuffer.wrap(byArray, 1, 4).getInt();
                this.ledger.removeAccount(n);
                break;
            }
            case 3: {
                long l = ByteBuffer.wrap(byArray, 1, 8).getLong();
                this.journal.remove(l);
            }
        }
    }

    public void recordDeletion(AccountType accountType) {
        byte[] byArray = new byte[5];
        byArray[0] = 1;
        ByteBuffer.wrap(byArray, 1, 4).putInt(accountType.getID());
        this.fileManager.recordDeletion(byArray);
    }

    public void recordDeletion(Account account) {
        byte[] byArray = new byte[5];
        byArray[0] = 2;
        ByteBuffer.wrap(byArray, 1, 4).putInt(account.getID());
        this.fileManager.recordDeletion(byArray);
    }

    public void recordDeletion(JournalEntry journalEntry) {
        byte[] byArray = new byte[9];
        byArray[0] = 3;
        ByteBuffer.wrap(byArray, 1, 8).putLong(journalEntry.getID());
        this.fileManager.recordDeletion(byArray);
    }
}

