/*
 * Decompiled with CFR 0.152.
 */
package finance;

import finance.AccountEntry;
import finance.Journal;
import gui.Main;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import utility.Status;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class JournalEntry {
    public static final Comparator<JournalEntry> COMP_DATE = new DateComparator<JournalEntry>();
    public static final Comparator<JournalEntry> COMP_ID = new IDComparator<JournalEntry>();
    public static final Status NOT_NEW = new Status("JournalEntry.NOT_NEW");
    Journal journal = null;
    private long id = 0L;
    private Date date = new Date();
    private LinkedList<AccountEntry> amounts = new LinkedList();
    private String description = "";
    boolean isNew = true;

    public static byte[] convertToBytes(JournalEntry journalEntry) {
        int n = 20;
        byte[] byArray = new byte[8];
        ByteBuffer.wrap(byArray).putLong(journalEntry.id);
        byte[] byArray2 = new byte[8];
        ByteBuffer.wrap(byArray2).putLong(journalEntry.date.getTime());
        byte[] byArray3 = new byte[4];
        ByteBuffer.wrap(byArray3).putInt(journalEntry.amounts.size());
        for (AccountEntry object2 : journalEntry.amounts) {
            n += AccountEntry.convertToBytes(object2).length + 4;
        }
        Object object3 = journalEntry.description.getBytes();
        byte[] byArray4 = new byte[n += ((Object)object3).length + 4];
        byte[] byArray5 = new byte[4];
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray5);
        int n2 = 0;
        System.arraycopy(byArray, 0, byArray4, n2, 8);
        System.arraycopy(byArray2, 0, byArray4, n2 += 8, 8);
        System.arraycopy(byArray3, 0, byArray4, n2 += 8, 4);
        n2 += 4;
        for (AccountEntry accountEntry : journalEntry.amounts) {
            byte[] byArray6 = AccountEntry.convertToBytes(accountEntry);
            byteBuffer.putInt(0, byArray6.length);
            System.arraycopy(byArray5, 0, byArray4, n2, 4);
            System.arraycopy(byArray6, 0, byArray4, n2 += 4, byArray6.length);
            n2 += byArray6.length;
        }
        byteBuffer.putInt(0, ((Object)object3).length);
        System.arraycopy(byArray5, 0, byArray4, n2, 4);
        System.arraycopy(object3, 0, byArray4, n2 += 4, ((Object)object3).length);
        return byArray4;
    }

    public static JournalEntry convertFromBytes(byte[] byArray) {
        JournalEntry journalEntry = Main.getDB().getJournal().newEntry(null, null);
        journalEntry.id = ByteBuffer.wrap(byArray, 0, 8).getLong();
        journalEntry.date = new Date(ByteBuffer.wrap(byArray, 8, 8).getLong());
        int n = ByteBuffer.wrap(byArray, 16, 4).getInt();
        int n2 = 20;
        for (int i = 0; i < n; ++i) {
            int n3 = ByteBuffer.wrap(byArray, n2, 4).getInt();
            byte[] byArray2 = new byte[n3];
            System.arraycopy(byArray, n2 += 4, byArray2, 0, byArray2.length);
            journalEntry.add(AccountEntry.convertFromBytes(byArray2));
            n2 += byArray2.length;
        }
        byte[] byArray3 = new byte[ByteBuffer.wrap(byArray, n2, 4).getInt()];
        System.arraycopy(byArray, n2 += 4, byArray3, 0, byArray3.length);
        journalEntry.description = new String(byArray3);
        return journalEntry;
    }

    JournalEntry(Journal journal, long l, Date date, String string) {
        this.journal = journal;
        this.id = l;
        this.date = date;
        this.description = string;
    }

    public long getID() {
        return this.id;
    }

    public Date getDate() {
        return this.date;
    }

    public String getDescription() {
        return this.description;
    }

    public List<AccountEntry> getAmounts() {
        return Collections.unmodifiableList(this.amounts);
    }

    public Status add(AccountEntry accountEntry) {
        if (!this.isNew) {
            return NOT_NEW;
        }
        if (accountEntry == null) {
            return Status.ERROR;
        }
        accountEntry.entry = this;
        this.amounts.add(accountEntry);
        return Status.OK;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class IDComparator<T extends JournalEntry>
    implements Comparator<T> {
        @Override
        public int compare(T t, T t2) {
            if (t == null || t2 == null) {
                throw new NullPointerException();
            }
            return new Long(((JournalEntry)t).id).compareTo(((JournalEntry)t2).id);
        }

        @Override
        public boolean equals(Object object) {
            return object != null && this.getClass() == object.getClass();
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class DateComparator<T extends JournalEntry>
    implements Comparator<T> {
        @Override
        public int compare(T t, T t2) {
            if (t == null || t2 == null) {
                throw new NullPointerException();
            }
            if (t == t2) {
                return 0;
            }
            int n = ((JournalEntry)t).date.compareTo(((JournalEntry)t2).date);
            if (n != 0) {
                return n;
            }
            return new Long(((JournalEntry)t).id).compareTo(new Long(((JournalEntry)t2).id));
        }

        @Override
        public boolean equals(Object object) {
            return object != null && this.getClass() == object.getClass();
        }
    }
}

