/*
 * Decompiled with CFR 0.152.
 */
package finance;

import finance.Account;
import finance.AccountType;
import finance.FinancialDatabase;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.TreeMap;
import javax.swing.event.TableModelEvent;
import javax.swing.event.TableModelListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeModel;
import javax.swing.tree.TreeNode;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class Ledger {
    DefaultTreeModel dataModel = new DefaultTreeModel(new DefaultMutableTreeNode(), false);
    private LinkedList<Account> accounts = new LinkedList();
    private FinancialDatabase DB = null;

    Ledger(FinancialDatabase financialDatabase) {
        this.DB = financialDatabase;
    }

    public List<Account> getAccounts() {
        return Collections.unmodifiableList(this.accounts);
    }

    void addAccountType(AccountType accountType) {
        DefaultMutableTreeNode defaultMutableTreeNode = (DefaultMutableTreeNode)this.dataModel.getRoot();
        this.dataModel.insertNodeInto(new AccountTypeNode(accountType), defaultMutableTreeNode, this.dataModel.getChildCount(defaultMutableTreeNode));
    }

    void removeAccountType(AccountType accountType) {
        AccountTypeNode accountTypeNode = AccountTypeNode.map.get(accountType.getName());
        this.dataModel.removeNodeFromParent(accountTypeNode);
        AccountTypeNode.map.remove(accountType.getName());
    }

    void addOrUpdate(Account account) {
        if (account == null) {
            return;
        }
        this.removeAccount(account.getID());
        this.addAccount(account);
    }

    void addAccount(Account account) {
        this.accounts.add(account);
        AccountTypeNode accountTypeNode = AccountTypeNode.map.get(account.getType().getName());
        AccountNode accountNode = new AccountNode(this, account);
        int n = this.insertIndex(accountTypeNode, accountNode);
        this.dataModel.insertNodeInto(accountNode, accountTypeNode, n);
    }

    private int insertIndex(TreeNode treeNode, AccountNode accountNode) {
        int n = 0;
        for (int i = 0; i < treeNode.getChildCount(); ++i) {
            if (!(treeNode.getChildAt(i) instanceof AccountNode)) continue;
            AccountNode accountNode2 = (AccountNode)treeNode.getChildAt(i);
            if (accountNode2.data.getName().compareTo(accountNode.data.getName()) >= 0) break;
            ++n;
        }
        return n;
    }

    void removeAccount(Account account) {
        this.accounts.remove(account);
        AccountNode accountNode = AccountNode.map.get(account.getID());
        this.dataModel.removeNodeFromParent(accountNode);
        AccountNode.map.remove(account.getID());
    }

    void removeAccount(int n) {
        for (Account account : this.accounts) {
            if (account.getID() != n) continue;
            this.removeAccount(account);
            break;
        }
    }

    public TreeModel getDataModel() {
        return this.dataModel;
    }

    public static class AccountNode
    extends DefaultMutableTreeNode
    implements TableModelListener {
        static TreeMap<Integer, AccountNode> map = new TreeMap();
        private Ledger ledger = null;
        private Account data = null;

        private AccountNode(Ledger ledger, Account account) {
            this.ledger = ledger;
            this.data = account;
            map.put(this.data.getID(), this);
            this.data.getDataModel().addTableModelListener(this);
        }

        public Account getData() {
            return this.data;
        }

        public boolean isLeaf() {
            return true;
        }

        public String toString() {
            String string = String.format("%.2f", this.data.getBalance().getValue());
            if (this.data.getBalance().getType() != this.data.getType().getNormalBalance()) {
                string = "(" + string + ")";
            }
            if ("".equals(this.data.getNumber())) {
                return String.format("%s  [Balance: %s]", this.data.getName(), string);
            }
            return String.format("%s  [%s]  Balance: %s", this.data.getNumber(), this.data.getName(), string);
        }

        public void tableChanged(TableModelEvent tableModelEvent) {
            this.ledger.dataModel.nodeChanged(this);
        }
    }

    public static class AccountTypeNode
    extends DefaultMutableTreeNode {
        static TreeMap<String, AccountTypeNode> map = new TreeMap();
        AccountType data = null;

        private AccountTypeNode(AccountType accountType) {
            this.data = accountType;
            map.put(this.data.getName(), this);
        }

        public AccountType getData() {
            return this.data;
        }

        public boolean isLeaf() {
            return false;
        }

        public String toString() {
            return this.data.getName();
        }
    }
}

