/*
 * Decompiled with CFR 0.152.
 */
package gui;

import finance.Account;
import finance.AccountEntry;
import gui.Constants;
import gui.Main;
import java.awt.Component;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.SystemColor;
import java.util.Date;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.border.Border;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumn;

public final class AccountComponent
extends JPanel {
    JTable table = null;
    Account account = null;

    public AccountComponent(Account account) {
        this.account = account;
        this.setLayout(new GridLayout(1, 1));
        this.table = new JTable(account.getDataModel());
        this.table.setSelectionMode(0);
        this.table.getTableHeader().setReorderingAllowed(false);
        for (int i = 0; i < this.table.getColumnCount(); ++i) {
            TableColumn tableColumn = this.table.getColumnModel().getColumn(i);
            tableColumn.setCellRenderer(new CellRenderer());
            tableColumn.setResizable(false);
        }
        this.setColumnWidths();
        this.add(new JScrollPane(this.table));
        this.table.scrollRectToVisible(this.table.getCellRect(this.table.getRowCount() - 1, 0, true));
    }

    private void setColumnWidths() {
        Date date = null;
        String string = "26 Nov 2005";
        try {
            date = Constants.dateShort.parse("26 Nov 2005");
            string = Constants.dateShort.format(date);
        }
        catch (Exception exception) {
            // empty catch block
        }
        String string2 = "$90,000.00";
        int n = 0;
        int n2 = 0;
        TableColumn tableColumn = null;
        try {
            Graphics2D graphics2D = Main.instance.getGraphicsConfiguration().createCompatibleImage(1, 1).createGraphics();
            n = (int)this.table.getFont().getStringBounds(string, graphics2D.getFontRenderContext()).getWidth();
            n2 = (int)this.table.getFont().getStringBounds(string2, graphics2D.getFontRenderContext()).getWidth();
        }
        catch (Exception exception) {
            return;
        }
        n = (int)((double)n * 1.3);
        n2 = (int)((double)n2 * 1.3);
        tableColumn = this.table.getColumnModel().getColumn(0);
        tableColumn.setMinWidth(n);
        tableColumn.setMaxWidth(n);
        tableColumn = this.table.getColumnModel().getColumn(2);
        tableColumn.setMinWidth(n2);
        tableColumn.setMaxWidth(n2);
        tableColumn = this.table.getColumnModel().getColumn(3);
        tableColumn.setMinWidth(n2);
        tableColumn.setMaxWidth(n2);
        tableColumn = this.table.getColumnModel().getColumn(4);
        tableColumn.setMinWidth(n2);
        tableColumn.setMaxWidth(n2);
    }

    private static class CellRenderer
    extends JLabel
    implements TableCellRenderer {
        protected static Border selectedBorder = BorderFactory.createMatteBorder(1, 0, 1, 0, SystemColor.textHighlight);
        protected static Border unselectedBorder = BorderFactory.createEmptyBorder(1, 0, 1, 0);

        public CellRenderer() {
            this.setOpaque(true);
        }

        public Component getTableCellRendererComponent(JTable jTable, Object object, boolean bl, boolean bl2, int n, int n2) {
            if (bl) {
                this.setBorder(selectedBorder);
            } else {
                this.setBorder(unselectedBorder);
            }
            this.setBackground(n % 2 == 0 ? Constants.bgRowEven : Constants.bgRowOdd);
            this.setFont(jTable.getFont());
            if (n2 >= 2) {
                this.setHorizontalAlignment(4);
            } else {
                this.setHorizontalAlignment(2);
            }
            if (object instanceof AccountEntry) {
                AccountEntry accountEntry = (AccountEntry)object;
                switch (n2) {
                    case 0: {
                        this.setText(Constants.dateShort.format(accountEntry.getDate()));
                        break;
                    }
                    case 1: {
                        this.setText(accountEntry.getDescription());
                        break;
                    }
                    case 2: {
                        this.setText(accountEntry.getDebit());
                        break;
                    }
                    case 3: {
                        this.setText(accountEntry.getCredit());
                        break;
                    }
                    case 4: {
                        if (accountEntry.getBalanceType() != accountEntry.getBalance().getType()) {
                            this.setBackground(Constants.bgBalanceAbnormal);
                        }
                        this.setText(accountEntry.getBalanceString());
                        break;
                    }
                    default: {
                        this.setText("");
                        break;
                    }
                }
            } else {
                this.setText("");
            }
            return this;
        }
    }
}

