/*
 * Decompiled with CFR 0.152.
 */
package gui;

import finance.Account;
import finance.AccountType;
import finance.Ledger;
import gui.ActionHandler;
import gui.Main;
import gui.dialog.AccountDialog;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JButton;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.TreePath;

public final class LedgerComponent
extends JPanel {
    Ledger ledger = null;
    JTree tree = null;
    private JButton buttonAdd = new JButton("Add Account");
    private JButton buttonEdit = new JButton("Edit Account");
    private JButton buttonDelete = new JButton("Delete Account");

    public LedgerComponent(Ledger ledger) {
        this.ledger = ledger;
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.tree = new JTree(ledger.getDataModel());
        this.tree.getSelectionModel().setSelectionMode(1);
        this.tree.addTreeSelectionListener(new SelectionHandler());
        this.tree.addMouseListener(new DblClickHandler(this.tree));
        this.tree.setRootVisible(false);
        gridBagConstraints.fill = 1;
        gridBagConstraints.anchor = 18;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.gridwidth = 0;
        gridBagConstraints.weighty = 1.0;
        this.add((Component)new JScrollPane(this.tree), gridBagConstraints);
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.weighty = 0.0;
        ButtonHandler buttonHandler = new ButtonHandler();
        this.buttonAdd.addActionListener(new ActionHandler(buttonHandler, "button_AddAccount_Handler"));
        this.add((Component)this.buttonAdd, gridBagConstraints);
        this.buttonEdit.addActionListener(new ActionHandler(buttonHandler, "button_EditAccount_Handler"));
        this.buttonEdit.setEnabled(false);
        this.add((Component)this.buttonEdit, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        this.buttonDelete.addActionListener(new ActionHandler(buttonHandler, "button_DeleteAccount_Handler"));
        this.buttonDelete.setEnabled(false);
        this.add((Component)this.buttonDelete, gridBagConstraints);
    }

    private class ButtonHandler {
        private ButtonHandler() {
        }

        public void button_AddAccount_Handler(ActionEvent actionEvent) {
            TreePath treePath = LedgerComponent.this.tree.getSelectionPath();
            if (treePath != null) {
                Object object = treePath.getLastPathComponent();
                if (object instanceof Ledger.AccountTypeNode) {
                    AccountDialog.showAdd(((Ledger.AccountTypeNode)object).getData());
                } else if (object instanceof Ledger.AccountNode) {
                    AccountDialog.showAdd(((Ledger.AccountNode)object).getData().getType());
                } else {
                    AccountDialog.showAdd();
                }
            } else {
                AccountDialog.showAdd();
            }
        }

        public void button_EditAccount_Handler(ActionEvent actionEvent) {
            Object object;
            TreePath treePath = LedgerComponent.this.tree.getSelectionPath();
            if (treePath != null && (object = treePath.getLastPathComponent()) instanceof Ledger.AccountNode) {
                AccountDialog.showEdit(((Ledger.AccountNode)object).getData());
            }
        }

        public void button_DeleteAccount_Handler(ActionEvent actionEvent) {
            TreePath treePath = LedgerComponent.this.tree.getSelectionPath();
            if (treePath == null) {
                return;
            }
            Object object = treePath.getLastPathComponent();
            if (object instanceof Ledger.AccountNode) {
                Account account = ((Ledger.AccountNode)object).getData();
                String string = "Are you sure you want to delete the selected account?";
                if (JOptionPane.showConfirmDialog(Main.instance, string, "Confirm Delete", 0, 3) == 0) {
                    Main.getDB().removeAccount(account);
                }
            } else if (object instanceof Ledger.AccountTypeNode) {
                AccountType accountType = ((Ledger.AccountTypeNode)object).getData();
                String string = "Are you sure you want to delete the selected account type?";
                if (JOptionPane.showConfirmDialog(Main.instance, string, "Confirm Delete", 0, 3) == 0) {
                    Main.getDB().removeAccountType(accountType);
                }
            }
        }
    }

    private class SelectionHandler
    implements TreeSelectionListener {
        private SelectionHandler() {
        }

        public void valueChanged(TreeSelectionEvent treeSelectionEvent) {
            TreePath treePath = LedgerComponent.this.tree.getSelectionPath();
            boolean bl = false;
            boolean bl2 = false;
            LedgerComponent.this.buttonDelete.setText("Delete Account");
            if (treePath != null) {
                Object object = treePath.getLastPathComponent();
                if (object instanceof Ledger.AccountNode) {
                    Account account = ((Ledger.AccountNode)object).getData();
                    bl = true;
                    if (account.getEntries().size() == 0) {
                        bl2 = true;
                    }
                } else if (object instanceof Ledger.AccountTypeNode) {
                    AccountType accountType = ((Ledger.AccountTypeNode)object).getData();
                    bl2 = true;
                    for (AccountType object2 : AccountType.getList()) {
                        if (!object2.getName().equals(accountType.getName())) continue;
                        bl2 = false;
                    }
                    for (Account account : LedgerComponent.this.ledger.getAccounts()) {
                        if (account.getType() != accountType) continue;
                        bl2 = false;
                        break;
                    }
                    if (bl2) {
                        LedgerComponent.this.buttonDelete.setText("Delete Account Type");
                    }
                }
            }
            LedgerComponent.this.buttonEdit.setEnabled(bl);
            LedgerComponent.this.buttonDelete.setEnabled(bl2);
        }
    }

    private static class DblClickHandler
    extends MouseAdapter {
        JTree tree;

        DblClickHandler(JTree jTree) {
            this.tree = jTree;
        }

        public void mousePressed(MouseEvent mouseEvent) {
            Object object;
            if (mouseEvent.getClickCount() < 2) {
                return;
            }
            TreePath treePath = this.tree.getPathForLocation(mouseEvent.getX(), mouseEvent.getY());
            if (treePath != null && (object = treePath.getLastPathComponent()) instanceof Ledger.AccountNode) {
                Main.instance.displayAccount(((Ledger.AccountNode)object).getData());
            }
        }
    }
}

