/*
 * Decompiled with CFR 0.152.
 */
package gui.dialog;

import gui.ActionHandler;
import gui.Main;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.event.ActionEvent;
import java.io.IOException;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JEditorPane;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import manual.Manual;

public class HelpDialog
extends JFrame {
    private static final HelpDialog instance = new HelpDialog();
    JEditorPane pane = new JEditorPane();

    public static void showIndex() {
        instance.loadFile("index.html");
        instance.setVisible(true);
    }

    public static void showContents() {
        instance.loadFile("contents.html");
        instance.setVisible(true);
    }

    HelpDialog() {
        this.setDefaultCloseOperation(2);
        this.setTitle("Help for Double Entry Accounting Program");
        this.setSize(350, 400);
        this.setIconImage(new ImageIcon(Main.class.getResource("icon.png")).getImage());
        this.setLayout(new GridBagLayout());
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.fill = 1;
        JButton jButton = new JButton("Index");
        jButton.addActionListener(new ActionHandler(this, "button_Index_Handler"));
        this.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.gridwidth = 0;
        jButton = new JButton("Contents");
        jButton.addActionListener(new ActionHandler(this, "button_Contents_Handler"));
        this.add((Component)jButton, gridBagConstraints);
        gridBagConstraints.weighty = 1.0;
        this.add((Component)new JScrollPane(this.pane), gridBagConstraints);
        this.pane.setEditable(false);
        this.pane.addHyperlinkListener(new Linker(this.pane));
    }

    private void loadFile(String string) {
        try {
            HelpDialog.instance.pane.setPage(Manual.class.getResource(string));
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void button_Index_Handler(ActionEvent actionEvent) {
        this.loadFile("index.html");
    }

    public void button_Contents_Handler(ActionEvent actionEvent) {
        this.loadFile("contents.html");
    }

    private static class Linker
    implements HyperlinkListener {
        JEditorPane source = null;

        Linker(JEditorPane jEditorPane) {
            this.source = jEditorPane;
        }

        public void hyperlinkUpdate(HyperlinkEvent hyperlinkEvent) {
            if (hyperlinkEvent.getEventType() == HyperlinkEvent.EventType.ACTIVATED) {
                try {
                    this.source.setPage(hyperlinkEvent.getURL());
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

