using System;
using System.Data;
using System.Configuration;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

/// <summary>
/// Object that holds all relevent information for a plant.
/// </summary>
public class Plant
{
    #region Private Variables
    private static int BIOMASS = 0;
    private static int DDM = 1;
    private static int DP = 2;
    private static int NDF = 3;
    private static int TIME = 4;

    private string id;
    private string forage;
    private Single wa;
    private Single wb;
    private Single wc;
    private Single wd;
    private Single ddma;
    private Single ddmb;
    private Single dpa;
    private Single dpb;
    private Single ndfa;
    private Single ndfb;
    private Single mtb;

    #endregion

    //this is public for now until i get around to encapsulating it.
    public double[,] StemDensities = new double[8,3];

    //calculated plants will hold the calculated values for each stem size of the plant.
    //8 stems sizes each having a total biomass, %ddm, %dp, %ndf, and a time value;
    public double[,] CalculatedNutritionalValues = new double[8, 5];
    public double[] PercentageUsed = new double[8];
    public double[] biomassUsed = new double[8];
    public double[] timeEating = new double[8];
    public double[] percentTotal = new double[8];

    public double[] StemDiameters;

    #region Public Properties
    public string ID
    {
        get
        { return id; }
        set
        { id = value; }
    }
    public string Forage
    {
        get
        { return forage; }
        set
        { forage = value; }
    }
    public float WA
    {
        get
        { return wa; }
        set
        { wa = value; }
    }
    public float WB
    {
        get
        { return wb; }
        set
        { wb = value; }
    }
    public float WC
    {
        get
        { return wc; }
        set
        { wc = value; }
    }
    public float WD
    {
        get
        { return wd; }
        set
        { wd = value; }
    }
    public float DDMA
    {
        get
        { return ddma; }
        set
        { ddma = value; }
    }
    public float DDMB
    {
        get
        { return ddmb; }
        set
        { ddmb = value; }
    }
    public float DPA
    {
        get
        { return dpa; }
        set
        { dpa = value; }
    }
    public float DPB
    {
        get
        { return dpb; }
        set
        { dpb = value; }
    }
    public float NDFA
    {
        get
        { return ndfa; }
        set
        { ndfa = value; }
    }
    public float NDFB
    {
        get
        { return ndfb; }
        set
        { ndfb = value; }
    }
    public float MTB
    {
        get
        { return mtb; }
        set
        { mtb = value; }
    }
 /*   public int SNOWDEPTH
    {
        get
        { return snowdepth; }
        set
        { snowdepth = value; }
    }
    public double ANIMALBM
    {
        get
        { return animalBM; }
        set
        { animalBM = value; }
    }*/
    #endregion

    #region Constructors
    public Plant()
	{
        StemDensities = new double[8, 3];

        StemDiameters = new double[8];
        StemDiameters[0] = 0.5;
        StemDiameters[1] = 1.5;
        StemDiameters[2] = 2.5;
        StemDiameters[3] = 3.5;
        StemDiameters[4] = 4.5;
        StemDiameters[5] = 5.5;
        StemDiameters[6] = 6.5;
        StemDiameters[7] = 7.5;

    }

    public Plant(string pID, string pForage, float pWA, float pWB, float pWC, float pWD, float pDDMA, float pDDMB, float pDPA, float pDPB, float pNDFA, float pNDFB, float pMTB)
    {
        ID = pID ;
        Forage = pForage;
        WA = pWA;
        WB = pWB;
        WC = pWC;
        WD = pWD;
        DDMA = pDDMA;
        DDMB = pDDMB;
        DPA = pDPA;
        DPB = pDPB;
        NDFA = pNDFA;
        NDFB = pNDFB;
        MTB = pMTB;

        StemDensities = new double[8, 3];

        StemDiameters = new double[8];
        StemDiameters[0] = 0.5;
        StemDiameters[1] = 1.5;
        StemDiameters[2] = 2.5;
        StemDiameters[3] = 3.5;
        StemDiameters[4] = 4.5;
        StemDiameters[5] = 5.5;
        StemDiameters[6] = 6.5;
        StemDiameters[7] = 7.5;
    }
    #endregion
    #region CalculationMethods
    //calculates diameter at browse point

    public void MakeCalculations(double mooseBodyMass, int snowdepth)
    {
        for (int k = 0; k < StemDiameters.GetLength(0); k++)
        {
            double StemDensPerLayer = 0.0; //Combined stem density of all layers for stem size k
            double StemMass;         //The mass for stem size k
            double DatBP;            //The diameter at browse point for stem size k

            //gets the Diameter at Browse Point for the stem size
            DatBP = DiamAtBrowsePoint(StemDiameters[k]);

            //calculates the total density of a size based on snow depth.
            switch (snowdepth){
                case 1:
                    StemDensPerLayer = StemDensities[k , 0] + StemDensities[k , 1] + StemDensities[k , 2];
                    break;
                case 2:
                    StemDensPerLayer = (StemDensities[k, 0] * .5) + StemDensities[k, 1] + StemDensities[k, 2];
                    break;
                case 3:
                    StemDensPerLayer = StemDensities[k, 1] + StemDensities[k, 2];
                    break;
            }


            StemMass = Stemmass(DatBP, WA, WB, WC, WD);

            //setting the biomass for stem size k
            CalculatedNutritionalValues[k, BIOMASS] = StemBiomass(StemMass, StemDensPerLayer);
            //setting the dmm for stem size k
            CalculatedNutritionalValues[k, DDM] = StemDDM(DatBP, DDMA, DDMB);
            //setting the dp for stem size k
            CalculatedNutritionalValues[k, DP] = StemDP(DatBP, DPA, DPB);
            //setting the ndf for stem size k
            CalculatedNutritionalValues[k, NDF] = StemNDF(DatBP, NDFA, NDFB);
            //setting the time for stem size k
            CalculatedNutritionalValues[k, TIME] = TimetoEat(mooseBodyMass, CalculatedNutritionalValues[k, 3], StemMass);

        }

    }
    protected double DiamAtBrowsePoint(double stemDiam)
    {
        return (Math.Pow(stemDiam, 3.0) * (-0.00197)) + (Math.Pow(stemDiam, 2.0) * (-0.00427)) + (stemDiam * 0.8605) - (0.0395);
    }

    //stem mass
    protected double Stemmass(double DiamAtBrowsePoint, double McoefA, double McoefB, double McoefC, double McoefD)
    {
        double calculatedStemMass = (McoefA * Math.Pow(DiamAtBrowsePoint, 3)) + (McoefB * Math.Pow(DiamAtBrowsePoint, 2)) + (McoefC * DiamAtBrowsePoint) + (McoefD);

        if (calculatedStemMass <= 0)
        {
            return 0.01;
        }
        else
        {
            return calculatedStemMass;
        }
    }

    //stem Nuetral Detergent Fiber
    protected double StemNDF(double DiamAtBrowsePoint, double NDFcoefA, double NDFcoefB)
    {
        return (NDFcoefA * Math.Pow(DiamAtBrowsePoint, NDFcoefB));
    }

    //percent digestible protein
    protected double StemDP(double DiamAtBrowsePoint, double DPcoefA, double DPcoefB)
    {
        return (DPcoefA * Math.Pow(DiamAtBrowsePoint, DPcoefB));
    }
    //percent digestible dry matter
    protected double StemDDM(double DiamAtBrowsePoint, double DDMcoefA, double DDMcoefB)
    {
        return (DDMcoefA * Math.Pow(DiamAtBrowsePoint, DDMcoefB));
    }
    //stem biomass
    protected double StemBiomass(double stemMass, double StemDens)
    {
        return (stemMass * 10.0 * StemDens);
    }
    protected double TimetoEat(double aBM, double sNDF, double sMass)
    {
        //        return ((((Math.Pow(aBM,0.7)*0.263) / (sNDF/100))*.03 + sMass)/ ((Math.Pow(aBM,0.7)*0.263)/(sNDF/100)))/sMass;
        // changed since sNDF is already a percent
        return ((((Math.Pow(aBM,0.7)*0.263) / (sNDF))*.03 + sMass)/ ((Math.Pow(aBM,0.7)*0.263)/(sNDF)))/sMass;
    }
    #endregion
}
