using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;
using System.Collections.Generic;
using lpsolve55;


public partial class _Default : System.Web.UI.Page
{

    List<Plant> forageList;
    string[] animalConstraints;
    DataTable plantTable;

    protected void Page_Load(object sender, EventArgs e)
    {
        //forageList = (List<Plant>)Session["forageList"];
        forageList = (List<Plant>)Session["WorkingPlants"];

        if (!IsPostBack)
        {
            plants.DataSource = plantTable;
            plants.DataBind();

            //Sets the values back to the previously used values
            //These values are set every time the user clicks the calculate button
            if (Session["AnimalConstraints"] != null)
            {
                animalConstraints = (string[]) Session["AnimalConstraints"];

                AnimalDMI.Text = animalConstraints[0];
                AnimalDDM.Text = animalConstraints[1];
                AnimalDP.Text = animalConstraints[2];
                AnimalTime.Text = animalConstraints[3];
                AnimalBM.Text = animalConstraints[4];
            }
        }

    }
    protected void CalcMooseDays(object sender, EventArgs e)
    {
        double[] animalArray = new double[5];
        double[] plantPart;

        double mooseDays;
        double foragingTime;
        double totalBiomassConsumed = 0.0;
        double totalTimeTaken = 0.0;

        //I realize setting up a try over all this stuff is rediculous, but i'm making a last minute fix, so fix it if you want,
        //but it works.
        try
        {
            //used to pass to LinearCalculations///
            animalArray[0] = double.Parse(AnimalDDM.Text);
            animalArray[1] = double.Parse(AnimalDP.Text);
            animalArray[2] = 0.0;
            animalArray[3] = 1.0;
            animalArray[4] = double.Parse(AnimalTime.Text) / double.Parse(AnimalDMI.Text);


            animalConstraints = new string[6];
            animalConstraints[0] = AnimalDMI.Text;
            animalConstraints[1] = AnimalDDM.Text;
            animalConstraints[2] = AnimalDP.Text;
            animalConstraints[3] = AnimalTime.Text;
            animalConstraints[4] = AnimalBM.Text;
            animalConstraints[5] = snowDepthMenu.DataTextField;

            if (Session["AnimalConstraints"] == null)
            {
                Session.Add("AnimalConstraints", animalConstraints);
            }
            else
            {
                Session["AnimalConstraints"] = animalConstraints;
            }
            //

            //makes the algebraic calculations within each Plant for biomass, dp, ddm, ndf, and time
            for (int i = 0; i < forageList.Count; i++)
            {
                forageList[i].MakeCalculations(double.Parse(AnimalBM.Text), int.Parse(snowDepthMenu.SelectedValue));
            }

            //call the static method "getPlantPart" which in turn calls lpsolve
            plantPart = LinearCalculations.getPlantPart(forageList, animalArray, true);


            //this is plain out silly, but untill "getPlantPart" is modified to take in a list of Plant, we have to bring back the array of percentages
            //and divide the percentages up among the Plant objects accordingly.
            int z = 0;
            foreach (Plant thePlant in forageList)
            {

                for (int y = 0; y < 8; y++)
                {
                    thePlant.PercentageUsed[y] = plantPart[z];

                    //biomass used = (the biomass available) * (percentage of biomass used)
                    thePlant.biomassUsed[y] = thePlant.CalculatedNutritionalValues[y, 0] * plantPart[z];
                    totalBiomassConsumed += thePlant.biomassUsed[y];

                    //time eating = (biomass used) * (time) * 1000 
                    thePlant.timeEating[y] = thePlant.biomassUsed[y] * thePlant.CalculatedNutritionalValues[y, 4] * 1000;
                    totalTimeTaken += thePlant.timeEating[y];

                    z++;

                }
            }

            //array of values created to display what stem size we're referring to
            string[] stemsizes = new string[8];
            stemsizes[0] = "0-1mm";
            stemsizes[1] = "1-2mm";
            stemsizes[2] = "2-3mm";
            stemsizes[3] = "3-4mm";
            stemsizes[4] = "4-5mm";
            stemsizes[5] = "5-6mm";
            stemsizes[6] = "6-7mm";
            stemsizes[7] = "7+mm";

            // creates the table to store the calculated values

            plantTable = new DataTable();

            plants.DataSource = plantTable;

            plantTable.Columns.Add().ColumnName = "ID";
            plantTable.Columns.Add().ColumnName = "Forage";
            plantTable.Columns.Add().ColumnName = "Max Biomass (%)";
            plantTable.Columns.Add().ColumnName = "Stem Size";
            plantTable.Columns.Add().ColumnName = "Biomass (kg/ha)";
            plantTable.Columns.Add().ColumnName = "DDM (%)";
            plantTable.Columns.Add().ColumnName = "DP (%)";
            plantTable.Columns.Add().ColumnName = "Time (min/g)";
            plantTable.Columns.Add().ColumnName = "Percent Used (%)";
            plantTable.Columns.Add().ColumnName = "Biomass Used (kg/ha)";
            plantTable.Columns.Add().ColumnName = "Time Eating (min)";
            plantTable.Columns.Add().ColumnName = "Percent of Total (%)";

            foreach (Plant thePlant in forageList)
            {
                //thePlant.MakeCalculations(double.Parse(AnimalBM.Text), int.Parse(snowDepthMenu.SelectedValue));

                for (int y = 0; y < 8; y++)
                {
                    DataRow workRow = plantTable.NewRow();

                    if (y == 0)
                    {
                        //first row gets the id and name assigned to it
                        workRow[0] = thePlant.ID;
                        workRow[1] = thePlant.Forage;
                        workRow[2] = thePlant.MTB * 100;
                    }
                    workRow[3] = stemsizes[y]; //displays the stem size we're working with
                    workRow[4] = Math.Round(thePlant.CalculatedNutritionalValues[y, 0], 4); //biomass
                    workRow[5] = Math.Round(thePlant.CalculatedNutritionalValues[y, 1], 4); //digestible dry matter
                    workRow[6] = Math.Round(thePlant.CalculatedNutritionalValues[y, 2], 4); //digestible protein
                    workRow[7] = Math.Round(thePlant.CalculatedNutritionalValues[y, 4], 4); //time
                    workRow[8] = Math.Round(thePlant.PercentageUsed[y] * 100, 2);//percent of biomass consumed
                    workRow[9] = Math.Round(thePlant.biomassUsed[y], 4); //biomass consumed
                    workRow[10] = Math.Round(thePlant.timeEating[y], 4); //time spent eating
                    if (thePlant.biomassUsed[y] != 0)
                    {
                        workRow[11] = Math.Round((thePlant.biomassUsed[y] / totalBiomassConsumed) * 100, 2); //percent of diet
                    }
                    else
                    {
                        workRow[11] = 0;
                    }

                    plantTable.Rows.Add(workRow);

                }
                plantTable.AcceptChanges();
                plants.DataBind();

            }
            mooseDays = ((totalBiomassConsumed - 0) / (double.Parse(AnimalDMI.Text))) * 1000;
            lblmooseD.Text = "Moose Days: " + (Math.Round(Math.Max(0, mooseDays), 1));

            if (totalTimeTaken != 0)
            {
                foragingTime = (totalTimeTaken / totalBiomassConsumed) * (double.Parse(AnimalDMI.Text) / 1000);
            }
            else
            {
                foragingTime = 0;
            }
            lbltimeEating.Text = "Total Daily Forage Time: " + Convert.ToString(Math.Round(Math.Max(0, foragingTime), 1)) + " minutes";

            errorlbl.Text = ""; //if we make it all the way through, we'll set this to empty, since if it had anything in it, they fixed it.
        }
        catch (FormatException ex)
        {
            errorlbl.Text = "All animal constraints must be entered";
            return;

        }

    }
    protected void startOver(object sender, EventArgs e)
    {
        Session["WorkingPlants"] = null;
        Response.Redirect("Forage.aspx");
    }
    protected void backBtn_Click(object sender, EventArgs e)
    {
        Session["WorkingPlants"] = forageList;
        animalConstraints = new string[6];
        animalConstraints[0] = AnimalDMI.Text;
        animalConstraints[1] = AnimalDDM.Text;
        animalConstraints[2] = AnimalDP.Text;
        animalConstraints[3] = AnimalTime.Text;
        animalConstraints[4] = AnimalBM.Text;
        animalConstraints[5] = snowDepthMenu.DataTextField;
        Session["AnimalConstraints"] = animalConstraints;

        Response.Redirect("ForageParameters.aspx");
    }
}
