using System;
using System.Data;
using System.Configuration;
using System.Collections;
using System.Collections.Generic;
using System.Web;
using System.Web.Security;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.UI.WebControls.WebParts;
using System.Web.UI.HtmlControls;

public partial class Forage : System.Web.UI.Page
{
    private List<Plant> workingPlants;
    protected void Page_Load(object sender, EventArgs e)
    {
        //Basically checks to see if we have a workingplants set, and if not we add one.
        if (!IsPostBack)
        {
            Session.Timeout = 15;
            workingPlants = new List<Plant>();
            if (Session["WorkingPlants"] == null)
                Session.Add("WorkingPlants", workingPlants);
            else
                Session["WorkingPlants"] = workingPlants;
        }
        else
        {
            workingPlants = (List<Plant>)Session["WorkingPlants"];
        }
    }
    //When we select a Plant from the first gridview, we add it to the working set
    protected void GridView1_SelectedIndexChanged(object sender, EventArgs e)
    {
        int i = GridView1.SelectedIndex;
        Plant tempPlant = new Plant();
        tempPlant.ID = GridView1.Rows[i].Cells[2].Text;
        tempPlant.Forage = GridView1.Rows[i].Cells[3].Text;
        tempPlant.WA = float.Parse(GridView1.Rows[i].Cells[4].Text);
        tempPlant.WB = float.Parse(GridView1.Rows[i].Cells[5].Text);
        tempPlant.WC = float.Parse(GridView1.Rows[i].Cells[6].Text);
        tempPlant.WD = float.Parse(GridView1.Rows[i].Cells[7].Text);
        tempPlant.DDMA = float.Parse(GridView1.Rows[i].Cells[8].Text);
        tempPlant.DDMB = float.Parse(GridView1.Rows[i].Cells[9].Text);
        tempPlant.DPA = float.Parse(GridView1.Rows[i].Cells[10].Text);
        tempPlant.DPB = float.Parse(GridView1.Rows[i].Cells[11].Text);
        tempPlant.NDFA = float.Parse(GridView1.Rows[i].Cells[12].Text);
        tempPlant.NDFB = float.Parse(GridView1.Rows[i].Cells[13].Text);
        tempPlant.MTB = float.Parse(GridView1.Rows[i].Cells[14].Text);

        workingPlants.Add(tempPlant);

        GridView2.DataSource = workingPlants;
        GridView2.DataBind();

        errorlbl.ForeColor = System.Drawing.Color.Black;
        errorlbl.Visible = false;

        if (Session["WorkingPlants"] != null)
            Session["WorkingPlants"] = workingPlants;
        else
            Session.Add("WorkingPlants", workingPlants);
    }

    //deletes a row from the workingplants set
    protected void GridView2_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        workingPlants = (List<Plant>)Session["WorkingPlants"];
        workingPlants.RemoveAt(e.RowIndex);
        Session["WorkingPlants"] = workingPlants;
        if (workingPlants.Count == 0)
        {
            errorlbl.Visible = true;
        }
        GridView2.DataSource = workingPlants;
        GridView2.DataBind();
    }

    //When a user clicks the continue button, a list of plants is created for the next step.
    protected void cb_next_Click(object sender, EventArgs e)
    {
        if (GridView2.Rows.Count < 1)
        {
            errorlbl.ForeColor = System.Drawing.Color.Red;
            return;

        }
        else
        {
            errorlbl.Text = "";
        }
        List<Plant> selectedForageList = new List<Plant>();

        for (int i = 0; i < GridView2.Rows.Count; i++)
        {
            //Loads a list of plant objects to move to the next step. The Plant part is loaded directly from the
            //working gridview since users could have edited values.
            Plant tempPlant = new Plant();
            tempPlant.ID = GridView2.Rows[i].Cells[1].Text;
            tempPlant.Forage = GridView2.Rows[i].Cells[2].Text;
            tempPlant.WA = float.Parse(GridView2.Rows[i].Cells[3].Text);
            tempPlant.WB = float.Parse(GridView2.Rows[i].Cells[4].Text);
            tempPlant.WC = float.Parse(GridView2.Rows[i].Cells[5].Text);
            tempPlant.WD = float.Parse(GridView2.Rows[i].Cells[6].Text);
            tempPlant.DDMA = float.Parse(GridView2.Rows[i].Cells[7].Text);
            tempPlant.DDMB = float.Parse(GridView2.Rows[i].Cells[8].Text);
            tempPlant.DPA = float.Parse(GridView2.Rows[i].Cells[9].Text);
            tempPlant.DPB = float.Parse(GridView2.Rows[i].Cells[10].Text);
            tempPlant.NDFA = float.Parse(GridView2.Rows[i].Cells[11].Text);
            tempPlant.NDFB = float.Parse(GridView2.Rows[i].Cells[12].Text);
            tempPlant.MTB = float.Parse(GridView2.Rows[i].Cells[13].Text);

            //Stem Density information for the Plant of the particular Stand is then gathered.
            DataSet StemDenSet = ForageDAL.GetStemDensities(int.Parse(tempPlant.ID));

            if (StemDenSet != null)
            {
                DataRow tempRow = StemDenSet.Tables[0].Rows[0];

                tempPlant.StemDensities[0, 0] = double.Parse(tempRow[1].ToString());
                tempPlant.StemDensities[0, 1] = double.Parse(tempRow[2].ToString());
                tempPlant.StemDensities[0, 2] = double.Parse(tempRow[3].ToString());
                tempPlant.StemDensities[1, 0] = double.Parse(tempRow[4].ToString());
                tempPlant.StemDensities[1, 1] = double.Parse(tempRow[5].ToString());
                tempPlant.StemDensities[1, 2] = double.Parse(tempRow[6].ToString());
                tempPlant.StemDensities[2, 0] = double.Parse(tempRow[7].ToString());
                tempPlant.StemDensities[2, 1] = double.Parse(tempRow[8].ToString());
                tempPlant.StemDensities[2, 2] = double.Parse(tempRow[9].ToString());
                tempPlant.StemDensities[3, 0] = double.Parse(tempRow[10].ToString());
                tempPlant.StemDensities[3, 1] = double.Parse(tempRow[11].ToString());
                tempPlant.StemDensities[3, 2] = double.Parse(tempRow[12].ToString());
                tempPlant.StemDensities[4, 0] = double.Parse(tempRow[13].ToString());
                tempPlant.StemDensities[4, 1] = double.Parse(tempRow[14].ToString());
                tempPlant.StemDensities[4, 2] = double.Parse(tempRow[15].ToString());
                tempPlant.StemDensities[5, 0] = double.Parse(tempRow[16].ToString());
                tempPlant.StemDensities[5, 1] = double.Parse(tempRow[17].ToString());
                tempPlant.StemDensities[5, 2] = double.Parse(tempRow[18].ToString());
                tempPlant.StemDensities[6, 0] = double.Parse(tempRow[19].ToString());
                tempPlant.StemDensities[6, 1] = double.Parse(tempRow[20].ToString());
                tempPlant.StemDensities[6, 2] = double.Parse(tempRow[21].ToString());
                tempPlant.StemDensities[7, 0] = double.Parse(tempRow[22].ToString());
                tempPlant.StemDensities[7, 1] = double.Parse(tempRow[23].ToString());
                tempPlant.StemDensities[7, 2] = double.Parse(tempRow[24].ToString());
            }

            //tempPlant.StemDensities[0,0] = StemDenSet.Tables[0].Rows[0]

            selectedForageList.Add(tempPlant);
        }

        Session.RemoveAll();
        //Session.Add("forageList", selectedForageList);
        Session.Add("WorkingPlants", selectedForageList);

        Response.Redirect("ForageParameters.aspx");
    }
    //When we choose a different location from the menu, we need to grab the new stand list
    //for that location
    protected void LocationList_SelectedIndexChanged(object sender, EventArgs e)
    {
        StandList.DataBind();
    }
    //When we choose a different stand from the menu, we need to grab the new plant set from the database
    protected void StandList_SelectedIndexChanged(object sender, EventArgs e)
    {
        GridView1.DataBind();
    }
}
