using System;
using System.Collections;
using System.ComponentModel;
using System.Diagnostics;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

using System.IO;
using System.Reflection;
using System.Runtime.Remoting;
using System.Runtime.Remoting.Channels;
using System.Runtime.Remoting.Messaging;
using System.Threading;

using Shared.Channels;
using Shared.Channels.GenuineTcp;
using Shared.Channels.BroadcastEngine;
using Shared.Channels.DotNetRemotingLayer;

namespace Console
{
    public partial class DialogMain : Form, IBroadcastMessenger
    {
        private delegate void ViewBroadcastHeartBeatCallback(Object message, String nickname);
        private static Shared.XML.SnapShot.Objects.Service.Trampoline trampolineConfig;
        
        private static String Nickname = Assembly.GetExecutingAssembly().GetName().Name;
        public static IBroadcastIt BroadcastIt;
        private static IBroadcastServer iBroadcastServer;
        private static Object IBroadcastItLock = new Object();

        private static DialogProgressBar progress;
        private static TreeNode currentnode;
        private static ArrayList processes;
        private static ArrayList profiles;

        public DialogMain()
        {
            InitializeComponent();
            PopulateTrampolinedProcesses();
            PopulateProcessToolStripMenu();
            PopulateProfileComboBox();

            try
            {
                // Setup remoting with assembly objects as remote object.
                IDictionary props = new Hashtable();
                props["name"] = "gtcpd";
                props["prefix"] = "gtcpd";
                props["priority"] = "100";
                props["port"] = "0";

                GenuineTcpChannel channel = new GenuineTcpChannel(props, null, null);
                ChannelServices.RegisterChannel(channel, false);
                WellKnownClientTypeEntry remotetype = new WellKnownClientTypeEntry(typeof(Shared.Channels.GenuineTcp.GenuineTcpChannel), "gtcpd://127.0.0.1:48889/Messenger");
                RemotingConfiguration.RegisterWellKnownClientType(remotetype);

                // Bind client's receiver.
                RemotingServices.Marshal(this, "Messenger");

                // Subscribe to the chat event.
                lock (IBroadcastItLock)
                {
                    iBroadcastServer = (IBroadcastServer)Activator.GetObject(typeof(IBroadcastIt), "gtcpd://127.0.0.1:48889/Server");
                    BroadcastIt = iBroadcastServer.JoinDialog(Nickname);
                }
            }
            catch (Exception ex)
            {
                EventLog evtLog = new EventLog("Application", ".", "Ludus Delegate");
                StringBuilder evtEntry = new StringBuilder("Console::DialogMain()");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();

                DialogNotice notice = new DialogNotice(String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                notice.ShowDialog(this);
            }

            DisplayProgressBar(3000, "Synchronizing with Ludus services...");
        }
        public void ViewBroadcastHeartBeat(Object message, String nickname)
        {
            try
            {
/*
                if (message.GetType().Equals(typeof(Shared.SnapShot.Messages.Element)))
                {
                    Shared.SnapShot.Messages.Element msg = (Shared.SnapShot.Messages.Element)message;

                    if (msg.action.Equals("HEARTBEAT"))
                    {
                        TreeNode hwnd = treeView.Nodes[msg.pid.ToString()];
                        TreeNode layout = hwnd.Nodes[msg.hwnd.ToString()];

                        if (msg.value.Equals(String.Empty))
                        {
                            layout.Nodes.RemoveByKey(msg.key.ToString());
                        }
                        else if (layout.Nodes.ContainsKey(msg.key.ToString()))
                        {
                            (layout.Nodes[msg.key.ToString()]).Text = msg.id + " \"" + msg.value + "\"";
                        }
                        else
                        {
                            layout.Nodes.Add(msg.key.ToString(), msg.id + " \"" + msg.value + "\"");
                            (layout.Nodes[msg.key.ToString()]).Tag = "LAYOUT";

                            treeView.Sort();
                            treeView.ExpandAll();
                        }
                    }
                }
*/
                if (message.GetType().Equals(typeof(Shared.SnapShot.Messages.Client)))
                {
                    Shared.SnapShot.Messages.Client msg = (Shared.SnapShot.Messages.Client)message;

                    if (msg.action.Equals("HEARTBEAT"))
                    {
                        TreeNode hwnd = treeView.Nodes[msg.pid.ToString()];

                        if (msg.caption.Equals(String.Empty))
                        {
                            hwnd.Nodes.RemoveByKey(msg.hwnd.ToString());
                        }
                        else if (hwnd.Nodes.ContainsKey(msg.hwnd.ToString()))
                        {
                            (hwnd.Nodes[msg.hwnd.ToString()]).Text = msg.caption;
                        }
                        else
                        {
                            hwnd.Nodes.Add(msg.hwnd.ToString(), msg.caption);
                            Shared.Console.Messages.Client client = new Shared.Console.Messages.Client("CLIENT", msg.pid, msg.hwnd);
                            (hwnd.Nodes[msg.hwnd.ToString()]).Tag = (Object)client;

                            treeView.Sort();
                            treeView.ExpandAll();
                        }
                    }
                }
                else if (message.GetType().Equals(typeof(Shared.SnapShot.Messages.Process)))
                {
                    Shared.SnapShot.Messages.Process msg = (Shared.SnapShot.Messages.Process)message;

                    if (msg.action.Equals("HEARTBEAT"))
                    {
                        if (msg.name.Equals(String.Empty))
                        {
                            treeView.Nodes.RemoveByKey(msg.pid.ToString());
                        }
                        else if (treeView.Nodes.ContainsKey(msg.pid.ToString()))
                        {
                            (treeView.Nodes[msg.pid.ToString()]).Text = msg.name;
                        }
                        else
                        {
                            treeView.Nodes.Add(msg.pid.ToString(), msg.name);
                            (treeView.Nodes[msg.pid.ToString()]).Tag = "PROCESS";

                            treeView.Sort();
                            treeView.ExpandAll();
                        }
                    }
                }
                else if (message.GetType().Equals(typeof(Shared.Delegate.Messages.Client)))
                {
                    Shared.Delegate.Messages.Client msg = (Shared.Delegate.Messages.Client)message;

                    if (msg.action.Equals("HEARTBEAT"))
                    {
                        TreeNode hwnd = treeView.Nodes[msg.pid.ToString()];

                        if (hwnd.Nodes.ContainsKey(msg.hwnd.ToString()))
                        {
                            ((Shared.Console.Messages.Client)(hwnd.Nodes[msg.hwnd.ToString()]).Tag).allowmonitor = msg.allowmonitor;
                            ((Shared.Console.Messages.Client)(hwnd.Nodes[msg.hwnd.ToString()]).Tag).allowplay = msg.allowplay;
                        }
                    }
                }
                else if (message.GetType().Equals(typeof(Shared.Logic.Messages.Client)))
                {
                    Shared.Logic.Messages.Client msg = (Shared.Logic.Messages.Client)message;

                    if (msg.action.Equals("HEARTBEAT"))
                    {
                        TreeNode hwnd = treeView.Nodes[msg.pid.ToString()];

                        if (hwnd.Nodes.ContainsKey(msg.hwnd.ToString()))
                        {
                            ((Shared.Console.Messages.Client)(hwnd.Nodes[msg.hwnd.ToString()]).Tag).profile = msg.profile;
                        }
                    }
                }
            }
            catch (Exception ex)
            {
                System.Console.WriteLine(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
            }
        }
        public Object ReceiveMessage(Object message, String nickname)
        {
            // http://blogs.msdn.com/csharpfaq/archive/2004/03/17/91685.aspx
            if (treeView.IsHandleCreated)
            {
                try
                {
                    treeView.Invoke(new ViewBroadcastHeartBeatCallback(this.ViewBroadcastHeartBeat), new Object[] { message, nickname });
                }
                catch (Exception ex)
                {
                    MessageBox.Show(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                }
            }
            return null;
        }

        public override Object InitializeLifetimeService()
        {
            return null;
        }
        private void ClearProfileComboBox()
        {
            actionsProfilesToolStripComboBox.Items.Clear();
            profileToolStripComboBox.Items.Clear();
        }
        private void PopulateProcessToolStripMenu()
        {
            processes = Shared.XML.SnapShot.Reader.ProcessesAvailableConfig();

            foreach (String process in processes)
            {
                ToolStripMenuItem menu = new ToolStripMenuItem(process, null, new EventHandler(processToolStripMenuItem_Click), process);
                processesToolStripMenuItem.DropDownItems.Add(menu);
            }
        }
        private void PopulateTrampolinedProcesses()
        {
            trampolineConfig = Shared.XML.SnapShot.Reader.TrampolineConfig();
        }
        public void PopulateProfileComboBox()
        {
            actionsProfilesToolStripComboBox.Items.Clear();
            profileToolStripComboBox.Items.Clear();

            profiles = Shared.XML.Logic.Reader.ProfilesAvailableConfig();

            foreach (String profile in profiles)
            {
                ToolStripMenuItem menu = new ToolStripMenuItem(profile, null, new EventHandler(profileToolStripComboBox_SelectedIndexChanged), profile);
                actionsProfilesToolStripComboBox.Items.Add(menu);
                profileToolStripComboBox.Items.Add(menu);
            }

            if (profiles.Count > 0)
            {
                actionsProfilesToolStripComboBox.SelectedIndex = 0;
                profileToolStripComboBox.SelectedIndex = 0;
            }
            else
            {
                actionsProfilesToolStripComboBox.Enabled = false;
                profileToolStripComboBox.Enabled = false;
            }
        }
        private void DisplayProgressBar(Int32 duration, String display)
        {
            // http://social.msdn.microsoft.com/Forums/en-US/csharpgeneral/thread/a5c28385-f5be-46f6-916f-7bbf17efbdc0
            timerProgress.Interval = duration;
            timerProgress.Start();

            progress = new DialogProgressBar(display);
            progress.ShowDialog(this);
        }
        private void SynchronizeControls()
        {
            if (currentnode != null && currentnode.Tag != null)
            {
                if (currentnode.Tag.GetType().Equals(typeof(Shared.Console.Messages.Client)))
                {
                    PopulateProfileComboBox();

                    monitorToolStripMenuItem.Enabled = true;
                    playToolStripMenuItem.Enabled = true;
                    profileToolStripMenuItem.Enabled = true;
                    profileToolStripComboBox.Enabled = true;

                    actionsToolStripMenuItem.Enabled = true;
                    actionsMonitorToolStripMenuItem.Enabled = true;
                    actionsPlayToolStripMenuItem.Enabled = true;
                    actionsProfileToolStripMenuItem.Enabled = true;
                    actionsProfilesToolStripComboBox.Enabled = true;
                }
                else
                {
                    monitorToolStripMenuItem.Enabled = false;
                    playToolStripMenuItem.Enabled = false;
                    profileToolStripMenuItem.Enabled = false;
                    profileToolStripComboBox.Enabled = false;

                    actionsToolStripMenuItem.Enabled = false;
                    actionsMonitorToolStripMenuItem.Enabled = false;
                    actionsPlayToolStripMenuItem.Enabled = false;
                    actionsProfileToolStripMenuItem.Enabled = false;
                    actionsProfilesToolStripComboBox.Enabled = false;
                }
            }
            else
            {
                actionsMonitorToolStripMenuItem.Enabled = false;
                actionsPlayToolStripMenuItem.Enabled = false;
                actionsProfileToolStripMenuItem.Enabled = false;
                actionsProfilesToolStripComboBox.Enabled = false;
            }
        }
        private void treeView_AfterSelect(object sender, TreeViewEventArgs e)
        {
            currentnode = treeView.SelectedNode;
            SynchronizeControls();
        }
        // http://msdn2.microsoft.com/en-us/library/system.windows.forms.treeview.nodemousedoubleclick.aspx
        private void treeView_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            currentnode = treeView.SelectedNode;
            SynchronizeControls();
        }
        // http://support.microsoft.com/kb/810001
        private void treeView_MouseUp(object sender, MouseEventArgs e)
        {
            // Show menu only if the right mouse button is clicked.
            if (e.Button == MouseButtons.Right)
            {
                // Point where the mouse is clicked.
                Point p = new Point(e.X, e.Y);

                currentnode = treeView.SelectedNode = treeView.GetNodeAt(p);

                // Get the node that the user has clicked.
                if (currentnode != null && currentnode.Tag != null)
                {
                    // Find the appropriate ContextMenu depending on the selected node.
                    if (currentnode.Tag.GetType().Equals(typeof(Shared.Console.Messages.Client)))
                    {
                        monitorToolStripMenuItem.Enabled = true;
                        playToolStripMenuItem.Enabled = true;
                        profileToolStripMenuItem.Enabled = true;
                        profileToolStripComboBox.Enabled = true;

                        monitorToolStripMenuItem.Checked = ((Shared.Console.Messages.Client)currentnode.Tag).allowmonitor;
                        playToolStripMenuItem.Checked = ((Shared.Console.Messages.Client)currentnode.Tag).allowplay;

                        actionsMonitorToolStripMenuItem.Enabled = true;
                        actionsPlayToolStripMenuItem.Enabled = true;
                        actionsProfileToolStripMenuItem.Enabled = true;
                        actionsProfilesToolStripComboBox.Enabled = true;

                        actionsMonitorToolStripMenuItem.Checked = ((Shared.Console.Messages.Client)currentnode.Tag).allowmonitor;
                        actionsPlayToolStripMenuItem.Checked = ((Shared.Console.Messages.Client)currentnode.Tag).allowplay;

                        for(int i = 0; i < profileToolStripComboBox.Items.Count; i++)
                        {
                            ToolStripMenuItem menu = (ToolStripMenuItem)profileToolStripComboBox.Items[i];

                            if (((Shared.Console.Messages.Client)currentnode.Tag).profile.Equals(menu.Text))
                            {
                                profileToolStripComboBox.SelectedIndex = i;
                                actionsProfilesToolStripComboBox.SelectedIndex = i;
                                break;
                            }
                        }

                        contextMenuStripClient.Show(treeView, p);
                    }
                    else
                    {
                        monitorToolStripMenuItem.Enabled = false;
                        playToolStripMenuItem.Enabled = false;
                        profileToolStripMenuItem.Enabled = false;
                        profileToolStripComboBox.Enabled = false;

                        actionsMonitorToolStripMenuItem.Enabled = false;
                        actionsPlayToolStripMenuItem.Enabled = false;
                        actionsProfileToolStripMenuItem.Enabled = false;
                        actionsProfilesToolStripComboBox.Enabled = false;
                    }
                }
            }
        }
        private void actionsToolStripMenuItem_Click(object sender, EventArgs e)
        {
            currentnode = treeView.SelectedNode;
            SynchronizeControls();
        }
        private void monitorToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Shared.Console.Messages.Client msg = (Shared.Console.Messages.Client)currentnode.Tag;

            if (actionsMonitorToolStripMenuItem.Checked.Equals(msg.allowmonitor))
            {
                msg.allowmonitor = monitorToolStripMenuItem.Checked;
            }
            else if (monitorToolStripMenuItem.Checked.Equals(msg.allowmonitor))
            {
                msg.allowmonitor = actionsMonitorToolStripMenuItem.Checked;
            }

            if (!msg.allowmonitor && msg.allowplay)
            {
                msg.allowplay = false;
            }
            else if (!msg.allowmonitor)
            {
                currentnode.Nodes.Clear();
            }

            actionsMonitorToolStripMenuItem.Checked = msg.allowmonitor;
            actionsPlayToolStripMenuItem.Checked = msg.allowplay;

            monitorToolStripMenuItem.Checked = msg.allowmonitor;
            playToolStripMenuItem.Checked = msg.allowplay;

            currentnode.Tag = treeView.SelectedNode.Tag = (Object)msg;
            BroadcastIt.SendMessage((Object)msg);

            DisplayProgressBar(3000, "Synchronizing configuration with Ludus services...");
        }
        private void playToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Shared.Console.Messages.Client msg = (Shared.Console.Messages.Client)currentnode.Tag;

            if (actionsPlayToolStripMenuItem.Checked.Equals(msg.allowplay))
            {
                msg.allowplay = playToolStripMenuItem.Checked;
            }
            else if (playToolStripMenuItem.Checked.Equals(msg.allowplay))
            {
                msg.allowplay = actionsPlayToolStripMenuItem.Checked;
            }

            if (msg.allowplay)
            {
                msg.allowmonitor = true;
            }
            else
            {
                currentnode.Nodes.Clear();
            }

            actionsMonitorToolStripMenuItem.Checked = msg.allowmonitor;
            actionsPlayToolStripMenuItem.Checked = msg.allowplay;

            monitorToolStripMenuItem.Checked = msg.allowmonitor;
            playToolStripMenuItem.Checked = msg.allowplay;

            currentnode.Tag = treeView.SelectedNode.Tag = (Object)msg;
            BroadcastIt.SendMessage((Object)msg);

            DisplayProgressBar(3000, "Synchronizing configuration with Ludus services...");
        }
        private void profileToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Shared.Console.Messages.Client msg = (Shared.Console.Messages.Client)currentnode.Tag;
            msg.profile = profileToolStripComboBox.Text;

            currentnode.Tag = treeView.SelectedNode.Tag = (Object)msg;
            BroadcastIt.SendMessage((Object)msg);

            DisplayProgressBar(3000, "Synchronizing configuration with Ludus services...");
        }
        private void profileToolStripComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            ToolStripComboBox menu = (ToolStripComboBox)sender;

            if (actionsProfilesToolStripComboBox.Visible)
            {
                profileToolStripComboBox.SelectedIndex = actionsProfilesToolStripComboBox.SelectedIndex;
            }
            else if(profileToolStripComboBox.Visible)
            {
                actionsProfilesToolStripComboBox.SelectedIndex = profileToolStripComboBox.SelectedIndex;
            }
        }
        private void profilesToolStripMenuItem_Click(object sender, EventArgs e)
        {
            DialogProfile profiles = new DialogProfile();
            profiles.ShowDialog(this);
        }
        private void processToolStripMenuItem_Click(object sender, EventArgs e)
        {
            ToolStripItem menu = (ToolStripItem)sender;
            String cmd = String.Empty;
            String exe = Shared.XML.SnapShot.Reader.ProcessesAvailableLocationConfig(menu.Name);
            String exeargs = Shared.XML.SnapShot.Reader.ProcessesAvailableArgsConfig(menu.Name);

            if (exeargs.Equals(String.Empty)) { cmd = "PEREWRITE_PRELOAD|" + exe; }
            else { cmd = "PEREWRITE_PRELOAD|" + exe + "| " + exeargs; }

            if (Shared.SnapShot.Trampoline.Client(trampolineConfig.path, trampolineConfig.buffersize, cmd).Contains("ERROR"))
            {
                DialogNotice notice = new DialogNotice("Failure to spawn process \"" + exe + "\"" 
                    + Environment.NewLine + "Make sure all Ludus related services are started.");
                notice.ShowDialog(this);
            }
            else
            {
                DisplayProgressBar(10000, "Spawning \"" + exe + "\"");
            }
        }
        private void timerProgress_Tick(object sender, EventArgs e)
        {
            progress.Close();
            timerProgress.Stop();
        }
        private void exitToolStripMenuItem_Click(object sender, EventArgs e)
        {
            Close();
        }
    }
}