using System;
using System.Collections;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;

namespace Console
{
    public partial class DialogProfile : Form
    {
        private static Shared.Logic.Poker.Messages.Profile profile;
        private static TreeNode currentnode;

        public DialogProfile()
        {
            InitializeComponent();
            PopulateTreeView();

            // No profile is selected yet, disable some stuff.
            tabView.Enabled = false;
            btnSave.Enabled = false;
        }
        private void PopulateTreeView()
        {
            TreeNode root = new TreeNode("Profiles");
            root.Tag = "Type";

            treeView.Nodes.Clear();

            ArrayList profiles = Shared.XML.Logic.Reader.ProfilesAvailableConfig();

            foreach (String profile in profiles)
            {
                TreeNode pn = new TreeNode(profile);
                pn.Tag = "Profile";

                root.Nodes.Add(pn);
            }

            treeView.Nodes.Add(root);
            treeView.Sort();
            treeView.ExpandAll();
        }
        private void ClearProfileView()
        {
            chkPreFlop.Checked = false;
            chkPreAllIn.Checked = false;
            txtPreAllInAmount.Text = String.Empty;
            txtPreAllInChance.Text = String.Empty;
            chkPreRaise.Checked = false;
            txtPreRaiseAmount.Text = String.Empty;
            txtPreRaiseChance.Text = String.Empty;
            chkPreBet.Checked = false;
            txtPreBetAmount.Text = String.Empty;
            txtPreBetChance.Text = String.Empty;
            chkPreCall.Checked = false;
            txtPreCallAmount.Text = String.Empty;
            txtPreCallChance.Text = String.Empty;
            chkPreCheck.Checked = false;
            chkPreFold.Checked = false;
            chkPrePostSB.Checked = false;
            txtPrePostSBAmount.Text = String.Empty;
            chkPrePostBB.Checked = false;
            txtPrePostBBAmount.Text = String.Empty;

            chkPostFlop.Checked = false;
            chkPostAllIn.Checked = false;
            txtPostAllInAmount.Text = String.Empty;
            txtPostAllInChance.Text = String.Empty;
            chkPostRaise.Checked = false;
            txtPostRaiseAmount.Text = String.Empty;
            txtPostRaiseChance.Text = String.Empty;
            chkPostBet.Checked = false;
            txtPostBetAmount.Text = String.Empty;
            txtPostBetChance.Text = String.Empty;
            chkPostCall.Checked = false;
            txtPostCallAmount.Text = String.Empty;
            txtPostCallChance.Text = String.Empty;
            chkPostCheck.Checked = false;
            chkPostFold.Checked = false;
        }
        private void PopulateProfileView(String description)
        {
            profile = Shared.XML.Logic.Reader.ProfileConfig(description);

            chkPreFlop.Checked = profile.preflop.enable;
            chkPreAllIn.Checked = profile.preflop.allin.enable;
            txtPreAllInAmount.Text = profile.preflop.allin.amount.ToString();
            txtPreAllInChance.Text = profile.preflop.allin.chance.ToString();
            chkPreRaise.Checked = profile.preflop.raise.enable;
            txtPreRaiseAmount.Text = profile.preflop.raise.amount.ToString();
            txtPreRaiseChance.Text = profile.preflop.raise.chance.ToString();
            chkPreBet.Checked = profile.preflop.bet.enable;
            txtPreBetAmount.Text = profile.preflop.bet.amount.ToString();
            txtPreBetChance.Text = profile.preflop.bet.chance.ToString();
            chkPreCall.Checked = profile.preflop.call.enable;
            txtPreCallAmount.Text = profile.preflop.call.amount.ToString();
            txtPreCallChance.Text = profile.preflop.call.chance.ToString();
            chkPreCheck.Checked = profile.preflop.check.enable;
            chkPreFold.Checked = profile.preflop.fold.enable;
            chkPrePostSB.Checked = profile.preflop.postsb.enable;
            txtPrePostSBAmount.Text = profile.preflop.postsb.amount.ToString();
            chkPrePostBB.Checked = profile.preflop.postbb.enable;
            txtPrePostBBAmount.Text = profile.preflop.postbb.amount.ToString();
            
            chkPostFlop.Checked = profile.postflop.enable;
            chkPostAllIn.Checked = profile.postflop.allin.enable;
            txtPostAllInAmount.Text = profile.postflop.allin.amount.ToString();
            txtPostAllInChance.Text = profile.postflop.allin.chance.ToString();
            chkPostRaise.Checked = profile.postflop.raise.enable;
            txtPostRaiseAmount.Text = profile.postflop.raise.amount.ToString();
            txtPostRaiseChance.Text = profile.postflop.raise.chance.ToString();
            chkPostBet.Checked = profile.postflop.bet.enable;
            txtPostBetAmount.Text = profile.postflop.bet.amount.ToString();
            txtPostBetChance.Text = profile.postflop.bet.chance.ToString();
            chkPostCall.Checked = profile.postflop.call.enable;
            txtPostCallAmount.Text = profile.postflop.call.amount.ToString();
            txtPostCallChance.Text = profile.postflop.call.chance.ToString();
            chkPostCheck.Checked = profile.postflop.check.enable;
            chkPostFold.Checked = profile.postflop.fold.enable;
        }
        private void treeView_AfterSelect(object sender, TreeViewEventArgs e)
        {
            currentnode = treeView.SelectedNode;

            if (currentnode != null)
            {
                // Find the appropriate ContextMenu depending on the selected node.
                switch (Convert.ToString(currentnode.Tag))
                {
                    case "Profile":
                        PopulateProfileView(currentnode.Text);
                        btnSave.Text = "Save profile... [" + currentnode.Text + "]";
                        btnSave.Enabled = true;
                        tabView.Enabled = true;
                        break;
                    case "Type":
                        ClearProfileView();
                        btnSave.Text = "Save profile.. [No Profile Selected]";
                        btnSave.Enabled = false;
                        tabView.Enabled = false;
                        break;
                }
            }
        }
        // http://msdn2.microsoft.com/en-us/library/system.windows.forms.treeview.nodemousedoubleclick.aspx
        private void treeView_MouseDoubleClick(object sender, MouseEventArgs e)
        {
            // Point where the mouse is clicked.
            Point p = new Point(e.X, e.Y);

            currentnode = treeView.SelectedNode = treeView.GetNodeAt(p);

            if (currentnode != null)
            {
                // Find the appropriate ContextMenu depending on the selected node.
                switch (Convert.ToString(currentnode.Tag))
                {
                    case "Profile":
                        PopulateProfileView(currentnode.Text);
                        btnSave.Text = "Save profile... [" + currentnode.Text + "]";
                        btnSave.Enabled = true;
                        tabView.Enabled = true;
                        break;
                    case "Type":
                        ClearProfileView();
                        btnSave.Text = "Save profile.. [No Profile Selected]";
                        btnSave.Enabled = false;
                        tabView.Enabled = false;
                        break;
                }
            }
        }
        // http://support.microsoft.com/kb/810001
        private void treeView_MouseUp(object sender, MouseEventArgs e)
        {
            // Show menu only if the right mouse button is clicked.
            if (e.Button == MouseButtons.Right)
            {
                // Point where the mouse is clicked.
                Point p = new Point(e.X, e.Y);

                currentnode = treeView.SelectedNode = treeView.GetNodeAt(p);

                if (currentnode != null)
                {
                    // Find the appropriate ContextMenu depending on the selected node.
                    switch (Convert.ToString(currentnode.Tag))
                    {
                        case "Profile":
                            PopulateProfileView(currentnode.Text);
                            btnSave.Text = "Save profile... [" + currentnode.Text + "]";
                            btnSave.Enabled = true;
                            tabView.Enabled = true;
                            contextMenuStripProfile.Show(treeView, p);
                            break;
                        case "Type":
                            ClearProfileView();
                            btnSave.Text = "Save profile.. [No Profile Selected]";
                            btnSave.Enabled = false;
                            tabView.Enabled = false;
                            contextMenuStripType.Show(treeView, p);
                            break;
                    }
                }
            }
        }
        private void addProfileToolStripMenuItem_Click(object sender, EventArgs e)
        {
            // Open the add profile dialog.
            DialogProfileAdd add = new DialogProfileAdd();
            add.ShowDialog(this);

            if (add.yes)
            {
                profile = new Shared.Logic.Poker.Messages.Profile(add.txtAdd.Text);
                Shared.XML.Logic.Writer.AddProfile(profile);

                System.Windows.Forms.TreeNode parent = currentnode;
                System.Windows.Forms.TreeNode child = new System.Windows.Forms.TreeNode(add.txtAdd.Text);
                child.Tag = "Profile";
                parent.Nodes.Add(child);

                Shared.Console.Messages.Profile pmsg = new Shared.Console.Messages.Profile("ADD", add.txtAdd.Text, String.Empty);
                Console.DialogMain.BroadcastIt.SendMessage((Object)pmsg);

                PopulateTreeView();
            }

        }
        private void deleteProfileToolStripMenuItem_Click(object sender, EventArgs e)
        {
            DialogProfileDelete delete = new DialogProfileDelete();
            delete.ShowDialog(this);

            if (delete.yes)
            {
                Shared.XML.Logic.Writer.DeleteProfile(currentnode.Text);
                currentnode.Remove();

                Shared.Console.Messages.Profile pmsg = new Shared.Console.Messages.Profile("DELETE", currentnode.Text, String.Empty);
                Console.DialogMain.BroadcastIt.SendMessage((Object)pmsg);

                PopulateTreeView();
            }
        }
        private void renameProfileToolStripMenuItem_Click(object sender, EventArgs e)
        {
            DialogProfileRename rename = new DialogProfileRename(currentnode.Text);
            rename.ShowDialog(this);

            Shared.XML.Logic.Writer.RenameProfile(currentnode.Text, rename.txtRename.Text);
            currentnode.Text = rename.txtRename.Text;

            Shared.Console.Messages.Profile pmsg = new Shared.Console.Messages.Profile("RENAME", currentnode.Text, rename.txtRename.Text);
            Console.DialogMain.BroadcastIt.SendMessage((Object)pmsg);

            PopulateTreeView();
        }
        private void saveProfileToolStripMenuItem_Click(object sender, EventArgs e)
        {
            profile.preflop.enable = chkPreFlop.Checked;
            profile.preflop.allin.enable = chkPreAllIn.Checked;
            profile.preflop.allin.amount = float.Parse(txtPreAllInAmount.Text);
            profile.preflop.allin.chance = float.Parse(txtPreAllInChance.Text);
            profile.preflop.raise.enable = chkPreRaise.Checked;
            profile.preflop.raise.amount = float.Parse(txtPreRaiseAmount.Text);
            profile.preflop.raise.chance = float.Parse(txtPreRaiseChance.Text);
            profile.preflop.bet.enable = chkPreBet.Checked;
            profile.preflop.bet.amount = float.Parse(txtPreBetAmount.Text);
            profile.preflop.bet.chance = float.Parse(txtPreBetChance.Text);
            profile.preflop.call.enable = chkPreCall.Checked;
            profile.preflop.call.amount = float.Parse(txtPreCallAmount.Text);
            profile.preflop.call.chance = float.Parse(txtPreCallChance.Text);
            profile.preflop.check.enable = chkPreCheck.Checked;
            profile.preflop.fold.enable = chkPreFold.Checked;
            profile.preflop.postsb.enable = chkPrePostSB.Checked;
            profile.preflop.postsb.amount = float.Parse(txtPrePostSBAmount.Text);
            profile.preflop.postbb.enable = chkPrePostBB.Checked;
            profile.preflop.postbb.amount = float.Parse(txtPrePostBBAmount.Text);

            profile.postflop.enable = chkPostFlop.Checked;
            profile.postflop.allin.enable = chkPostAllIn.Checked;
            profile.postflop.allin.amount = float.Parse(txtPostAllInAmount.Text);
            profile.postflop.allin.chance = float.Parse(txtPostAllInChance.Text);
            profile.postflop.raise.enable = chkPostRaise.Checked;
            profile.postflop.raise.amount = float.Parse(txtPostRaiseAmount.Text);
            profile.postflop.raise.chance = float.Parse(txtPostRaiseChance.Text);
            profile.postflop.bet.enable = chkPostBet.Checked;
            profile.postflop.bet.amount = float.Parse(txtPostBetAmount.Text);
            profile.postflop.bet.chance = float.Parse(txtPostBetChance.Text);
            profile.postflop.call.enable = chkPostCall.Checked;
            profile.postflop.call.amount = float.Parse(txtPostCallAmount.Text);
            profile.postflop.call.chance = float.Parse(txtPostCallChance.Text);
            profile.postflop.check.enable = chkPostCheck.Checked;
            profile.postflop.fold.enable = chkPostFold.Checked;

            Shared.XML.Logic.Writer.SaveProfile(profile);

            Shared.Console.Messages.Profile pmsg = new Shared.Console.Messages.Profile("SAVE", currentnode.Text, String.Empty);
            Console.DialogMain.BroadcastIt.SendMessage((Object)pmsg);
        }
        private void btnExit_Click(object sender, EventArgs e)
        {
            Close();
        }

        private void chkPreFlop_CheckedChanged(object sender, EventArgs e)
        {
            if (!chkPreFlop.Checked)
            {
                chkPreAllIn.Checked = false;
                chkPreRaise.Checked = false;
                chkPreBet.Checked = false;
                chkPreCall.Checked = false;
                chkPreCheck.Checked = false;
                chkPreFold.Checked = false;
                chkPrePostSB.Checked = false;
                chkPrePostBB.Checked = false;

                chkPreAllIn.Enabled = false;
                chkPreRaise.Enabled = false;
                chkPreBet.Enabled = false;
                chkPreCall.Enabled = false;
                chkPreCheck.Enabled = false;
                chkPreFold.Enabled = false;
                chkPrePostSB.Enabled = false;
                chkPrePostBB.Enabled = false;
            }
            else
            {
                chkPreAllIn.Enabled = true;
                chkPreRaise.Enabled = true;
                chkPreBet.Enabled = true;
                chkPreCall.Enabled = true;
                chkPreCheck.Enabled = true;
                chkPreFold.Enabled = true;
                chkPrePostSB.Enabled = true;
                chkPrePostBB.Enabled = true;
            }
        }

        private void chkPostFlop_CheckedChanged(object sender, EventArgs e)
        {
            if (!chkPostFlop.Checked)
            {
                chkPostFlop.Checked = false;
                chkPostAllIn.Checked = false;
                chkPostRaise.Checked = false;
                chkPostBet.Checked = false;
                chkPostCall.Checked = false;
                chkPostCheck.Checked = false;
                chkPostFold.Checked = false;

                chkPostFlop.Enabled = false;
                chkPostAllIn.Enabled = false;
                chkPostRaise.Enabled = false;
                chkPostBet.Enabled = false;
                chkPostCall.Enabled = false;
                chkPostCheck.Enabled = false;
                chkPostFold.Enabled = false;
            }
            else
            {
                chkPostFlop.Enabled = true;
                chkPostAllIn.Enabled = true;
                chkPostRaise.Enabled = true;
                chkPostBet.Enabled = true;
                chkPostCall.Enabled = true;
                chkPostCheck.Enabled = true;
                chkPostFold.Enabled = true;
            }
        }
    }
}