using System;
using System.Collections;
using System.Diagnostics;
using System.Text;
using System.Text.RegularExpressions;

namespace Private.Logic
{
    public class Objects
    {
        public class Debugger
        {
            public String pid;
            public String hwnd;
            public String timestamp;

            public Debugger(String Pid, String Hwnd)
            {
                pid = Pid;
                hwnd = Hwnd;
                timestamp = String.Empty;
            }
        }

        public class Process
        {
            public UInt32 pid;
            public String name;
            public Hashtable clients;
            public Hashtable profiles;

            public Process(UInt32 Pid, String Name)
            {
                pid = Pid;
                name = Name;
                clients = new Hashtable();
                profiles = new Hashtable();
            }
        }

        public class Client
        {
            public IntPtr hwnd;
            public String caption;
            public Layout layout;
            public String profile;
            public Boolean allowmonitor;
            public Boolean allowplay;

            public Client(IntPtr Hwnd, String Caption)
            {
                hwnd = Hwnd;
                caption = Caption;
                layout = new Layout();
                profile = "NONE";
                allowmonitor = false;
                allowplay = false;
            }
        }

        public class Layout : DictionaryBase
        {
            public Object this[Object key]
            {
                get { return ((Object)Dictionary[key]); }
                set { Dictionary[key] = value; }
            }
            public ICollection Keys
            {
                get { return (Dictionary.Keys); }
            }
            public ICollection Values
            {
                get { return (Dictionary.Values); }
            }
            public void Add(Object key, Object value)
            {
                Dictionary.Add(key, value);
            }
            public bool ContainsKey(Object key)
            {
                return (Dictionary.Contains(key));
            }
            public void Remove(Object key)
            {
                Dictionary.Remove(key);
            }
            public void GetCountFromId(String Expr, ref Int32 Count)
            {
                Count = 0;

                foreach (Object key in Dictionary.Keys)
                {
                    Objects.Element element = (Objects.Element)Dictionary[key];

                    if (Regex.IsMatch(element.id, Expr, RegexOptions.IgnoreCase | RegexOptions.Compiled))
                    {
                        Count += 1;
                    }
                }
            }
            public void GetElementsFromId(String Expr, ref Hashtable Values)
            {
                Values.Clear();

                foreach (Object key in Dictionary.Keys)
                {
                    Objects.Element element = (Objects.Element)Dictionary[key];

                    if (Regex.IsMatch(element.id, Expr, RegexOptions.IgnoreCase | RegexOptions.Compiled)
                        && !Values.ContainsKey(element.id))
                    {
                        Values.Add(element.key, element);
                    }
                }
            }
        }

        public class Element
        {
            public String key;
            public String id;
            public IntPtr chwnd;
            public String value;
            public Double amount;

            public Element(String Key, String Id, String Value)
            {
                key = Key;
                id = Id;
                chwnd = IntPtr.Zero;
                value = Value;
                amount = 0.0;
            }
        }
    }
}
