using System;
using System.Collections;
using System.Diagnostics;
using System.Text;

namespace Private.Logic.Poker
{
    public static class HoldEm
    {
        public static Private.Logic.Objects.Element Go(ref Private.Logic.Poker.Objects.State state, ref Shared.Logic.Poker.Messages.Profile profile)
        {
            if (profile.preflop.enable && state.action.Equals("PREFLOP"))
            {
                if (profile.preflop.allin.enable)
                {
                    foreach (Object bkey in state.tablebuttons.Keys)
                    {
                        if (((Private.Logic.Objects.Element)state.tablebuttons[bkey]).value.Equals("all-in")
                            && ((Private.Logic.Objects.Element)state.tablebuttons[bkey]).amount <= profile.preflop.allin.amount
                            && state.playerchances >= profile.preflop.allin.chance)
                        {
                            return (Private.Logic.Objects.Element)state.tablebuttons[bkey];
                        }
                    }
                }
                if (profile.preflop.raise.enable)
                {
                    foreach (Object bkey in state.tablebuttons.Keys)
                    {
                        if (((Private.Logic.Objects.Element)state.tablebuttons[bkey]).value.Equals("raise")
                            && ((Private.Logic.Objects.Element)state.tablebuttons[bkey]).amount <= profile.preflop.raise.amount
                            && state.playerchances >= profile.preflop.raise.chance)
                        {
                            return (Private.Logic.Objects.Element)state.tablebuttons[bkey];
                        }
                    }
                }
                if (profile.preflop.bet.enable)
                {
                    foreach (Object bkey in state.tablebuttons.Keys)
                    {
                        if (((Private.Logic.Objects.Element)state.tablebuttons[bkey]).value.Equals("bet")
                            && ((Private.Logic.Objects.Element)state.tablebuttons[bkey]).amount <= profile.preflop.bet.amount
                            && state.playerchances >= profile.preflop.bet.chance)
                        {
                            return (Private.Logic.Objects.Element)state.tablebuttons[bkey];
                        }
                    }
                }
                if (profile.preflop.call.enable)
                {
                    foreach (Object bkey in state.tablebuttons.Keys)
                    {
                        if (((Private.Logic.Objects.Element)state.tablebuttons[bkey]).value.Equals("call")
                            && ((Private.Logic.Objects.Element)state.tablebuttons[bkey]).amount <= profile.preflop.call.amount
                            && state.playerchances >= profile.preflop.call.chance)
                        {
                            return (Private.Logic.Objects.Element)state.tablebuttons[bkey];
                        }
                    }
                }
                if (profile.preflop.check.enable)
                {
                    foreach (Object bkey in state.tablebuttons.Keys)
                    {
                        if (((Private.Logic.Objects.Element)state.tablebuttons[bkey]).value.Equals("check"))
                        {
                            return (Private.Logic.Objects.Element)state.tablebuttons[bkey];
                        }
                    }
                }
                if (profile.preflop.fold.enable)
                {
                    foreach (Object bkey in state.tablebuttons.Keys)
                    {
                        if (((Private.Logic.Objects.Element)state.tablebuttons[bkey]).value.Equals("fold"))
                        {
                            return (Private.Logic.Objects.Element)state.tablebuttons[bkey];
                        }
                    }
                }
                if (profile.preflop.postbb.enable)
                {
                    foreach (Object bkey in state.tablebuttons.Keys)
                    {
                        if (((Private.Logic.Objects.Element)state.tablebuttons[bkey]).value.Equals("post bb")
                            && ((Private.Logic.Objects.Element)state.tablebuttons[bkey]).amount <= profile.preflop.postbb.amount)
                        {
                            return (Private.Logic.Objects.Element)state.tablebuttons[bkey];
                        }
                    }
                }
                if (profile.preflop.postsb.enable)
                {
                    foreach (Object bkey in state.tablebuttons.Keys)
                    {
                        if (((Private.Logic.Objects.Element)state.tablebuttons[bkey]).value.Equals("post sb")
                            && ((Private.Logic.Objects.Element)state.tablebuttons[bkey]).amount <= profile.preflop.postsb.amount)
                        {
                            return (Private.Logic.Objects.Element)state.tablebuttons[bkey];
                        }
                    }
                }
            }
            else if (profile.postflop.enable && state.action.Equals("POSTFLOP"))
            {
                if (profile.postflop.allin.enable)
                {
                    foreach (Object bkey in state.tablebuttons.Keys)
                    {
                        if (((Private.Logic.Objects.Element)state.tablebuttons[bkey]).value.Equals("all-in")
                            && ((Private.Logic.Objects.Element)state.tablebuttons[bkey]).amount <= profile.postflop.allin.amount
                            && state.playerchances >= profile.postflop.allin.chance)
                        {
                            return (Private.Logic.Objects.Element)state.tablebuttons[bkey];
                        }
                    }
                }
                if (profile.postflop.raise.enable)
                {
                    foreach (Object bkey in state.tablebuttons.Keys)
                    {
                        if (((Private.Logic.Objects.Element)state.tablebuttons[bkey]).value.Equals("raise")
                            && ((Private.Logic.Objects.Element)state.tablebuttons[bkey]).amount <= profile.postflop.raise.amount
                            && state.playerchances >= profile.postflop.raise.chance)
                        {
                            return (Private.Logic.Objects.Element)state.tablebuttons[bkey];
                        }
                    }
                }
                if (profile.postflop.bet.enable)
                {
                    foreach (Object bkey in state.tablebuttons.Keys)
                    {
                        if (((Private.Logic.Objects.Element)state.tablebuttons[bkey]).value.Equals("bet")
                            && ((Private.Logic.Objects.Element)state.tablebuttons[bkey]).amount <= profile.postflop.bet.amount
                            && state.playerchances >= profile.postflop.bet.chance)
                        {
                            return (Private.Logic.Objects.Element)state.tablebuttons[bkey];
                        }
                    }
                }
                if (profile.postflop.call.enable)
                {
                    foreach (Object bkey in state.tablebuttons.Keys)
                    {
                        if (((Private.Logic.Objects.Element)state.tablebuttons[bkey]).value.Equals("call")
                            && ((Private.Logic.Objects.Element)state.tablebuttons[bkey]).amount <= profile.postflop.call.amount
                            && state.playerchances >= profile.postflop.call.chance)
                        {
                            return (Private.Logic.Objects.Element)state.tablebuttons[bkey];
                        }
                    }
                }
                if (profile.postflop.check.enable)
                {
                    foreach (Object bkey in state.tablebuttons.Keys)
                    {
                        if (((Private.Logic.Objects.Element)state.tablebuttons[bkey]).value.Equals("check"))
                        {
                            return (Private.Logic.Objects.Element)state.tablebuttons[bkey];
                        }
                    }
                }
                if (profile.postflop.fold.enable)
                {
                    foreach (Object bkey in state.tablebuttons.Keys)
                    {
                        if (((Private.Logic.Objects.Element)state.tablebuttons[bkey]).value.Equals("fold"))
                        {
                            return (Private.Logic.Objects.Element)state.tablebuttons[bkey];
                        }
                    }
                }
            }
            return new Private.Logic.Objects.Element(null, "NONE", "NONE");
        }
    }
}
