using System;
using System.Collections;
using System.Diagnostics;
using System.Text;

namespace Private.Logic.Poker.Probability
{
    public static class PostFlop
    {
        public static void Go(ref Private.Logic.Poker.Objects.State state)
        {
            try
            {
                state.action = "POSTFLOP";
                String tablecards = String.Empty;
                String playercards = String.Empty;

                foreach (Object s in state.tablecards.Keys)
                {
                    tablecards += ((Private.Logic.Objects.Element)state.tablecards[s]).value + " ";
                }
                foreach (Object s in state.playercards.Keys)
                {
                    playercards += ((Private.Logic.Objects.Element)state.playercards[s]).value + " ";
                }

                ulong pocket = Hand.ParseHand(playercards);     // Player Cards
                ulong table = Hand.ParseHand(tablecards);       // Board Cards

                // Calculate state for each hand type
                double[] pocketWins =   { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 };
                double[] opponentWins = { 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0, 0.0 };

                // Count of total hands examined.
                long count = 0;

                // Iterate through all possible opponent hands
                foreach (ulong opponentMask in Hand.Hands(0UL, table | pocket, 2))
                {
                    // Iterate through all possible tables
                    foreach (ulong tableMask in Hand.Hands(table, opponentMask | pocket, 5))
                    {
                        // Create a hand value for each pocket
                        uint pocketHandValue = Hand.Evaluate(tableMask | pocket, 7);
                        uint opponentHandValue = Hand.Evaluate(tableMask | opponentMask, 7);

                        // Calculate Winners
                        if (pocketHandValue > opponentHandValue)
                        {
                            // Player Win
                            pocketWins[Hand.HandType(pocketHandValue)] += 1.0;
                        }
                        else if (pocketHandValue < opponentHandValue)
                        {
                            // Opponent Win
                            opponentWins[Hand.HandType(opponentHandValue)] += 1.0;
                        }
                        else if (pocketHandValue == opponentHandValue)
                        {
                            // Give half credit for ties.
                            pocketWins[Hand.HandType(pocketHandValue)] += 0.5;
                            opponentWins[Hand.HandType(opponentHandValue)] += 0.5;
                        }
                        count++;
                    }
                }

                // Print results
                state.debug.Add(String.Format(" PLAYER-RESULTS "));

                state.debug.Add(String.Format("HighCard:{0:0.0}%", pocketWins[(int)Hand.HandTypes.HighCard] / ((double)count) * 100.0));
                state.playerchances += pocketWins[(int)Hand.HandTypes.HighCard] / ((double)count) * 100.0;
                state.playerhighcard = pocketWins[(int)Hand.HandTypes.HighCard] / ((double)count) * 100.0;

                state.debug.Add(String.Format("TwoOfAKind:{0:0.0}%", pocketWins[(int)Hand.HandTypes.TwoOfAKind] / ((double)count) * 100.0));
                state.playerchances += pocketWins[(int)Hand.HandTypes.TwoOfAKind] / ((double)count) * 100.0;
                state.playertwoofakind = pocketWins[(int)Hand.HandTypes.HighCard] / ((double)count) * 100.0;

                state.debug.Add(String.Format("TwoPair:{0:0.0}%", pocketWins[(int)Hand.HandTypes.TwoPair] / ((double)count) * 100.0));
                state.playerchances += pocketWins[(int)Hand.HandTypes.TwoPair] / ((double)count) * 100.0;
                state.playertwopair = pocketWins[(int)Hand.HandTypes.TwoPair] / ((double)count) * 100.0;

                state.debug.Add(String.Format("ThreeOfAKind:{0:0.0}%", pocketWins[(int)Hand.HandTypes.ThreeOfAKind] / ((double)count) * 100.0));
                state.playerchances += pocketWins[(int)Hand.HandTypes.ThreeOfAKind] / ((double)count) * 100.0;
                state.playerthreeofakind = pocketWins[(int)Hand.HandTypes.ThreeOfAKind] / ((double)count) * 100.0;

                state.debug.Add(String.Format("Straight:{0:0.0}%", pocketWins[(int)Hand.HandTypes.Straight] / ((double)count) * 100.0));
                state.playerchances += pocketWins[(int)Hand.HandTypes.Straight] / ((double)count) * 100.0;
                state.playerstraight = pocketWins[(int)Hand.HandTypes.Straight] / ((double)count) * 100.0;

                state.debug.Add(String.Format("Flush:{0:0.0}%", pocketWins[(int)Hand.HandTypes.Flush] / ((double)count) * 100.0));
                state.playerchances += pocketWins[(int)Hand.HandTypes.Flush] / ((double)count) * 100.0;
                state.playerflush = pocketWins[(int)Hand.HandTypes.Flush] / ((double)count) * 100.0;

                state.debug.Add(String.Format("FullHouse:{0:0.0}%", pocketWins[(int)Hand.HandTypes.FullHouse] / ((double)count) * 100.0));
                state.playerchances += pocketWins[(int)Hand.HandTypes.FullHouse] / ((double)count) * 100.0;
                state.playerfullhouse = pocketWins[(int)Hand.HandTypes.FullHouse] / ((double)count) * 100.0;

                state.debug.Add(String.Format("FourOfAKind:{0:0.0}%", pocketWins[(int)Hand.HandTypes.FourOfAKind] / ((double)count) * 100.0));
                state.playerchances += pocketWins[(int)Hand.HandTypes.FourOfAKind] / ((double)count) * 100.0;
                state.playerfourofakind = pocketWins[(int)Hand.HandTypes.FourOfAKind] / ((double)count) * 100.0;

                state.debug.Add(String.Format("StraightFlush:{0:0.0}%", pocketWins[(int)Hand.HandTypes.StraightFlush] / ((double)count) * 100.0));
                state.playerchances += pocketWins[(int)Hand.HandTypes.StraightFlush] / ((double)count) * 100.0;
                state.playerstraightflush = pocketWins[(int)Hand.HandTypes.StraightFlush] / ((double)count) * 100.0;

                state.debug.Add(String.Format(" ENEMY-RESULTS "));

                state.debug.Add(String.Format("HighCard:{0:0.0}%", opponentWins[(int)Hand.HandTypes.HighCard] / ((double)count) * 100.0));
                state.enemychances += opponentWins[(int)Hand.HandTypes.HighCard] / ((double)count) * 100.0;
                state.enemyhighcard = opponentWins[(int)Hand.HandTypes.HighCard] / ((double)count) * 100.0;

                state.debug.Add(String.Format("TwoOfAKind:{0:0.0}%", opponentWins[(int)Hand.HandTypes.TwoOfAKind] / ((double)count) * 100.0));
                state.enemychances += opponentWins[(int)Hand.HandTypes.TwoOfAKind] / ((double)count) * 100.0;
                state.enemytwoofakind = opponentWins[(int)Hand.HandTypes.TwoOfAKind] / ((double)count) * 100.0;

                state.debug.Add(String.Format("TwoPair:{0:0.0}%", opponentWins[(int)Hand.HandTypes.TwoPair] / ((double)count) * 100.0));
                state.enemychances += opponentWins[(int)Hand.HandTypes.TwoPair] / ((double)count) * 100.0;
                state.enemytwoofakind = opponentWins[(int)Hand.HandTypes.TwoPair] / ((double)count) * 100.0;

                state.debug.Add(String.Format("ThreeOfAKind:{0:0.0}%", opponentWins[(int)Hand.HandTypes.ThreeOfAKind] / ((double)count) * 100.0));
                state.enemychances += opponentWins[(int)Hand.HandTypes.ThreeOfAKind] / ((double)count) * 100.0;
                state.enemythreeofakind = opponentWins[(int)Hand.HandTypes.ThreeOfAKind] / ((double)count) * 100.0;

                state.debug.Add(String.Format("Straight:{0:0.0}%", opponentWins[(int)Hand.HandTypes.Straight] / ((double)count) * 100.0));
                state.enemychances += opponentWins[(int)Hand.HandTypes.Straight] / ((double)count) * 100.0;
                state.enemystraight = opponentWins[(int)Hand.HandTypes.Straight] / ((double)count) * 100.0;

                state.debug.Add(String.Format("Flush:{0:0.0}%", opponentWins[(int)Hand.HandTypes.Flush] / ((double)count) * 100.0));
                state.enemychances += opponentWins[(int)Hand.HandTypes.Flush] / ((double)count) * 100.0;
                state.enemyflush = opponentWins[(int)Hand.HandTypes.Flush] / ((double)count) * 100.0;

                state.debug.Add(String.Format("Fullhouse:{0:0.0}%", opponentWins[(int)Hand.HandTypes.FullHouse] / ((double)count) * 100.0));
                state.enemychances += opponentWins[(int)Hand.HandTypes.FullHouse] / ((double)count) * 100.0;
                state.enemyfullhouse = opponentWins[(int)Hand.HandTypes.FullHouse] / ((double)count) * 100.0;

                state.debug.Add(String.Format("FourOfAKind:{0:0.0}%", opponentWins[(int)Hand.HandTypes.FourOfAKind] / ((double)count) * 100.0));
                state.enemychances += opponentWins[(int)Hand.HandTypes.FourOfAKind] / ((double)count) * 100.0;
                state.enemyfourofakind = opponentWins[(int)Hand.HandTypes.FourOfAKind] / ((double)count) * 100.0;

                state.debug.Add(String.Format("StraightFlush:{0:0.0}%", opponentWins[(int)Hand.HandTypes.StraightFlush] / ((double)count) * 100.0));
                state.enemychances += opponentWins[(int)Hand.HandTypes.StraightFlush] / ((double)count) * 100.0;
                state.enemystraightflush = opponentWins[(int)Hand.HandTypes.StraightFlush] / ((double)count) * 100.0;
            }
            catch (Exception ex)
            {
                StringBuilder evtEntry = new StringBuilder("Private::Logic::Poker::Probability::PostFlop::Go()");
                EventLog evtLog = new EventLog("Application", ".", "Ludus Probability");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }
        }
    }
}
