using System;
using System.Collections;
using System.Diagnostics;
using System.Text;

namespace Private.SnapShot
{
    public class Filter
    {
        public static void NonPrintableASCII(ref String value)
        {
            // http://www.asciitable.com/
            try
            {
                String controlChars = "[\x00-\x1f]";
                String replaceChars = " ";

                value = System.Text.RegularExpressions.Regex.Replace(value, controlChars, replaceChars).ToLower();
            }
            catch (Exception ex)
            {
                StringBuilder evtEntry = new StringBuilder("Private::SnapShot::Filter::NonPrintableASCII()");
                EventLog evtLog = new EventLog("Application", ".", "Ludus SnapShot");
                evtEntry.Append(Environment.NewLine + String.Format("Exception: {0}. Stack trace: {1}.", ex.Message, ex.StackTrace));
                evtLog.WriteEntry(evtEntry.ToString(), EventLogEntryType.Error);
                evtLog.Close();
            }
        }
    }
}
