#pragma once
#include "Stdafx.h"
#include "Messenger.h"

using namespace System;
using namespace System::ComponentModel;
using namespace System::Collections;
using namespace System::Diagnostics;

namespace ServiceLogic {
	/// <summary>
	/// Summary for Collection
	/// </summary>
	public ref class Collection :  public System::ComponentModel::Component
	{
	public:
		Collection(void)
		{
			InitializeComponent();
			//TODO: Add the constructor code here
		}
		Collection(System::ComponentModel::IContainer ^container)
		{
			/// <summary>
			/// Required for Windows.Forms Class Composition Designer support
			/// </summary>
			container->Add(this);
			InitializeComponent();
		}
		static void Daemonize(void)
		{
			StringBuilder^ evtEntry = gcnew StringBuilder(L"ServiceLogic::Collection::Daemonize()" + Environment::NewLine);
			EventLog^ evtLog = gcnew EventLog(L"Application", L".", L"Ludus Logic");

			try
			{
				evtEntry->Append(Environment::NewLine + "Polling interval is " + config->daemonizepollinginterval);
				evtEntry->Append(Environment::NewLine);

				evtEntry->Append(Environment::NewLine + "Play profiles loaded are...");

				for each(System::String ^p in Shared::XML::Logic::Reader::ProfilesAvailableConfig())
				{
					Shared::Logic::Poker::Messages::Profile ^profile = Shared::XML::Logic::Reader::ProfileConfig(p);
					Private::Logic::Globals::logic->Add(p->GetHashCode(), profile);
					evtEntry->Append(Environment::NewLine + "\"" + p + "\""
						+ Environment::NewLine + "preflop " + profile->preflop->enable
						+ Environment::NewLine + "  allin " + profile->preflop->allin->enable.ToString()->ToLower() + " %" + profile->preflop->allin->chance + " $" + profile->preflop->allin->amount
						+ Environment::NewLine + "  raise " + profile->preflop->raise->enable.ToString()->ToLower() + " %" + profile->preflop->raise->chance + " $" + profile->preflop->raise->amount
						+ Environment::NewLine + "  bet " + profile->preflop->bet->enable.ToString()->ToLower() + " %" + profile->preflop->bet->chance + " $" + profile->preflop->bet->amount
						+ Environment::NewLine + "  call " + profile->preflop->call->enable.ToString()->ToLower() + " %" + profile->preflop->call->chance + " $" + profile->preflop->call->amount
						+ Environment::NewLine + "  check " + profile->preflop->check->enable.ToString()->ToLower()
						+ Environment::NewLine + "  fold " + profile->preflop->fold->enable.ToString()->ToLower()
						+ Environment::NewLine + "  postbb " + profile->preflop->postbb->enable.ToString()->ToLower() + " $" + profile->preflop->postbb->amount
						+ Environment::NewLine + "  postsb " + profile->preflop->postsb->enable.ToString()->ToLower() + " $" + profile->preflop->postsb->amount
						+ Environment::NewLine + "postflop " + profile->postflop->enable.ToString()->ToLower()
						+ Environment::NewLine + "  allin " + profile->postflop->allin->enable.ToString()->ToLower() + " %" + profile->postflop->allin->chance + " $" + profile->postflop->allin->amount
						+ Environment::NewLine + "  raise " + profile->postflop->raise->enable.ToString()->ToLower() + " %" + profile->postflop->raise->chance + " $" + profile->postflop->raise->amount
						+ Environment::NewLine + "  bet " + profile->postflop->bet->enable.ToString()->ToLower() + " %" + profile->postflop->bet->chance + " $" + profile->postflop->bet->amount
						+ Environment::NewLine + "  call " + profile->postflop->call->enable.ToString()->ToLower() + " %" + profile->postflop->call->chance + " $" + profile->postflop->call->amount
						+ Environment::NewLine + "  check " + profile->postflop->check->enable.ToString()->ToLower()
						+ Environment::NewLine + "  fold " + profile->postflop->fold->enable.ToString()->ToLower()
						+ Environment::NewLine);
				}

				evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::SuccessAudit, log->collectiondaemonize);

				for( ; ; )
				{
					try
					{
						// Pause thread execution for polling interval.
						System::Threading::Thread::Sleep(config->daemonizepollinginterval);
						evtEntry = gcnew StringBuilder();

						// Lock the object for thread safe iteration.
						msclr::lock plock(Private::Logic::Globals::collection->SyncRoot);
						plock.acquire();

						for each(System::Object ^pkey in Private::Logic::Globals::collection->Keys)
						{
							// Retrieve client object with layout we're going to examine.
							Private::Logic::Objects::Process ^process = (Private::Logic::Objects::Process^)Private::Logic::Globals::collection[pkey];

							// Lock the object for thread safe iteration.
							msclr::lock glock(process->clients->SyncRoot);
							glock.acquire();

							for each(System::Object ^gkey in process->clients->Keys)
							{
								Private::Logic::Objects::Client^ client = (Private::Logic::Objects::Client^)process->clients[gkey];
								Private::Logic::Poker::Objects::State ^state = gcnew Private::Logic::Poker::Objects::State("NONE", process->pid, client->hwnd);

								if(client->layout->Count >= 1 && client->profile != nullptr)
								{
									client->layout->GetElementsFromId("tablebutton[0-9]*", state->tablebuttons);
									client->layout->GetElementsFromId("tablecard[0-9]*", state->tablecards);
									client->layout->GetElementsFromId("player[0-9]*card[0-9]*", state->playercards);
									client->layout->GetCountFromId("player[0-9]*name", state->playersactive);

									if(state->playersactive == 0) { state->playersactive = 1; }

									// Calculate pre-flop hand rank.
									if(state->tablecards->Count == 0  && state->playercards->Count == 2)
									{
										Private::Logic::Poker::Probability::PreFlop::Go(state);
										Shared::Logic::Poker::Messages::State ^smsg = Private::Logic::Poker::Convert::ObjectStateToMessageState(state);
										ServiceLogic::Messenger::BroadcastIt->SendMessage((System::Object^)smsg);
									}
									// Calculate post-flop hand rank.
									else if(state->tablecards->Count >= 3 && state->tablecards->Count <= 5 && state->playercards->Count == 2)
									{
										Private::Logic::Poker::Probability::PostFlop::Go(state);
										Shared::Logic::Poker::Messages::State ^smsg = Private::Logic::Poker::Convert::ObjectStateToMessageState(state);
										ServiceLogic::Messenger::BroadcastIt->SendMessage((System::Object^)smsg);
									}

									Private::Logic::Objects::Element ^decision = Private::Logic::Poker::HoldEm::Go(state, (Shared::Logic::Poker::Messages::Profile^)Private::Logic::Globals::logic[client->profile->GetHashCode()]);
									Shared::Logic::Messages::Element ^dmsg = gcnew Shared::Logic::Messages::Element(System::String::Empty, process->pid, client->hwnd, System::String::Empty);
									dmsg->key = decision->key;
									dmsg->id = decision->id;
									dmsg->chwnd = decision->chwnd;
									dmsg->value = decision->value;
									dmsg->amount = decision->amount;

									if(client->allowplay)
									{
										dmsg->action = "EXECUTE";
										ServiceLogic::Messenger::BroadcastIt->SendMessage((System::Object^)dmsg);
									}
									else if(client->allowmonitor)
									{
										dmsg->action = "RECOMMEND";										
										ServiceLogic::Messenger::BroadcastIt->SendMessage((System::Object^)dmsg);
									}
								}

								Shared::Logic::Messages::Client ^cmsg = gcnew Shared::Logic::Messages::Client("HEARTBEAT", process->pid, client->hwnd);
								cmsg->allowmonitor = client->allowmonitor;
								cmsg->allowplay = client->allowplay;
								cmsg->profile = client->profile;
								ServiceLogic::Messenger::BroadcastIt->SendMessage((System::Object^)cmsg);
							}
							// Release lock on the object.
							glock.release();
						}
						// Release lock on the object.
						plock.release();
					}
					catch(System::Threading::ThreadInterruptedException^ ex)
					{
						// Log the exception.
						evtEntry->Append(Environment::NewLine + String::Format("Exception: {0}. Stack trace: {1}.", ex->Message, ex->StackTrace));
						evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Warning, log->collectiondaemonize);
					}
					catch(Exception ^ex)
					{
						// Log the exception.
						evtEntry->Append(Environment::NewLine + String::Format("Exception: {0}. Stack trace: {1}.", ex->Message, ex->StackTrace));
						evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Error, log->collectiondaemonize);
					}
				}
			}
			catch(Exception^ ex)
			{
				// Log the exception.
				evtEntry->Append(Environment::NewLine + String::Format("Exception: {0}. Stack trace: {1}.", ex->Message, ex->StackTrace));
				evtLog->WriteEntry(evtEntry->ToString(), EventLogEntryType::Error, log->collectiondaemonize);
			}
			finally
			{
				evtLog->Close();
			}
		}
	protected:
		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		~Collection()
		{
			if (components)
			{
				delete components;
			}
		}
	private:
		static Shared::XML::Logic::Objects::Service::Collection^ config = Shared::XML::Logic::Reader::CollectionConfig();
		static Shared::XML::Logic::Objects::Service::Log^ log = Shared::XML::Logic::Reader::LogConfig();
		/// <summary>
		/// Required designer variable.
		/// </summary>
		System::ComponentModel::Container ^components;

#pragma region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		void InitializeComponent(void)
		{
			components = gcnew System::ComponentModel::Container();
		}
#pragma endregion
	};
}
